/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.paymentrequest;

import com.ejie.r01f.util.Initializable;
import com.ejie.r01f.util.ObjectUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import p12f.exe.pasarelapagos.objects.DatoAdicional;
import p12f.exe.pasarelapagos.objects.ModelObjectRepresentableAsXMLBase;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;

public class PaymentRequestData
extends ModelObjectRepresentableAsXMLBase
implements Serializable,
Initializable {
    private static final long serialVersionUID = -4696444569146441441L;
    public Map<String, PeticionPago> peticionesPago;
    public Map<String, DatoAdicional> datosAdicionales;

    public PaymentRequestData() {
        ObjectUtils.initialize((Object)this);
    }

    @Override
    public String toXML() throws XOMarshallerException {
        return XOManager.getXML((String)XMLProperties.get((String)"p12ft", (String)"objectMapPath"), (Object)this);
    }

    public static PaymentRequestData getObject(String xml) throws XOMarshallerException {
        return (PaymentRequestData)XOManager.getObject((String)XMLProperties.get((String)"p12ft", (String)"objectMapPath"), (String)xml);
    }

    public long getImporteTotal() {
        long total = 0L;
        Iterator<String> it = this.peticionesPago.keySet().iterator();
        while (it.hasNext()) {
            PeticionPago peticionPago = this.peticionesPago.get(it.next());
            total += peticionPago.getImporte();
        }
        return total;
    }

    public long getImporteNormalTotal() {
        long total = 0L;
        Iterator<String> it = this.peticionesPago.keySet().iterator();
        while (it.hasNext()) {
            PeriodoPago periodoPago;
            PeticionPago peticionPago = this.peticionesPago.get(it.next());
            Map<String, PeriodoPago> periodosPago = peticionPago.datosPago.periodosPago;
            if (periodosPago.get("periodoNormal") != null) {
                periodoPago = periodosPago.get("periodoNormal");
                total += periodoPago.importe;
                continue;
            }
            if (periodosPago.get("periodoVoluntario") == null) continue;
            periodoPago = periodosPago.get("periodoVoluntario");
            total += periodoPago.importe;
        }
        return total;
    }

    public String showImporteTotal() {
        long total = 0L;
        Iterator<String> it = this.peticionesPago.keySet().iterator();
        while (it.hasNext()) {
            PeticionPago peticionPago = this.peticionesPago.get(it.next());
            total += peticionPago.getImporte();
        }
        String importe = new Long(total).toString();
        while (importe.length() < 3) {
            importe = "0" + importe;
        }
        return importe.substring(0, importe.length() - 2) + "," + importe.substring(importe.length() - 2, importe.length());
    }

    public void comprobarPeriodos() {
        HashMap<String, PeticionPago> peticionesPagoTemp = new HashMap<String, PeticionPago>();
        Iterator<String> it = this.peticionesPago.keySet().iterator();
        while (it.hasNext()) {
            PeticionPago peticionPago = this.peticionesPago.get(it.next());
            try {
                peticionPago.comprobarPeriodos();
                peticionesPagoTemp.put(peticionPago.id, peticionPago);
            }
            catch (Exception e) {}
        }
        this.peticionesPago = peticionesPagoTemp;
    }
}

