/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.objects.config;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.Serializable;

public class HolderCertEventConfig
implements Serializable {
    private static final long serialVersionUID = -7657266438324449651L;
    public static final String ALL_EVENTS_ENABLE = "11111111111";
    public static final String ALL_EVENTS_DISABLE = "00000000000";
    public static final String SIMPLE_EVENTS = "10010010000";
    public static final String MULTIPLE_EVENTS = "01101101111";
    public static final String MULTIPLE_NO_BATCH_EVENTS = "01001001010";
    public static final String MULTIPLE_BATCH_EVENTS = "00100100101";
    public static final String DEFAULT_CONF_EVENTS = "100";
    private static final String ENABLE_BIT = "1";
    private static final String DISABLE_BIT = "0";
    private String eventBitMap = null;
    private String configBitMap = "100";
    private Boolean sendEventsZipped = null;

    public HolderCertEventConfig() {
    }

    public HolderCertEventConfig(String eventBitMapParam) {
        this.eventBitMap = this._getBitMapFromString(eventBitMapParam, ALL_EVENTS_ENABLE);
    }

    public HolderCertEventConfig(String eventBitMapParam, boolean sendEventsZipped) {
        this.eventBitMap = this._getBitMapFromString(eventBitMapParam, ALL_EVENTS_ENABLE);
        this.configBitMap = DEFAULT_CONF_EVENTS;
        this.setSendEventsZipped(sendEventsZipped);
    }

    public HolderCertEventConfig(String eventBitMapParam, String eventConfBitMap) {
        this.eventBitMap = this._getBitMapFromString(eventBitMapParam, ALL_EVENTS_ENABLE);
        this.configBitMap = this._getBitMapFromString(eventConfBitMap, DEFAULT_CONF_EVENTS);
    }

    public boolean isSendEventsZipped() {
        return this.configBitMap.startsWith(ENABLE_BIT);
    }

    public void setSendEventsZipped(boolean sendEventsZipped) {
        if (sendEventsZipped) {
            this.enableSendMultipleEventsZipped();
        } else {
            this.disableSendMultipleEventsZipped();
        }
    }

    public String getEventBitMap() {
        return this.eventBitMap;
    }

    public void setVoidEventBitMap() {
        this.eventBitMap = null;
    }

    public void setEventBitMap(String eventBitMapParam) {
        this.eventBitMap = this._getBitMapFromString(eventBitMapParam, ALL_EVENTS_ENABLE);
    }

    public void enableAllEvents() {
        this.eventBitMap = ALL_EVENTS_ENABLE;
    }

    public void disableAllEvents() {
        this.eventBitMap = ALL_EVENTS_DISABLE;
    }

    public void enableOnInitializeSimpleEvent() {
        this._checkBitMap(true);
        this.eventBitMap = ENABLE_BIT + this.eventBitMap.substring(1, this.eventBitMap.length());
    }

    public void disableOnInitializeSimpleEvent() {
        this._checkBitMap(false);
        this.eventBitMap = DISABLE_BIT + this.eventBitMap.substring(1, this.eventBitMap.length());
    }

    public boolean isInitializeSimpleEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(0, 1));
    }

    public void enableOnInitializeMultipleEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 1) + ENABLE_BIT + this.eventBitMap.substring(2, this.eventBitMap.length());
    }

    public void disableOnInitializeMultipleEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 1) + DISABLE_BIT + this.eventBitMap.substring(2, this.eventBitMap.length());
    }

    public boolean isInitializeMultipleEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(1, 2));
    }

    public void enableOnInitializeMultipleBatchEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 2) + ENABLE_BIT + this.eventBitMap.substring(3, this.eventBitMap.length());
    }

    public void disableOnInitializeMultipleBatchEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 2) + DISABLE_BIT + this.eventBitMap.substring(3, this.eventBitMap.length());
    }

    public boolean isInitializeMultipleBatchEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(2, 3));
    }

    public void enableOnSendSimpleEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 3) + ENABLE_BIT + this.eventBitMap.substring(4, this.eventBitMap.length());
    }

    public void disableOnSendSimpleEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 3) + DISABLE_BIT + this.eventBitMap.substring(4, this.eventBitMap.length());
    }

    public boolean isSendSimpleEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(3, 4));
    }

    public void enableOnSendMultipleEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 4) + ENABLE_BIT + this.eventBitMap.substring(5, this.eventBitMap.length());
    }

    public void disableOnSendMultipleEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 4) + DISABLE_BIT + this.eventBitMap.substring(5, this.eventBitMap.length());
    }

    public boolean isSendMultipleEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(4, 5));
    }

    public void enableOnSendMultipleBatchEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 5) + ENABLE_BIT + this.eventBitMap.substring(6, this.eventBitMap.length());
    }

    public void disableOnSendMultipleBatchEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 5) + DISABLE_BIT + this.eventBitMap.substring(6, this.eventBitMap.length());
    }

    public boolean isSendMultipleBatchEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(5, 6));
    }

    public void enableOnSetResultSimpleEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 6) + ENABLE_BIT + this.eventBitMap.substring(7, this.eventBitMap.length());
    }

    public void disableOnSetResultSimpleEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 6) + DISABLE_BIT + this.eventBitMap.substring(7, this.eventBitMap.length());
    }

    public boolean isSetResultSimpleEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(6, 7));
    }

    public void enableOnSetResultMultipleEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 7) + ENABLE_BIT + this.eventBitMap.substring(8, this.eventBitMap.length());
    }

    public void disableOnSetResultMultipleEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 7) + DISABLE_BIT + this.eventBitMap.substring(8, this.eventBitMap.length());
    }

    public boolean isSetResultMultipleEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(7, 8));
    }

    public void enableOnSetResultMultipleBatchEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 8) + ENABLE_BIT + this.eventBitMap.substring(9, this.eventBitMap.length());
    }

    public void disableOnSetResultMultipleBatchEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 8) + DISABLE_BIT + this.eventBitMap.substring(9, this.eventBitMap.length());
    }

    public boolean isSetResultMultipleBatchEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(8, 9));
    }

    public void enableOnSetPartialResultMultipleEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 9) + ENABLE_BIT + this.eventBitMap.substring(10, this.eventBitMap.length());
    }

    public void disableOnSetPartialResultMultipleEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 9) + DISABLE_BIT + this.eventBitMap.substring(10, this.eventBitMap.length());
    }

    public boolean isSetPartialResultMultipleEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(9, 10));
    }

    public void enableOnSetPartialResultMultipleBatchEvent() {
        this._checkBitMap(true);
        this.eventBitMap = this.eventBitMap.substring(0, 10) + ENABLE_BIT;
    }

    public void disableOnSetPartialResultMultipleBatchEvent() {
        this._checkBitMap(false);
        this.eventBitMap = this.eventBitMap.substring(0, 10) + DISABLE_BIT;
    }

    public boolean isSetPartialResultMultipleBatchEventEnabled() {
        if (this.eventBitMap == null) {
            return false;
        }
        return ENABLE_BIT.equals(this.eventBitMap.substring(10, 11));
    }

    public String getConfigBitMap() {
        return this.configBitMap;
    }

    public void enableSendMultipleEventsZipped() {
        this.configBitMap = ENABLE_BIT + this.configBitMap.substring(1, this.configBitMap.length());
    }

    public void disableSendMultipleEventsZipped() {
        this.configBitMap = DISABLE_BIT + this.configBitMap.substring(1, this.configBitMap.length());
    }

    public void enableSendAditonalDataInMultipleEvents() {
        this.configBitMap = this.configBitMap.substring(0, 1) + ENABLE_BIT + this.configBitMap.substring(2, this.configBitMap.length());
    }

    public void disableSendAditonalDataInMultipleEvents() {
        this.configBitMap = this.configBitMap.substring(0, 1) + DISABLE_BIT + this.configBitMap.substring(2, this.configBitMap.length());
    }

    public void enableSendAditonalDataInMultipleBatchEvents() {
        this.configBitMap = this.configBitMap.substring(0, 2) + ENABLE_BIT;
    }

    public void disableSendAditonalDataInMultipleBatchEvents() {
        this.configBitMap = this.configBitMap.substring(0, 2) + DISABLE_BIT;
    }

    public void simpleBitMapAND() {
        this.eventBitMap = this._makeANDOp(this.eventBitMap, SIMPLE_EVENTS);
    }

    public void multipleBitMapAND() {
        this.eventBitMap = this._makeANDOp(this.eventBitMap, MULTIPLE_EVENTS);
    }

    public void multipleNoBatchBitMapAND() {
        this.eventBitMap = this._makeANDOp(this.eventBitMap, MULTIPLE_NO_BATCH_EVENTS);
    }

    public void multipleBatchBitMapAND() {
        this.eventBitMap = this._makeANDOp(this.eventBitMap, MULTIPLE_BATCH_EVENTS);
    }

    public String toXML() throws XOMarshallerException {
        return XOManager.getXML((String)XMLProperties.get((String)"p12ft", (String)"objectMapPath"), (Object)this);
    }

    public static HolderCertEventConfig getObject(String xml) throws XOMarshallerException {
        HolderCertEventConfig holderCertEventConfig = (HolderCertEventConfig)XOManager.getObject((String)XMLProperties.get((String)"p12ft", (String)"objectMapPath"), (String)xml);
        if (holderCertEventConfig.sendEventsZipped != null) {
            if (holderCertEventConfig.sendEventsZipped.booleanValue()) {
                holderCertEventConfig.enableSendMultipleEventsZipped();
            } else {
                holderCertEventConfig.disableSendMultipleEventsZipped();
            }
        }
        return holderCertEventConfig;
    }

    private String _getBitMapFromString(String strBitMap, String bitMapPatron) {
        String bitMapResult = StringUtils.rPadWithChar((String)strBitMap.substring(0, Math.min(strBitMap.length(), bitMapPatron.length())), (char)'0', (int)bitMapPatron.length());
        for (int i = 0; i < bitMapPatron.length(); ++i) {
            char c = bitMapResult.charAt(i);
            if (c == '0' || c == '1') continue;
            bitMapResult = bitMapResult.substring(0, i) + DISABLE_BIT + bitMapResult.substring(i + 1, bitMapResult.length());
        }
        return bitMapResult;
    }

    private void _checkBitMap(boolean enabling) {
        if (this.eventBitMap == null) {
            if (enabling) {
                this.disableAllEvents();
            } else {
                this.enableAllEvents();
            }
        }
    }

    private String _makeANDOp(String bitMap, String key) {
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < bitMap.length(); ++i) {
            result.append((char)(bitMap.charAt(i) & key.charAt(i % key.length())));
        }
        return result.toString();
    }
}

