/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.objects;

import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.google.gwt.core.shared.GwtIncompatible;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.pasarelapagos.exceptions.PaymentException;
import p12f.exe.pasarelapagos.objects.Concepto;
import p12f.exe.pasarelapagos.objects.DatoAdicional;
import p12f.exe.pasarelapagos.objects.DatosPago;
import p12f.exe.pasarelapagos.objects.Domiciliacion;
import p12f.exe.pasarelapagos.objects.Emisor;
import p12f.exe.pasarelapagos.objects.Expediente;
import p12f.exe.pasarelapagos.objects.Imagen;
import p12f.exe.pasarelapagos.objects.Mensaje;
import p12f.exe.pasarelapagos.objects.ModelObjectRepresentableAsXMLBase;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.objects.TPVVirtual;
import p12f.exe.pasarelapagos.paymentrequest.ConceptoPeticion;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.utils.LimitDateHelper;

public class Pago
extends ModelObjectRepresentableAsXMLBase
implements Serializable {
    private static final long serialVersionUID = -5698753260504205401L;
    public String id;
    public DatosPago datosPago;
    public Map<String, String> descripcion;
    public List<Concepto> conceptos;
    public Emisor emisor;
    public Expediente expediente;
    public Map<String, Imagen> imagenes;
    public Map<String, Mensaje> mensajes;
    public Domiciliacion domiciliacion;
    public TPVVirtual tpvVirtual;
    public List<DatoAdicional> datosAdicionales;

    public Pago() {
        this.datosPago = new DatosPago();
        this.descripcion = new HashMap<String, String>();
        this.conceptos = new ArrayList<Concepto>();
        this.emisor = new Emisor();
        this.expediente = new Expediente();
        this.imagenes = new HashMap<String, Imagen>();
        this.mensajes = new HashMap<String, Mensaje>();
        this.domiciliacion = new Domiciliacion();
        this.tpvVirtual = new TPVVirtual();
        this.datosAdicionales = new ArrayList<DatoAdicional>();
    }

    @GwtIncompatible
    public Pago(PeticionPago peticionPago) throws PaymentException {
        Field[] fieldsThis = this.getClass().getDeclaredFields();
        Field thisField = null;
        Field otherField = null;
        try {
            for (int i = 0; i < fieldsThis.length; ++i) {
                thisField = fieldsThis[i];
                if (!Modifier.isPublic(thisField.getModifiers()) || (otherField = peticionPago.getClass().getField(thisField.getName())) == null) continue;
                Object objValue = otherField.get(peticionPago);
                otherField.set(this, objValue);
            }
            this._setConceptos(peticionPago.conceptos);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new PaymentException("Pago (PeticionPago peticionPago)::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new PaymentException("Pago (PeticionPago peticionPago).NoSuchFieldException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new PaymentException("Pago (PeticionPago peticionPago).IllegalAccessException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
    }

    @GwtIncompatible
    public boolean equals(Pago other) {
        Logger log = LoggerFactory.getLogger(Pago.class);
        if (!(other instanceof Pago)) {
            return false;
        }
        try {
            if (this.getClass().equals(other.getClass())) {
                Field[] fields = ReflectionUtils.getAllFieldsArray(this.getClass());
                Field f = null;
                Object thisFValue = null;
                Object otherFValue = null;
                for (int i = 0; i < fields.length; ++i) {
                    f = fields[i];
                    thisFValue = ReflectionUtils.getMemberValue((Object)this, (String)f.getName(), (boolean)false);
                    otherFValue = ReflectionUtils.getMemberValue((Object)other, (String)f.getName(), (boolean)false);
                    if (thisFValue != null && otherFValue != null && thisFValue.getClass().getName().equalsIgnoreCase("java.lang.String")) {
                        log.debug("This {} ", (Object)((String)thisFValue).length());
                        log.debug("The other {}", (Object)((String)otherFValue).length());
                    }
                    if (thisFValue != null && otherFValue != null) {
                        if (thisFValue.equals(otherFValue)) continue;
                        log.debug("Los objetos difieren en el (" + thisFValue.getClass().getName() + ")" + f.getName());
                        return false;
                    }
                    if (thisFValue == null && otherFValue == null) continue;
                    log.debug("No son iguales");
                    return false;
                }
                return true;
            }
        }
        catch (ReflectionException reflex) {
            log.debug("Excepcion :" + reflex.getDetailedMessage());
        }
        log.debug("Los objetos no son de la misma clase");
        return false;
    }

    @GwtIncompatible
    private void _setConceptos(List<Concepto> conceptosPeticionPago) throws PaymentException {
        Concepto conceptoPago = null;
        Object var3_3 = null;
        if (conceptosPeticionPago != null) {
            this.conceptos = new ArrayList<Concepto>();
            for (ConceptoPeticion conceptoPeticion : conceptosPeticionPago) {
                conceptoPago = new Concepto(conceptoPeticion);
                this.conceptos.add(conceptoPago);
            }
        }
    }

    @GwtIncompatible
    public long getImporte() {
        PeriodoPago periodoPago;
        Map<String, PeriodoPago> periodosPago = this.datosPago.periodosPago;
        Iterator<String> it = periodosPago.keySet().iterator();
        while (it.hasNext()) {
            PeriodoPago periodoPago2 = periodosPago.get(it.next());
            if (!periodoPago2.activo) continue;
            return periodoPago2.importe;
        }
        if (periodosPago.get("periodoNormal") != null) {
            periodoPago = periodosPago.get("periodoNormal");
            if (this.datosPago.formato.equals("521") || LimitDateHelper.comprobarFecha(periodoPago.fechaFin)) {
                return periodoPago.importe;
            }
        }
        if (periodosPago.get("periodoVoluntario") != null) {
            periodoPago = periodosPago.get("periodoVoluntario");
            if (LimitDateHelper.comprobarFecha(periodoPago.fechaFin)) {
                return periodoPago.importe;
            }
        }
        if (periodosPago.get("periodoConRecargo") != null) {
            periodoPago = periodosPago.get("periodoConRecargo");
            return periodoPago.importe;
        }
        return 0L;
    }

    @GwtIncompatible
    public void activarPeriodoPago(String idPeriodo) {
        Iterator<String> it = this.datosPago.periodosPago.keySet().iterator();
        while (it.hasNext()) {
            PeriodoPago periodoPago = this.datosPago.periodosPago.get(it.next());
            periodoPago.activo = false;
        }
        PeriodoPago periodoPago = this.datosPago.periodosPago.get(idPeriodo);
        periodoPago.activo = true;
    }
}

