/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.objects.ERPI;

import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import p12f.exe.pasarelapagos.objects.ERPI.ERPIEvent;
import p12f.exe.pasarelapagos.objects.ERPI.ERPIEventContext;
import p12f.exe.pasarelapagos.objects.ERPI.ERPIEventNotificationBody;

public class ERPIEventJMSHelper {
    public static ERPIEvent initializeFromTextMessage(Message msg) {
        ERPIEvent ev = new ERPIEvent();
        if (msg instanceof TextMessage) {
            TextMessage tm = (TextMessage)msg;
            try {
                ev.context = new ERPIEventContext();
                String strTimestamp = tm.getStringProperty("EventTimeStamp");
                if (strTimestamp == null || strTimestamp.equalsIgnoreCase("")) {
                    strTimestamp = "0";
                }
                ev.context.eventEntity = tm.getStringProperty("EventEntity");
                ev.context.eventWho = tm.getStringProperty("EventWho");
                ev.context.eventTipology = tm.getStringProperty("EventTipology");
                ev.context.eventWhat = tm.getStringProperty("EventWhat");
                ev.context.eventTimeStamp = Long.parseLong(strTimestamp);
                ev.context.eventCorrelationId = tm.getStringProperty("EventCorrelationId");
                ev.context.tokenSesion = tm.getStringProperty("TokenSesion");
                ev.notificationBody = ERPIEventNotificationBody.getObject(tm.getText().replaceFirst("<[?]{1}xml .*[?]{1}>", ""));
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            catch (XOMarshallerException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("*** ERROR: msg no es un TextMessage");
        }
        return ev;
    }
}

