/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.objects;

import com.ejie.r01f.util.ArrayUtils;
import java.lang.reflect.Field;
import java.util.Arrays;

public class BackendEventConstants {
    public static final String BACKEND_EVENT_SIMPLE = "simple";
    public static final String BACKEND_EVENT_GROUPED = "grouped";
    public static final String PAY_OK = "onPayOK";
    public static final String PAY_UNIDENTIFIED_OK = "onPayUnidentifiedOK";
    public static final String PAY_NO_OK = "onPayNOK";
    public static final String REFUND_OK = "onRefundOK";
    public static final String REFUND_APPROVED_OK = "onRefundApprovedOK";
    public static final String REFUND_APPROVED_NO_OK = "onRefundApprovedNOK";
    public static final String ENFORCED_OK = "onEnforcedOK";
    public static final String ENFORCED_APPROVED_OK = "onEnforcedApprovedOK";
    public static final String ENFORCED_APPROVED_NO_OK = "onEnforcedApprovedNOK";
    public static final String[] STATUS_CODE_PAY_OK = new String[]{"06"};
    public static final String[] STATUS_CODE_PAY_UNIDENTIFIED_OK = new String[]{"13"};
    public static final String[] STATUS_CODE_PAY_NO_OK = new String[]{"03", "04", "08"};
    public static final String[] STATUS_CODE_REFUND_OK = new String[]{"31"};
    public static final String[] STATUS_CODE_REFUND_APPROVED_NO_OK = new String[]{"09"};
    public static final String[] STATUS_CODE_REFUND_APPROVED_OK = new String[]{"14"};
    public static final String[] STATUS_CODE_ENFORCED_OK = new String[]{"31"};
    public static final String[] STATUS_CODE_ENFORCED_APPROVED_NO_OK = new String[]{"09"};
    public static final String[] STATUS_CODE_ENFORCED_APPROVED_OK = new String[]{"14"};
    public static final String FILE_PENDIGN = "0";
    public static final String FILE_DONE = "1";
    public static final String EVENT_PENDIGN = "0";
    public static final String EVENT_DONE = "1";
    public static final String USE_GENERAL = "00";
    public static final String USE_REFUND = "01";
    public static final String USE_ENFORCE = "02";
    public static final String LISTENER_PARAM_MODULE = "module";
    public static final String LISTENER_PARAM_FUNCTION = "function";
    public static final String LISTENER_PARAM_TYPE_GROUP = "group";
    public static final String LISTENER_PARAM_EVENT = "backendEvent";
    public static final String LISTENER_PARAM_EVENT_LIST = "backendEventList";

    private BackendEventConstants() {
    }

    public static String[] getStatusCodes() {
        Object[] resultado = new String[]{};
        Field[] fields = BackendEventConstants.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().startsWith("STATUS_CODE_")) continue;
            try {
                Object[] actStatus = (String[])fields[i].get(new Object());
                resultado = (String[])ArrayUtils.addAll((Object[])resultado, (Object[])actStatus);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return resultado;
    }

    public static String getComputedEvent(String status, String use) {
        if (Arrays.asList(STATUS_CODE_PAY_OK).contains(status)) {
            return PAY_OK;
        }
        if (Arrays.asList(STATUS_CODE_PAY_UNIDENTIFIED_OK).contains(status)) {
            return PAY_UNIDENTIFIED_OK;
        }
        if (Arrays.asList(STATUS_CODE_PAY_NO_OK).contains(status)) {
            return PAY_NO_OK;
        }
        if (USE_REFUND.equals(use)) {
            if (Arrays.asList(STATUS_CODE_REFUND_OK).contains(status)) {
                return REFUND_OK;
            }
            if (Arrays.asList(STATUS_CODE_REFUND_APPROVED_NO_OK).contains(status)) {
                return REFUND_APPROVED_NO_OK;
            }
            if (Arrays.asList(STATUS_CODE_REFUND_APPROVED_OK).contains(status)) {
                return REFUND_APPROVED_OK;
            }
        } else if (USE_ENFORCE.equals(use)) {
            if (Arrays.asList(STATUS_CODE_ENFORCED_OK).contains(status)) {
                return ENFORCED_OK;
            }
            if (Arrays.asList(STATUS_CODE_ENFORCED_APPROVED_NO_OK).contains(status)) {
                return ENFORCED_APPROVED_NO_OK;
            }
            if (Arrays.asList(STATUS_CODE_ENFORCED_APPROVED_OK).contains(status)) {
                return ENFORCED_APPROVED_OK;
            }
        }
        return null;
    }
}

