/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.helpers;

import com.ejie.r01f.rpcdispatcher.RPCCall;
import com.ejie.r01f.rpcdispatcher.RPCFunction;
import com.ejie.r01f.rpcdispatcher.RPCParameter;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.pasarelapagos.exceptions.GatewayException;
import p12f.exe.pasarelapagos.paymentrequest.PaymentGatewayData;
import p12f.exe.pasarelapagos.paymentrequest.PaymentRequestData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;

public class SenderHelper {
    private static final Logger log = LoggerFactory.getLogger(SenderHelper.class);

    public static String getHTMLPaymentGatewayDataPostCode(PaymentGatewayData data, String url) {
        StringBuffer code = new StringBuffer();
        try {
            PaymentRequestData paymentRequestData = data.paymentRequestData;
            String oids = "";
            Iterator<String> it = paymentRequestData.peticionesPago.keySet().iterator();
            while (it.hasNext()) {
                PeticionPago peticionPago = paymentRequestData.peticionesPago.get(it.next());
                if (peticionPago.validacion != null && !peticionPago.validacion.valido) {
                    log.debug("ERROR: La peticion de pago " + peticionPago.id + " no ha superado la validacion.");
                    log.debug("Error de validacion: " + peticionPago.validacion.mensaje);
                    continue;
                }
                oids = oids + peticionPago.id + ",";
            }
            log.debug("[P12F][SenderHelper] getHTMLPaymentGatewayDataPostCode(...): Composing HTML autosubmit through PaymentGatewayData...");
            code.append("<html>");
            code.append("<head>");
            code.append("<meta http-equiv='Expires'content='Tue, 01 Jan 1980 1:00:00 GMT'/>");
            code.append("<meta http-equiv='Pragma' content='no-cache'/>");
            code.append("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' />");
            code.append("</head>");
            code.append("<body>");
            code.append("<form name='p12FormOids' id='p12FormOids' method='POST' action='" + url + "'>");
            code.append("<input type='hidden' name='module' value='IU'/>");
            code.append("<input type='hidden' name='p12iOidsPago' value=\"" + oids + "\"/>");
            code.append("<input type='hidden' name='p12iPaymentGatewayData' value=\"" + data.toXML() + "\"/>");
            code.append("</form>");
            code.append("<script language='JavaScript'>");
            code.append("document.getElementById('p12FormOids').submit();");
            code.append("</script>");
            code.append("</body>");
            code.append("</html>");
        }
        catch (XOMarshallerException xox) {
            xox.printStackTrace();
        }
        return code.toString();
    }

    public static String getHTMLPostCode(PaymentGatewayData data, String url) {
        StringBuffer code = new StringBuffer();
        try {
            PaymentRequestData paymentRequestData = data.paymentRequestData;
            String oids = "";
            Iterator<String> it = paymentRequestData.peticionesPago.keySet().iterator();
            while (it.hasNext()) {
                PeticionPago peticionPago = paymentRequestData.peticionesPago.get(it.next());
                if (peticionPago.validacion != null && !peticionPago.validacion.valido) {
                    log.debug("ERROR: La peticion de pago " + peticionPago.id + " no ha superado la validacion.");
                    log.debug("Error de validacion: " + peticionPago.validacion.mensaje);
                    continue;
                }
                oids = oids + peticionPago.id + ",";
            }
            log.debug("[P12F][SenderHelper] getHTMLPostCode(...):  Composing HTML autosubmit through PaymentGatewayData...");
            code.append("<html>");
            code.append("<head>");
            code.append("<meta http-equiv='Expires'content='Tue, 01 Jan 1980 1:00:00 GMT'/>");
            code.append("<meta http-equiv='Pragma' content='no-cache'/>");
            code.append("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' />");
            code.append("</head>");
            code.append("<body>");
            code.append("<form name='p12FormOids' id='p12FormOids' method='POST' action='" + url + "'>");
            code.append("<input type='hidden' name='module' value='IU'/>");
            code.append("<input type='hidden' name='p12iOidsPago' value=\"" + oids + "\"/>");
            code.append("<input type='hidden' name='p12iPresentationRequestData' value=\"" + data.presentationData.toXML() + "\"/>");
            code.append("<input type='hidden' name='p12iProtocolData' value=\"" + data.protocolData.toXML() + "\"/>");
            code.append("</form>");
            code.append("<script language='JavaScript'>");
            code.append("document.getElementById('p12FormOids').submit();");
            code.append("</script>");
            code.append("</body>");
            code.append("</html>");
        }
        catch (XOMarshallerException xox) {
            xox.printStackTrace();
        }
        return code.toString();
    }

    public static String getHTMLPostCode(Map parameters, String url) throws GatewayException {
        try {
            StringBuffer code = new StringBuffer();
            code.append("<html>");
            code.append("<head>");
            code.append("<meta http-equiv='Expires'content='Tue, 01 Jan 1980 1:00:00 GMT'/>");
            code.append("<meta http-equiv='Pragma' content='no-cache'/>");
            code.append("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' />");
            code.append("</head>");
            code.append("<body>");
            code.append("<form name='p12FormOids' id='p12FormOids' method='POST' action='" + url + "'>");
            code.append("<input type='hidden' name='module' value='IU'/>");
            Set set = parameters.entrySet();
            for (Map.Entry entry : set) {
                String paramName = (String)entry.getKey();
                String[] paramValues = (String[])entry.getValue();
                if (paramValues.length != 1) continue;
                log.debug("============================");
                log.debug("paranName :" + paramName);
                String paramValue = paramValues[0];
                log.debug("paramValue :" + paramValue);
                log.debug("============================");
                if (paramValue.length() == 0) continue;
                code.append("<input type='hidden' name='" + paramName + "' value=\"" + paramValue + "\"/>");
            }
            code.append("</form>");
            code.append("<script language='JavaScript'>");
            code.append("document.getElementById('p12FormOids').submit();");
            code.append("</script>");
            code.append("</body>");
            code.append("</html>");
            return code.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new GatewayException(ex);
        }
    }

    public static String getHTMLJustificantePostCodeByOids(String oids, String idioma, String url) {
        StringBuffer code = new StringBuffer();
        try {
            log.debug("Function getHTMLJustificantePostCodeByOids");
            log.debug("===========================================");
            RPCCall rpcCall = new RPCCall();
            RPCFunction rpcFuncion = new RPCFunction();
            rpcCall.setModule("IJ");
            rpcFuncion.setName("iniciarPago");
            rpcFuncion.putParameter(new RPCParameter("oids", "String", oids));
            rpcFuncion.putParameter(new RPCParameter("idioma", "String", idioma));
            rpcFuncion.putParameter(new RPCParameter("CPR", "String", ""));
            rpcFuncion.putParameter(new RPCParameter("lotes", "String", "true"));
            rpcCall.addFunction(rpcFuncion);
            log.debug("rpcCall=" + rpcCall.toXML());
            code.append("<html>");
            code.append("<head>");
            code.append("<meta http-equiv='Expires'content='Tue, 01 Jan 1980 1:00:00 GMT'/>");
            code.append("<meta http-equiv='Pragma' content='no-cache'/>");
            code.append("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' />");
            code.append("</head>");
            code.append("<body>");
            code.append("<form name='p12FormOids' id='p12FormOids' method='POST' action='" + url + "' enctype='application/x-www-form-urlencoded;charset=ISO-8859-1'> ");
            code.append("<input type='hidden' name='xmlRPC' value=\"" + rpcCall.toXML() + "\"/>");
            code.append("<input type='hidden' name='function' value='iniciarPago'/>");
            code.append("</form>");
            code.append("<script language='JavaScript'>");
            code.append("document.getElementById('p12FormOids').submit();");
            code.append("</script>");
            code.append("</body>");
            code.append("</html>");
        }
        catch (Exception xox) {
            xox.printStackTrace();
        }
        log.debug(code.toString());
        return code.toString();
    }

    public static String redirigirEntidadV1(String pagoXML, String url) {
        StringBuffer code = new StringBuffer();
        code.append("<html>");
        code.append("<head>");
        code.append("<meta http-equiv='Expires'content='Tue, 01 Jan 1980 1:00:00 GMT'>");
        code.append("<meta http-equiv='Pragma' content='no-cache'>");
        code.append("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' />");
        code.append("</head>");
        code.append("<body>");
        code.append("<form name='pagoForm' id='pagoForm' method='post' action='" + url + "' target='_self' enctype='application/x-www-form-urlencoded;charset=ISO-8859-1'>");
        code.append("<input type='hidden' name='xmlPago' value=\"" + pagoXML + "\">");
        code.append("<input type='hidden' name='idOrigen' value='EJ'>");
        code.append("</form>");
        code.append("<script language='JavaScript'>");
        code.append("document.getElementById('pagoForm').submit();");
        code.append("</script>");
        code.append("</body>");
        code.append("</html>");
        return code.toString();
    }

    public static String redirigirEntidadV2(String paymentDataXML, String presentationDataXML, String protocolDataXML, String url) {
        StringBuffer code = new StringBuffer();
        code.append("<html>");
        code.append("<head>");
        code.append("<meta http-equiv='Expires'content='Tue, 01 Jan 1980 1:00:00 GMT'>");
        code.append("<meta http-equiv='Pragma' content='no-cache'>");
        code.append("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' />");
        code.append("</head>");
        code.append("<body>");
        code.append("<form name='pagoForm' id='pagoForm' method='post' action='" + url + "' target='_self' enctype='application/x-www-form-urlencoded;charset=ISO-8859-1'>");
        code.append("<input type='hidden' name='function' value='setPaymentData'>");
        code.append("<input type='hidden' name='paymentData' value=\"" + paymentDataXML + "\">");
        code.append("<input type='hidden' name='presentationData' value=\"" + presentationDataXML + "\">");
        code.append("<input type='hidden' name='protocolData' value=\"" + protocolDataXML + "\">");
        code.append("</form>");
        code.append("<script language='JavaScript'>");
        code.append("document.getElementById('pagoForm').submit();");
        code.append("</script>");
        code.append("</body>");
        code.append("</html>");
        return code.toString();
    }

    public static String redirigirEntidadV2conAlert(String paymentDataXML, String presentationDataXML, String protocolDataXML, String url, String mensaje) {
        StringBuffer code = new StringBuffer();
        code.append("<html>");
        code.append("<head>");
        code.append("<meta http-equiv='Expires'content='Tue, 01 Jan 1980 1:00:00 GMT'>");
        code.append("<meta http-equiv='Pragma' content='no-cache'>");
        code.append("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1' />");
        code.append("</head>");
        code.append("<body>");
        code.append("<form name='pagoForm' id='pagoForm' method='post' action='" + url + "' target='_self' enctype='application/x-www-form-urlencoded;charset=ISO-8859-1'>");
        code.append("<input type='hidden' name='function' value='setPaymentData'>");
        code.append("<input type='hidden' name='paymentData' value=\"" + paymentDataXML + "\">");
        code.append("<input type='hidden' name='presentationData' value=\"" + presentationDataXML + "\">");
        code.append("<input type='hidden' name='protocolData' value=\"" + protocolDataXML + "\">");
        code.append("</form>");
        code.append("<script language='JavaScript'>");
        code.append("alert('" + mensaje + "');");
        code.append("document.getElementById('pagoForm').submit();");
        code.append("</script>");
        code.append("</body>");
        code.append("</html>");
        return code.toString();
    }
}

