/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.helpers;

import com.ejie.r01f.servlet.upload.FilePart;
import com.ejie.r01f.servlet.upload.MultipartParser;
import com.ejie.r01f.servlet.upload.Part;
import com.ejie.r01f.servlet.upload.PartDigester;
import com.ejie.r01f.servlet.upload.PartDigesterException;
import com.ejie.r01f.util.encoders.BASE64Decoder;
import com.ejie.r01f.util.encoders.BASE64Encoder;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadHelper {
    private static final Logger log = LoggerFactory.getLogger(FileUploadHelper.class);

    public String[] uploadRequestFiles(String appCode, String partDigesterID, HttpServletRequest request) throws ServletException {
        log.debug("\n\n\n\n>>>>>>>>>>uploadRequestFiles.................");
        PartDigester partDigester = null;
        ArrayList<String> uploadedFiles = new ArrayList<String>();
        try {
            int maxFileSize = 0x100000;
            if (appCode != null) {
                maxFileSize = XMLProperties.getInt((String)appCode, (String)"uploadServlet/maxFileSize");
            }
            MultipartParser parser = new MultipartParser(request, maxFileSize);
            Part currPart = null;
            String serverUploadPath = XMLProperties.get((String)appCode, (String)("uploadServlet/digesters/digester[@id='" + partDigesterID + "']/config/dir"));
            while ((currPart = parser.readNextPart()) != null) {
                if (currPart.isFile() || currPart.getName().equalsIgnoreCase("file")) {
                    FilePart filePart = (FilePart)currPart;
                    String fileName = filePart.getFileName() == null ? "" : filePart.getFileName();
                    String mimeType = filePart.getContentType() == null ? "" : filePart.getContentType();
                    log.debug(">>> Recibido Fichero tipo '" + mimeType + "': '" + fileName + "'");
                    if (fileName == null || fileName.length() <= 0) continue;
                    List allowedMimeTypes = XMLProperties.getPropertyList((String)appCode, (String)("uploadServlet/digesters/digester[@id='" + partDigesterID + "']/allowedMimeTypes/mimeType"));
                    if (allowedMimeTypes != null) {
                        boolean mimeTypeAllowed = false;
                        Iterator mit = allowedMimeTypes.iterator();
                        while (mit.hasNext()) {
                            if (!((String)mit.next()).equals(mimeType)) continue;
                            mimeTypeAllowed = true;
                            break;
                        }
                        if (!mimeTypeAllowed) {
                            throw new ServletException("El mime-type: " + mimeType + " NO esta permitido. Revisa la configuracion del digester");
                        }
                    } else {
                        log.debug(">>NO se hace comprobacion del mime-type ya que no se ha configurado en el digester!");
                    }
                    if (partDigester == null) {
                        partDigester = this._getPartDigesterInstance(appCode, partDigesterID);
                    }
                    partDigester.digestFilePart(filePart);
                    uploadedFiles.add(serverUploadPath + File.separator + fileName);
                    continue;
                }
                log.debug(">>> Part NO reconocida. No es un parametro ni un fichero!!!!");
            }
            log.debug("<<<<<<<<<<uploadRequestFiles.................\n\n\n\n");
        }
        catch (IOException ioEx) {
            throw new ServletException((Throwable)ioEx);
        }
        catch (PartDigesterException partDigEx) {
            throw new ServletException((Throwable)partDigEx);
        }
        return uploadedFiles.toArray(new String[uploadedFiles.size()]);
    }

    public String[] uploadRequestFiles(String appCode, String partDigesterID, HttpServletRequest request, String tmpId) throws ServletException {
        if (tmpId == null || "".equals(tmpId)) {
            return this.uploadRequestFiles(appCode, partDigesterID, request);
        }
        log.debug("\n\n\n\n>>>>>>>>>>uploadRequestFiles.................");
        PartDigester partDigester = null;
        ArrayList<String> uploadedFiles = new ArrayList<String>();
        try {
            int maxFileSize = 0x100000;
            if (appCode != null) {
                maxFileSize = XMLProperties.getInt((String)appCode, (String)"uploadServlet/maxFileSize");
            }
            MultipartParser parser = new MultipartParser(request, maxFileSize);
            Part currPart = null;
            String serverUploadPath = XMLProperties.get((String)appCode, (String)("uploadServlet/digesters/digester[@id='" + partDigesterID + "']/config/dir")) + '/' + tmpId;
            File fAux = new File(serverUploadPath);
            if (!fAux.exists()) {
                fAux.mkdir();
            }
            while ((currPart = parser.readNextPart()) != null) {
                if (currPart.isFile() || currPart.getName().equalsIgnoreCase("file")) {
                    FilePart filePart = (FilePart)currPart;
                    String fileName = filePart.getFileName() == null ? "" : filePart.getFileName();
                    String mimeType = filePart.getContentType() == null ? "" : filePart.getContentType();
                    log.debug(">>> Recibido Fichero tipo '" + mimeType + "': '" + fileName + "'");
                    if (fileName == null || fileName.length() <= 0) continue;
                    List allowedMimeTypes = XMLProperties.getPropertyList((String)appCode, (String)("uploadServlet/digesters/digester[@id='" + partDigesterID + "']/allowedMimeTypes/mimeType"));
                    if (allowedMimeTypes != null) {
                        boolean mimeTypeAllowed = false;
                        Iterator mit = allowedMimeTypes.iterator();
                        while (mit.hasNext()) {
                            if (!((String)mit.next()).equals(mimeType)) continue;
                            mimeTypeAllowed = true;
                            break;
                        }
                        if (!mimeTypeAllowed) {
                            throw new ServletException("El mime-type: " + mimeType + " NO esta permitido. Revisa la configuracion del digester");
                        }
                    } else {
                        log.debug(">>NO se hace comprobacion del mime-type ya que no se ha configurado en el digester!");
                    }
                    if (partDigester == null) {
                        partDigester = this._getPartDigesterInstance(appCode, partDigesterID, tmpId);
                    }
                    partDigester.digestFilePart(filePart);
                    uploadedFiles.add(serverUploadPath + File.separator + fileName);
                    continue;
                }
                log.debug(">>> Part NO reconocida. No es un parametro ni un fichero!!!!");
            }
            log.debug("<<<<<<<<<<uploadRequestFiles.................\n\n\n\n");
        }
        catch (IOException ioEx) {
            throw new ServletException((Throwable)ioEx);
        }
        catch (PartDigesterException partDigEx) {
            throw new ServletException((Throwable)partDigEx);
        }
        return uploadedFiles.toArray(new String[uploadedFiles.size()]);
    }

    private PartDigester _getPartDigesterInstance(String appCode, String partDigesterID) throws ServletException, PartDigesterException {
        if (appCode == null) {
            throw new ServletException("UploadServlet configuration error: No se puede obtener la configuracion ya que no se ha especificado la propiedad appCode en el fichero web.xml o no se ha recibido el parametro de la request appCode");
        }
        if (partDigesterID == null) {
            throw new ServletException("UploadServlet configuration error: No se ha recibido el parametro digesterID");
        }
        try {
            PartDigester partDigester = null;
            String partDigesterClassName = XMLProperties.getString((String)appCode, (String)("uploadServlet/digesters/digester[@id='" + partDigesterID + "']/class"));
            Properties partDigesterProperties = XMLProperties.getProperties((String)appCode, (String)("uploadServlet/digesters/digester[@id='" + partDigesterID + "']/config"));
            if (partDigesterProperties == null) {
                partDigesterProperties = new Properties();
            }
            partDigesterProperties.setProperty("appCode", appCode);
            if (partDigesterClassName == null) {
                throw new ServletException("UploadServlet configuration error: uploadServlet/digesters/digester[@id='" + partDigesterID + "']/class not found in " + appCode + ".properties file");
            }
            log.debug(">>> Instanciando clase digester de los parts: '" + partDigesterClassName + "'");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> partDigesterClass = cl.loadClass(partDigesterClassName);
            partDigester = (PartDigester)partDigesterClass.newInstance();
            partDigester.setConfig(partDigesterProperties);
            return partDigester;
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServletException("ClassNotFoundException in UploadServlet: " + cnfEx.toString(), (Throwable)cnfEx);
        }
        catch (IllegalAccessException illAccEx) {
            throw new ServletException("IllegalAccessException in UploadServlet: " + illAccEx.toString(), (Throwable)illAccEx);
        }
        catch (InstantiationException instEx) {
            throw new ServletException("InstantiationException in UploadServlet: " + instEx.toString(), (Throwable)instEx);
        }
    }

    private PartDigester _getPartDigesterInstance(String appCode, String partDigesterID, String tmpId) throws ServletException, PartDigesterException {
        if (tmpId == null || "".equals(tmpId)) {
            return this._getPartDigesterInstance(appCode, partDigesterID);
        }
        if (appCode == null) {
            throw new ServletException("UploadServlet configuration error: No se puede obtener la configuracion ya que no se ha especificado la propiedad appCode en el fichero web.xml o no se ha recibido el parametro de la request appCode");
        }
        if (partDigesterID == null) {
            throw new ServletException("UploadServlet configuration error: No se ha recibido el parametro digesterID");
        }
        try {
            PartDigester partDigester = null;
            String partDigesterClassName = XMLProperties.getString((String)appCode, (String)("uploadServlet/digesters/digester[@id='" + partDigesterID + "']/class"));
            Properties partDigesterProperties = XMLProperties.getProperties((String)appCode, (String)("uploadServlet/digesters/digester[@id='" + partDigesterID + "']/config"));
            if (partDigesterProperties == null) {
                partDigesterProperties = new Properties();
            }
            partDigesterProperties.setProperty("appCode", appCode);
            if (partDigesterProperties.containsKey("dir")) {
                partDigesterProperties.setProperty("dir", partDigesterProperties.getProperty("dir") + '/' + tmpId);
            }
            if (partDigesterClassName == null) {
                throw new ServletException("UploadServlet configuration error: uploadServlet/digesters/digester[@id='" + partDigesterID + "']/class not found in " + appCode + ".properties file");
            }
            log.debug(">>> Instanciando clase digester de los parts: '" + partDigesterClassName + "'");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> partDigesterClass = cl.loadClass(partDigesterClassName);
            partDigester = (PartDigester)partDigesterClass.newInstance();
            partDigester.setConfig(partDigesterProperties);
            return partDigester;
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ServletException("ClassNotFoundException in UploadServlet: " + cnfEx.toString(), (Throwable)cnfEx);
        }
        catch (IllegalAccessException illAccEx) {
            throw new ServletException("IllegalAccessException in UploadServlet: " + illAccEx.toString(), (Throwable)illAccEx);
        }
        catch (InstantiationException instEx) {
            throw new ServletException("InstantiationException in UploadServlet: " + instEx.toString(), (Throwable)instEx);
        }
    }

    public static String getContentInBase64(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] fileContent = new byte[(int)file.length()];
        fileInputStream.read(fileContent);
        fileInputStream.close();
        BASE64Encoder base64Encoder = new BASE64Encoder();
        String base64Data = base64Encoder.encodeBuffer(fileContent);
        return base64Data;
    }

    public static void putContentFromBase64(String base64Data, File file, int maxFileSize) throws IOException {
        BASE64Decoder base64Decoder = new BASE64Decoder();
        byte[] fileContent = base64Decoder.decodeBuffer(base64Data);
        if (fileContent.length > maxFileSize) {
            throw new IOException("El tama\u00f1o del fichero supera el l\u00edmite de " + maxFileSize + " bytes");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(fileContent);
        fileOutputStream.close();
    }
}

