/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.helpers;

import com.ejie.r01f.rpcdispatcher.RPCException;
import com.ejie.r01f.util.encoders.BASE64Decoder;
import com.ejie.r01f.util.encoders.BASE64Encoder;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.data.DataFileResponse;
import p12f.exe.pasarelapagos.paymentrequest.PaymentRequestData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.paymentrequest.PresentationRequestData;
import p12f.exe.pasarelapagos.transformer.ObjectTransformer;
import p12f.exe.pasarelapagos.transformer.ObjectTransformerException;
import p12f.exe.pasarelapagos.utils.fop.XMLTransformer;

public class DataFileUtils {
    private static final Logger log = LoggerFactory.getLogger(DataFileUtils.class);

    private DataFileUtils() {
    }

    public static byte[] getFileBytes(File f) throws IOException {
        if (f.isFile()) {
            return FileUtils.readFileToByteArray((File)f);
        }
        File[] files = f.listFiles();
        if (DataFileUtils.getFileSize(f) == 0L) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zipfile = new ZipOutputStream(bos);
        ZipEntry zipentry = null;
        for (int i = 0; i < files.length; ++i) {
            File dirEntry = files[i];
            if (dirEntry.isDirectory()) {
                String dirName = dirEntry.getName();
                DataFileUtils._addDirectoryToZip(zipfile, dirEntry, dirName);
                continue;
            }
            zipentry = new ZipEntry(dirEntry.getName());
            zipfile.putNextEntry(zipentry);
            zipfile.write(DataFileUtils.getFileBytes(dirEntry));
        }
        zipfile.close();
        return bos.toByteArray();
    }

    public static byte[] getFileListBytes(String[] filesPath) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zipfile = new ZipOutputStream(bos);
        ZipEntry zipentry = null;
        long zipSize = 0L;
        for (int i = 0; i < filesPath.length; ++i) {
            File dirEntry = new File(filesPath[i]);
            zipSize += DataFileUtils.getFileSize(dirEntry);
            if (dirEntry.isDirectory()) {
                String dirName = dirEntry.getName();
                DataFileUtils._addDirectoryToZip(zipfile, dirEntry, dirName);
                continue;
            }
            zipentry = new ZipEntry(dirEntry.getName());
            zipfile.putNextEntry(zipentry);
            zipfile.write(DataFileUtils.getFileBytes(dirEntry));
        }
        zipfile.close();
        if (zipSize == 0L) {
            return null;
        }
        return bos.toByteArray();
    }

    public static long getFileSize(File f) throws IOException {
        if (f.isFile()) {
            return f.length();
        }
        return FileUtils.sizeOfDirectory((File)f);
    }

    public static DataFileResponse renameFile(String oldNamePath, String newName) {
        DataFileResponse response = new DataFileResponse();
        File f = new File(oldNamePath);
        String path = f.getParent();
        File fNew = new File(path + File.separator + newName);
        if (fNew.exists()) {
            response.setResponseCode(0);
            return response;
        }
        try {
            f.renameTo(fNew);
            response.setResponseCode(1);
        }
        catch (Exception e) {
            response.setResponseCode(-1);
            response.setResponse(e.getMessage());
        }
        return response;
    }

    public static DataFileResponse uploadFile(String path, String base64content, boolean rewriteFiles) {
        DataFileResponse response = new DataFileResponse();
        try {
            File f = new File(path);
            if (f.exists() && !rewriteFiles) {
                response.setResponseCode(0);
            } else {
                BASE64Decoder base64Decoder = new BASE64Decoder();
                byte[] data = base64Decoder.decodeBuffer(base64content);
                FileUtils.writeByteArrayToFile((File)f, (byte[])data);
                response.setResponseCode(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setResponseCode(-1);
            response.setResponse(e.getMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataFileResponse uploadAndUnzipFile(String path, String base64content, boolean rewriteFiles) {
        DataFileResponse response = new DataFileResponse();
        StringBuffer noRewritedFiles = new StringBuffer("");
        boolean anyFileRewrite = false;
        BASE64Decoder base64Decoder = new BASE64Decoder();
        ZipInputStream zin = null;
        FileOutputStream fout = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(base64Decoder.decodeBuffer(base64content));
            zin = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                int c;
                log.debug("Unzipping " + ze.getName());
                File f = new File(path + File.separator + ze.getName());
                boolean isDirectory = ze.getName().endsWith("/");
                boolean rewriteFile = true;
                if (isDirectory) {
                    if (!f.exists()) {
                        log.debug("Crear directorio " + ze.getName());
                        f.mkdir();
                    }
                } else if (!rewriteFiles && f.exists()) {
                    log.debug("No se sobreescribe " + ze.getName());
                    rewriteFile = false;
                    anyFileRewrite = true;
                    noRewritedFiles.append(ze.getName()).append(File.pathSeparator);
                }
                if (!isDirectory && rewriteFile) {
                    fout = new FileOutputStream(f);
                    log.debug("Extraer " + ze.getName());
                    c = zin.read();
                    while (c != -1) {
                        fout.write(c);
                        c = zin.read();
                    }
                    fout.close();
                } else {
                    c = zin.read();
                    while (c != -1) {
                        c = zin.read();
                    }
                }
                zin.closeEntry();
            }
            zin.close();
            if (anyFileRewrite) {
                response.setResponseCode(0);
                response.setResponse(noRewritedFiles.toString());
            } else {
                response.setResponseCode(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setResponseCode(-1);
            response.setResponse(e.getMessage());
        }
        finally {
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException e) {}
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {}
            }
        }
        return response;
    }

    public static boolean changePermissions(String completeFileName, int permissions) {
        File f = new File(completeFileName);
        if (f.exists() && DataFileUtils._checkPermissions(permissions)) {
            try {
                log.debug("chmod " + permissions + " " + completeFileName);
                Runtime.getRuntime().exec("chmod " + permissions + " " + completeFileName);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void _addDirectoryToZip(ZipOutputStream zipfile, File dir, String basePath) {
        try {
            File[] files = dir.listFiles();
            ZipEntry zipentry = null;
            for (int i = 0; i < files.length; ++i) {
                File dirEntry = files[i];
                if (dirEntry.isDirectory()) {
                    DataFileUtils._addDirectoryToZip(zipfile, dirEntry, basePath + File.separator + dirEntry.getName());
                    continue;
                }
                zipentry = new ZipEntry(basePath + File.separator + dirEntry.getName());
                zipfile.putNextEntry(zipentry);
                zipfile.write(DataFileUtils.getFileBytes(dirEntry));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean _checkPermissions(int permissions) {
        return permissions <= 777;
    }

    public static String doBuildPaymentReceiptFile(PaymentRequestData paymentRequestData, PresentationRequestData presentationRequestData, ProtocolData protocolData) {
        PeticionPago peticionPago = null;
        try {
            if (paymentRequestData.peticionesPago.size() == 1) {
                Iterator<String> it = paymentRequestData.peticionesPago.keySet().iterator();
                peticionPago = paymentRequestData.peticionesPago.get(it.next());
                String paymentGatewayVersion = peticionPago.liquidacion.paymentGatewayVersion;
                String xsl = peticionPago.liquidacion.urlPlantilla;
                log.debug("> urlPlantilla: " + xsl);
                File plantillaXSL = new File(xsl);
                String xml = null;
                if (paymentGatewayVersion.equals("1")) {
                    p12f.exe.pasarelapagos.v1.objects.PeticionPago peticionPagoVieja = DataFileUtils._getPeticionPagoV1(paymentRequestData.toXML(), presentationRequestData.toXML(), protocolData.toXML());
                    log.debug("[P12F -DATA][Peticion de Pago V1:\n" + peticionPagoVieja.toXML() + "\n\n\n");
                    xml = peticionPagoVieja.toXML();
                } else if (paymentGatewayVersion.equals("2")) {
                    log.debug("[P12F - DATA][doBuildPaymentReceiptFile] PaymentRequestData V2:\n" + paymentRequestData.toXML() + "\n\n\n");
                    xml = paymentRequestData.toXML();
                }
                byte[] pdf = XMLTransformer.getPDF(xml, plantillaXSL);
                BASE64Encoder base64Decoder = new BASE64Encoder();
                String data = base64Decoder.encodeBuffer(pdf);
                return data;
            }
            String resultStream = null;
            String xml = null;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PDFMergerUtility mergepdf = new PDFMergerUtility();
            mergepdf.setDestinationStream((OutputStream)out);
            ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
            Iterator<String> it = paymentRequestData.peticionesPago.keySet().iterator();
            while (it.hasNext()) {
                peticionPago = paymentRequestData.peticionesPago.get(it.next());
                String paymentGatewayVersion = peticionPago.liquidacion.paymentGatewayVersion;
                PaymentRequestData paymentRequestDataAux = new PaymentRequestData();
                paymentRequestDataAux.peticionesPago.put(peticionPago.id, peticionPago);
                paymentRequestDataAux.datosAdicionales = paymentRequestData.datosAdicionales;
                String paymentRequestDataAuxXML = paymentRequestDataAux.toXML();
                String xsl = peticionPago.liquidacion.urlPlantilla;
                log.debug("> urlPlantilla: " + xsl);
                File plantillaXSL = new File(xsl);
                if (paymentGatewayVersion.equals("1")) {
                    p12f.exe.pasarelapagos.v1.objects.PeticionPago peticionPagoVieja = DataFileUtils._getPeticionPagoV1(paymentRequestData.toXML(), presentationRequestData.toXML(), protocolData.toXML());
                    log.debug("[P12f][P12F - DATA] Peticion de Pago V1:\n" + peticionPagoVieja.toXML() + "\n\n\n");
                    xml = peticionPagoVieja.toXML();
                } else if (paymentGatewayVersion.equals("2")) {
                    log.debug("[P12f][P12F - DATA] PaymentRequestData V2:\n" + paymentRequestDataAuxXML + "\n\n\n");
                    xml = paymentRequestDataAuxXML;
                }
                byte[] pdfAux = XMLTransformer.getPDF(xml, plantillaXSL);
                ByteArrayInputStream pdf = new ByteArrayInputStream(pdfAux);
                pdfs.add(pdf);
            }
            mergepdf.addSources(pdfs);
            mergepdf.mergeDocuments();
            BASE64Encoder base64Decoder = new BASE64Encoder();
            resultStream = base64Decoder.encodeBuffer(out.toByteArray());
            mergepdf.getDestinationStream().flush();
            mergepdf.getDestinationStream().close();
            return resultStream;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static p12f.exe.pasarelapagos.v1.objects.PeticionPago _getPeticionPagoV1(String paymentRequestDataXML, String presentationRequestDataXML, String protocolDataXML) throws RPCException, XOMarshallerException, ObjectTransformerException {
        ObjectTransformer transformer = new ObjectTransformer();
        p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago = transformer.transformToOldPaymentData(paymentRequestDataXML, presentationRequestDataXML, protocolDataXML);
        return oldPeticionPago;
    }
}

