/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.exceptions;

import p12f.exe.pasarelapagos.exceptions.PaymentRefundException;
import p12f.exe.pasarelapagos.utils.SanitizeConstants;

public class PaymentRefundExceptionErrors {
    public static PaymentRefundException getPaymentRefundExceptionByCode(REFUND_EXCEPTIONS refundException, String paymentID) {
        return new PaymentRefundException(refundException.getExceptionErrorCode(), refundException.getExceptionMessage() + "(PAYMENT ID: " + paymentID + ")");
    }

    public static enum REFUND_EXCEPTIONS implements SanitizeConstants.EnumExtended<String>
    {
        UNAUTHORIZED_REFUND(0L, "El pago no se puede devolver ya que no dispone de permisos en dicha entidad."),
        ALREADY_REFUNDED(1L, "El pago no se puede devolver ya que ya ha sido devuelto."),
        HAS_BACKEND(2L, "El pago no se puede devolver ya que ha sido procesado con respuesta backend."),
        NOT_PAID(3L, "El pago no se puede devolver ya que no ha sido pagado."),
        OP_NOT_ALLOWED(4L, "El pago no se puede devolver ya que la entidad financiera no permite esta operaci\u00f3n."),
        PAYMENT_DATE_ERROR(5L, "El pago no se puede devolver ya que ha ocurrido un error al procesar la fecha de pago."),
        OUT_OF_DATE_FOR_REFUND(6L, "El pago no se puede devolver ya que ha expirado el plazo para la devoluci\u00f3n."),
        MAX_HOUR_LIMIT(7L, "El pago no se puede devolver ya que han pasado m\u00e1s de 24 horas."),
        INSUFFICIENT_DATA(8L, "El pago no se puede devolver ya que no hay informaci\u00f3n suficiente para devolver el pago."),
        UNKNOWN_PAYMENT_STATUS(9L, "El pago no se puede devolver ya que no se ha podido obtener el estado del pago."),
        NO_COMMUNICATION(10L, "El pago no se puede devolver ya que no ha habido comunicaci\u00f3n con la entidad."),
        GENERAL_ERROR(11L, "El pago no se puede devolver ya que ha ocurrido un error previo."),
        ORDER_ID_ERROR(12L, "El pago no se puede devolver ya que ha ocurrido un error al generar el pedido contra la EEFF.");

        private final long _exceptionErrorCode;
        private final String _exceptionMessage;

        public boolean isIn(String ... els) {
            return false;
        }

        @Override
        public boolean is(String el) {
            return false;
        }

        private REFUND_EXCEPTIONS(long exceptionErrorCode, String exceptionMessage) {
            this._exceptionErrorCode = exceptionErrorCode;
            this._exceptionMessage = exceptionMessage;
        }

        public long getExceptionErrorCode() {
            return this._exceptionErrorCode;
        }

        public String getExceptionMessage() {
            return this._exceptionMessage;
        }
    }
}

