/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.holdercert.utils;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bouncycastle.util.encoders.Hex;
import p12f.exe.pasarelapagos.exceptions.ConfigLoadException;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertConstants;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;
import p12f.exe.pasarelapagos.objects.config.FinantialOrgConfig;
import p12f.exe.pasarelapagos.security.crypto.TripleDESEBCDICCryptoHelper;
import p12f.exe.pasarelapagos.utils.CSBHelpper;

public class HolderCertUtil {
    public static String generateOID(String admin, String type, String reference) {
        SimpleDateFormat sd = new SimpleDateFormat("ddMMyy");
        String identificacion = sd.format(new Date(System.currentTimeMillis()));
        String referenceWith00 = reference + "00";
        String dc = CSBHelpper.getDigitoControlCSB507(admin, type, referenceWith00, identificacion, "0");
        String oid = admin + type + reference + dc + identificacion;
        String formattedString = StringUtils.lPadWithChar((String)oid, (char)'0', (int)19);
        return formattedString;
    }

    public static String getFinantialOrgCode(HolderCertData holderCertData) throws Exception {
        return HolderCertUtil.getFinantialOrgCode(holderCertData.itemToCertNumber, holderCertData.type, holderCertData.accountNumberFormat);
    }

    public static String getFinantialOrgCode(String itemToCert, String holderCertDataType, String holderCertDataFormat) throws Exception {
        if (holderCertDataType.equalsIgnoreCase("creditCardData")) {
            return null;
        }
        try {
            if (holderCertDataFormat.equalsIgnoreCase("cc")) {
                return itemToCert.substring(0, 4);
            }
            if (holderCertDataFormat.equalsIgnoreCase("iban")) {
                return itemToCert.substring(4, 8);
            }
        }
        catch (Exception ex) {
            throw new Exception("Error en el formato de cuenta :, pe. C\u00f3digo IBAN: ES7620770024003102575766 (formato electr\u00f3nico).\n \n  :" + ex.getLocalizedMessage() + "@ itemToCert=" + itemToCert);
        }
        return null;
    }

    public static boolean hasToSendEvent(HolderCertCertifiedDataList certifiedDataList) {
        for (HolderCertCertifiedData certifiedData : certifiedDataList.certCertifiedDataList) {
            if (!HolderCertConstants.resultsNoFinal.contains(new Integer(certifiedData.holderCertResponse.certCode))) continue;
            return false;
        }
        return true;
    }

    public static HolderCertData encrypt(HolderCertData holderCertData, String clave1, String clave2) throws Exception {
        HolderCertData encryptedHolderCertData = new HolderCertData();
        encryptedHolderCertData.accountNumberFormat = holderCertData.accountNumberFormat;
        encryptedHolderCertData.aditionalDataList = holderCertData.aditionalDataList;
        encryptedHolderCertData.citizenId = holderCertData.citizenId;
        encryptedHolderCertData.encType = holderCertData.encType;
        encryptedHolderCertData.type = holderCertData.type;
        encryptedHolderCertData.requestAdminID = holderCertData.requestAdminID;
        encryptedHolderCertData.requestID = holderCertData.requestID;
        try {
            if (clave1 == null || clave2 == null || "".equals(clave1) || "".equals(clave2)) {
                throw new Exception("Las claves suministradas no pueden ser nulas o vac\u00edas");
            }
            if (holderCertData.type.equalsIgnoreCase("accountNumber")) {
                encryptedHolderCertData.itemToCertNumber = HolderCertUtil._encryptAccountData(clave1, clave2, holderCertData);
            } else if (holderCertData.type.equalsIgnoreCase("creditCardData")) {
                encryptedHolderCertData.itemToCertNumber = HolderCertUtil._encryptCreditCardData(clave1, clave2, holderCertData);
            }
            return encryptedHolderCertData;
        }
        catch (XOMarshallerException e) {
            throw new Exception(e);
        }
        catch (ConfigLoadException e) {
            throw new Exception((Throwable)((Object)e));
        }
    }

    public static HolderCertData encrypt(HolderCertData holderCertData, FinantialOrgConfig entidad) throws Exception {
        String clave1 = entidad.claves.get("accountHolderKey1");
        String clave2 = entidad.claves.get("accountHolderKey2");
        if (clave1 == null || clave2 == null || "".equals(clave1) || "".equals(clave2)) {
            throw new Exception("No se han definido las claves accountHolderKey1 y  accountHolderKey2 para la Entidad Financiera: " + entidad.oid);
        }
        return HolderCertUtil.encrypt(holderCertData, clave1, clave2);
    }

    public static HolderCertDataList encrypt(HolderCertDataList holderCertDataList, String clave1, String clave2) throws Exception {
        HolderCertDataList encryptedHolderCertDataList = new HolderCertDataList();
        encryptedHolderCertDataList.packageID = holderCertDataList.packageID;
        for (HolderCertData holderCertData : holderCertDataList.dataList) {
            HolderCertData encryptedHolderCertData = HolderCertUtil.encrypt(holderCertData, clave1, clave2);
            encryptedHolderCertDataList.dataList.add(encryptedHolderCertData);
        }
        encryptedHolderCertDataList.itemCount = holderCertDataList.dataList.size();
        return encryptedHolderCertDataList;
    }

    public static HolderCertDataList encrypt(HolderCertDataList holderCertDataList, FinantialOrgConfig entidad) throws Exception {
        String clave1 = entidad.claves.get("accountHolderKey1");
        String clave2 = entidad.claves.get("accountHolderKey2");
        if (clave1 == null || clave2 == null || "".equals(clave1) || "".equals(clave2)) {
            throw new Exception("No se han definido las claves accountHolderKey1 y  accountHolderKey2 para la Entidad Financiera: " + entidad.oid);
        }
        return HolderCertUtil.encrypt(holderCertDataList, clave1, clave2);
    }

    public static String decrypt(String itemToCertNumber, String encType, FinantialOrgConfig entidad) throws Exception {
        String clave1 = entidad.claves.get("accountHolderKey1");
        String clave2 = entidad.claves.get("accountHolderKey2");
        if (clave1 == null || clave2 == null || "".equals(clave1) || "".equals(clave2)) {
            throw new Exception("No se han definido las claves accountHolderKey1 y  accountHolderKey2 para la Entidad Financiera: " + entidad.oid);
        }
        return HolderCertUtil._decryptData(clave1, clave2, itemToCertNumber, encType);
    }

    public static String decrypt(String itemToCertNumber, String encType, String clave1, String clave2) throws Exception {
        if (clave1 == null || clave2 == null || "".equals(clave1) || "".equals(clave2)) {
            throw new Exception("No se han definido las claves accountHolderKey1 y  accountHolderKey2 para la Entidad Financiera");
        }
        return HolderCertUtil._decryptData(clave1, clave2, itemToCertNumber, encType);
    }

    public static HolderCertData decrypt(HolderCertData holderCertData, String clave1, String clave2) throws Exception {
        HolderCertData decryptedHolderCertData = new HolderCertData();
        decryptedHolderCertData.accountNumberFormat = holderCertData.accountNumberFormat;
        decryptedHolderCertData.aditionalDataList = holderCertData.aditionalDataList;
        decryptedHolderCertData.citizenId = holderCertData.citizenId;
        decryptedHolderCertData.encType = holderCertData.encType;
        decryptedHolderCertData.type = holderCertData.type;
        decryptedHolderCertData.requestAdminID = holderCertData.requestAdminID;
        decryptedHolderCertData.requestID = holderCertData.requestID;
        try {
            if (clave1 == null || clave2 == null || "".equals(clave1) || "".equals(clave2)) {
                throw new Exception("Las claves suministradas no pueden ser nulas o vac\u00edas");
            }
            decryptedHolderCertData.itemToCertNumber = HolderCertUtil._decryptData(clave1, clave2, holderCertData).trim();
            return decryptedHolderCertData;
        }
        catch (XOMarshallerException e) {
            throw new Exception(e);
        }
        catch (ConfigLoadException e) {
            throw new Exception((Throwable)((Object)e));
        }
    }

    public static HolderCertData decrypt(HolderCertData holderCertData, FinantialOrgConfig entidad) throws Exception {
        String clave1 = entidad.claves.get("accountHolderKey1");
        String clave2 = entidad.claves.get("accountHolderKey2");
        if (clave1 == null || clave2 == null || "".equals(clave1) || "".equals(clave2)) {
            throw new Exception("No se han definido las claves accountHolderKey1 y  accountHolderKey2 para la Entidad Financiera: " + entidad.oid);
        }
        return HolderCertUtil.decrypt(holderCertData, clave1, clave2);
    }

    public static HolderCertDataList decrypt(HolderCertDataList holderCertDataList, String clave1, String clave2) throws Exception {
        HolderCertDataList decryptedHolderCertDataList = new HolderCertDataList();
        decryptedHolderCertDataList.packageID = holderCertDataList.packageID;
        for (HolderCertData holderCertData : holderCertDataList.dataList) {
            HolderCertData encryptedHolderCertData = HolderCertUtil.decrypt(holderCertData, clave1, clave2);
            decryptedHolderCertDataList.dataList.add(encryptedHolderCertData);
        }
        decryptedHolderCertDataList.itemCount = holderCertDataList.dataList.size();
        return decryptedHolderCertDataList;
    }

    public static HolderCertDataList decrypt(HolderCertDataList holderCertDataList, FinantialOrgConfig entidad) throws Exception {
        String clave1 = entidad.claves.get("accountHolderKey1");
        String clave2 = entidad.claves.get("accountHolderKey2");
        if (clave1 == null || clave2 == null || "".equals(clave1) || "".equals(clave2)) {
            throw new Exception("No se han definido las claves accountHolderKey1 y  accountHolderKey2 para la Entidad Financiera: " + entidad.oid);
        }
        return HolderCertUtil.decrypt(holderCertDataList, clave1, clave2);
    }

    public static HolderCertCertifiedDataList decrypt(HolderCertCertifiedDataList holderCertCertifiedDataList, String clave1, String clave2) throws Exception {
        HolderCertCertifiedDataList decryptedHolderCertDataList = new HolderCertCertifiedDataList();
        decryptedHolderCertDataList.packageID = holderCertCertifiedDataList.packageID;
        for (HolderCertCertifiedData holderCertCertifiedData : holderCertCertifiedDataList.certCertifiedDataList) {
            HolderCertCertifiedData encryptedHolderCertCertifiedData = new HolderCertCertifiedData();
            encryptedHolderCertCertifiedData.holderCertData = HolderCertUtil.decrypt(holderCertCertifiedData.holderCertData, clave1, clave2);
            encryptedHolderCertCertifiedData.holderCertResponse = holderCertCertifiedData.holderCertResponse;
            decryptedHolderCertDataList.certCertifiedDataList.add(encryptedHolderCertCertifiedData);
        }
        decryptedHolderCertDataList.itemCount = decryptedHolderCertDataList.certCertifiedDataList.size();
        return decryptedHolderCertDataList;
    }

    public static HolderCertCertifiedDataList decrypt(HolderCertCertifiedDataList holderCertCertifiedDataList, FinantialOrgConfig entidad) throws Exception {
        String clave1 = entidad.claves.get("accountHolderKey1");
        String clave2 = entidad.claves.get("accountHolderKey2");
        if (clave1 == null || clave2 == null || "".equals(clave1) || "".equals(clave2)) {
            throw new Exception("No se han definido las claves accountHolderKey1 y  accountHolderKey2 para la Entidad Financiera: " + entidad.oid);
        }
        return HolderCertUtil.decrypt(holderCertCertifiedDataList, clave1, clave2);
    }

    public static boolean validateHolderCertData(HolderCertData holderCertData) {
        if ("accountNumber".equals(holderCertData.type)) {
            if ("cc".equals(holderCertData.accountNumberFormat)) {
                return HolderCertUtil._validarCuentaCC(holderCertData.itemToCertNumber);
            }
            if ("iban".equals(holderCertData.accountNumberFormat)) {
                return HolderCertUtil._validarCuentaIBAN(holderCertData.itemToCertNumber);
            }
            return false;
        }
        return true;
    }

    private static String _encryptCreditCardData(String clave1, String clave2, HolderCertData holderCertData) throws Exception {
        String creditCardNumber = holderCertData.itemToCertNumber;
        String creditCardYear = holderCertData.aditionalDataList.get((Object)"creditCardYear").value;
        String creditCardMonth = holderCertData.aditionalDataList.get((Object)"creditCardMonth").value;
        creditCardNumber = StringUtils.rPadWithChar((String)creditCardNumber, (char)' ', (int)20);
        String data = creditCardNumber + "20" + creditCardYear + creditCardMonth;
        data = StringUtils.rPadWithChar((String)data, (char)' ', (int)32);
        String encType = holderCertData.encType;
        String claveFinal = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
        TripleDESEBCDICCryptoHelper encrypter = new TripleDESEBCDICCryptoHelper();
        if ("base64".equals(encType)) {
            return encrypter.encrypt(claveFinal, data);
        }
        return encrypter.encryptHEX(claveFinal, data);
    }

    private static String _encryptAccountData(String clave1, String clave2, HolderCertData holderCertData) throws Exception {
        String encType = holderCertData.encType;
        String data = holderCertData.itemToCertNumber;
        data = holderCertData.accountNumberFormat.equalsIgnoreCase("cc") ? StringUtils.rPadWithChar((String)data, (char)' ', (int)32) : StringUtils.rPadWithChar((String)data, (char)' ', (int)32);
        String claveFinal = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
        TripleDESEBCDICCryptoHelper encrypter = new TripleDESEBCDICCryptoHelper();
        if ("base64".equals(encType)) {
            return encrypter.encrypt(claveFinal, data);
        }
        return encrypter.encryptHEX(claveFinal, data);
    }

    private static String _decryptData(String clave1, String clave2, HolderCertData holderCertData) throws Exception {
        String encType = holderCertData.encType;
        String data = holderCertData.itemToCertNumber;
        return HolderCertUtil._decryptData(clave1, clave2, data, encType);
    }

    private static String _decryptData(String clave1, String clave2, String data, String encType) throws Exception {
        String claveFinal = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
        TripleDESEBCDICCryptoHelper encrypter = new TripleDESEBCDICCryptoHelper();
        if ("base64".equals(encType)) {
            return encrypter.decrypt(claveFinal, data).trim();
        }
        return encrypter.decryptHEX(claveFinal, data).trim();
    }

    private static boolean _validarCuentaCC(String numero) {
        long cuenta;
        int dcValidado;
        int entidad = new Integer(numero.substring(0, 4));
        int sucursal = new Integer(numero.substring(4, 8));
        int dc = new Integer(numero.substring(8, 10));
        return dc == (dcValidado = HolderCertUtil._digitosControlCcc(entidad, sucursal, cuenta = new Long(numero.substring(10)).longValue()));
    }

    private static int _dcCcc(long i) {
        int[] pesos = new int[]{6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        int contador = 0;
        long s = 0L;
        while (i != 0L) {
            long d = i % 10L;
            i /= 10L;
            s += d * (long)pesos[contador];
            ++contador;
        }
        int resultado = (int)(11L - s % 11L);
        if (resultado == 10) {
            resultado = 1;
        } else if (resultado == 11) {
            resultado = 0;
        }
        return resultado;
    }

    private static int _digitosControlCcc(int entidad, int sucursal, long cuenta) {
        long d = HolderCertUtil._dcCcc(entidad * 10000 + sucursal);
        d *= 10L;
        return (int)(d += (long)HolderCertUtil._dcCcc(cuenta));
    }

    private static boolean _validarCuentaIBAN(String value) {
        String iban = value.substring(4) + HolderCertUtil._convertLetterToNumberIBAN(value.charAt(0)) + HolderCertUtil._convertLetterToNumberIBAN(value.charAt(1)) + value.substring(2, 4);
        BigInteger resultado = new BigInteger(iban);
        if ((resultado = resultado.mod(new BigInteger("97"))).equals(new BigInteger("1"))) {
            return HolderCertUtil._validarCuentaCC(value.substring(4));
        }
        return false;
    }

    private static String _convertLetterToNumberIBAN(char letra) {
        switch (letra) {
            case 'A': {
                return "10";
            }
            case 'B': {
                return "11";
            }
            case 'C': {
                return "12";
            }
            case 'D': {
                return "13";
            }
            case 'E': {
                return "14";
            }
            case 'F': {
                return "15";
            }
            case 'G': {
                return "16";
            }
            case 'H': {
                return "17";
            }
            case 'I': {
                return "18";
            }
            case 'J': {
                return "19";
            }
            case 'K': {
                return "20";
            }
            case 'L': {
                return "21";
            }
            case 'M': {
                return "22";
            }
            case 'N': {
                return "23";
            }
            case 'O': {
                return "24";
            }
            case 'P': {
                return "25";
            }
            case 'Q': {
                return "26";
            }
            case 'R': {
                return "27";
            }
            case 'S': {
                return "28";
            }
            case 'T': {
                return "29";
            }
            case 'U': {
                return "30";
            }
            case 'V': {
                return "31";
            }
            case 'W': {
                return "32";
            }
            case 'X': {
                return "33";
            }
            case 'Y': {
                return "34";
            }
            case 'Z': {
                return "35";
            }
        }
        return "";
    }
}

