/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.holdercert.utils;

import com.ejie.r01f.servlet.upload.FilePart;
import com.ejie.r01f.servlet.upload.MultipartParser;
import com.ejie.r01f.servlet.upload.ParamPart;
import com.ejie.r01f.servlet.upload.Part;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.holdercert.utils.HolderCertDataListZipper;

public class HolderCertParamParser {
    private static final Logger log = LoggerFactory.getLogger(HolderCertParamParser.class);
    public static final String PROTOCOL_DATA = "protocolData";
    public static final String HOLDERCERT_DATA = "holderCertData";
    public static final String HOLDERCERT_CERTIFIED_DATA = "holderCertCertifiedData";
    public static final String HOLDERCERT_DATA_LIST = "holderCertDataList";
    public static final String HOLDERCERT_CERTIFIED_DATA_LIST = "holderCertCertifiedDataList";
    public static final String FINANTIALORGCODE = "finantialORGCode";
    public static final String FUNCTION = "function";
    public static final String MODULE = "module";
    public static final String HOLDERCERT_FUNCTION = "holderCertified";
    public static final String HOLDERCERT_MULTIPLE_FUNCTION = "multipleHolderCertified";
    public static final String HOLDERCERT_MULTIPLE_BATCH_FUNCTION = "batchMultipleHolderCertified";
    public static final String HOLDER_CERT_INTERNAL_ERROR = "holderCertInternalError";
    public static final String HOLDERCERT_FUNCTION_RECEIVE = "holderCert";
    public static final String HOLDERCERT_MULTIPLE_FUNCTION_RECEIVE = "multipleHolderCert";
    public static final String HOLDERCERT_MULTIPLE_BATCH_FUNCTION_RECEIVE = "multipleHolderCertBatch";
    public Map parameters = new HashMap();

    public void parse(HttpServletRequest request, HttpServletResponse response) {
        this.parse(request, response, true);
    }

    public void parse(HttpServletRequest request, HttpServletResponse response, boolean unzip) {
        if (HolderCertParamParser._isMultipartContent(request)) {
            this._parseMultiPartRequest(request, response, unzip);
        } else {
            this._parseSimpleRequest(request, response);
        }
    }

    public Object getParam(String key) {
        return this.parameters.get(key);
    }

    private void _parseSimpleRequest(HttpServletRequest request, HttpServletResponse response) {
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paramName = (String)enu.nextElement();
            String paramValue = request.getParameter(paramName);
            this.parameters.put(paramName, paramValue);
        }
    }

    private void _parseMultiPartRequest(HttpServletRequest request, HttpServletResponse response, boolean unzip) {
        try {
            log.debug("==============================================================");
            log.debug("Multipart.Parser");
            log.debug("==============================================================");
            int maxFileSize = 0xA00000;
            Part parte = null;
            MultipartParser parser = new MultipartParser(request, maxFileSize);
            parser.setEncoding("ISO-8859-1");
            log.debug("MultiParser Creado");
            while ((parte = parser.readNextPart()) != null) {
                log.debug(".PARTE:" + parte.getName());
                log.debug(".parte.isParam()-->" + parte.isParam());
                if (parte.isParam()) {
                    log.debug(".Tratamiento de par\u00e1metro tipo standard : [ " + parte.getName() + "]");
                    ParamPart paramPart = (ParamPart)parte;
                    this.parameters.put(parte.getName(), paramPart.getStringValue());
                    continue;
                }
                log.debug(".Tratamiento de par\u00e1metro tipo multipart : [ " + parte.getName() + "]");
                if (!parte.isFile() && !parte.getName().equalsIgnoreCase("file")) continue;
                FilePart fp = (FilePart)parte;
                InputStream is = fp.getInputStream();
                try {
                    if (unzip) {
                        byte[] unzippedBytes = HolderCertDataListZipper.unzip(is);
                        log.debug(" Descomprimir : " + parte.getName());
                        this.parameters.put(parte.getName(), new ByteArrayInputStream(unzippedBytes));
                    } else {
                        this.parameters.put(parte.getName(), IOUtils.toByteArray((InputStream)is));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                is.close();
                log.debug(" Tratamiento multipart realizado ");
            }
            log.debug("Tratamiento Parametros POST Finalizado");
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = request.getParameter(key);
                this.parameters.put(key, value);
            }
            log.debug("Tratamiento Parametros GET Finalizado");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static final boolean _isMultipartContent(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }
}

