/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.holdercert.utils;

import java.util.HashMap;
import java.util.Map;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;

public class HolderCertDataListAgrupator {
    public static Map<String, HolderCertDataList> groupByFinantialOrg(HolderCertDataList list) throws Exception {
        HashMap<String, HolderCertDataList> mapFinantialOrgs = new HashMap<String, HolderCertDataList>();
        for (HolderCertData certData : list.dataList) {
            String finantialOrgData = HolderCertDataListAgrupator.getFinantialOrgCode(certData);
            if (!mapFinantialOrgs.containsKey(finantialOrgData)) {
                HolderCertDataList newHolderCertDataList = new HolderCertDataList();
                newHolderCertDataList.packageID = list.packageID;
                newHolderCertDataList.dataList.add(certData);
                mapFinantialOrgs.put(finantialOrgData, newHolderCertDataList);
                continue;
            }
            HolderCertDataList holderCertDataListToUpdate = (HolderCertDataList)mapFinantialOrgs.get(finantialOrgData);
            holderCertDataListToUpdate.dataList.add(certData);
            mapFinantialOrgs.put(finantialOrgData, holderCertDataListToUpdate);
        }
        return mapFinantialOrgs;
    }

    public static String getFinantialOrgCode(HolderCertData holderCertData) throws Exception {
        String itemToCert = holderCertData.itemToCertNumber;
        if (holderCertData.type.equalsIgnoreCase("creditCardData")) {
            return null;
        }
        try {
            if (holderCertData.accountNumberFormat.equalsIgnoreCase("cc")) {
                return itemToCert.substring(0, 4);
            }
            if (holderCertData.accountNumberFormat.equalsIgnoreCase("iban")) {
                return itemToCert.substring(4, 8);
            }
        }
        catch (Exception ex) {
            throw new Exception("Error en el formato de cuenta :, pe. C\u00f3digo IBAN: ES7620770024003102575766 (formato electr\u00f3nico).\n \n  :" + ex.getLocalizedMessage() + "@ itemToCert=" + itemToCert);
        }
        return null;
    }
}

