/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.file.utils.filters;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileFilterEarlyDateWithoutExtensionUtils
implements FilenameFilter {
    String filterDate;
    SimpleDateFormat sdf;
    String extension;

    public FileFilterEarlyDateWithoutExtensionUtils(String filterDate, String extension) {
        this.filterDate = filterDate;
        this.extension = extension;
        this.sdf = new SimpleDateFormat("yyyy-MM-dd");
    }

    @Override
    public boolean accept(File dir, String name) {
        File aux = new File(dir, name);
        Date d = new Date(aux.lastModified());
        String current = this.sdf.format(d);
        String ext = "";
        if (aux.isFile() && aux.getName().lastIndexOf(".") >= 0) {
            ext = aux.getName().substring(aux.getName().lastIndexOf(".") + 1);
            ext = ext.toLowerCase();
        }
        return this.filterDate.compareTo(current) >= 0 && !this.extension.equals(ext);
    }
}

