package p12e.exe.pasarelapagos.test.utils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;

/*
 * Created on 03-mar-2006
 * @author co01347e
 */

/**
 * Clase que contiene mtodos de ayuda para el clculo del NRC. 
 */
public class NRCHelper {
	
	/**
	 * Constantes con los valores hexadecimales de los caracteres ASCII.
	 */
	static final byte ASCII_a = 0x61; 
	static final byte ASCII_b = 0x62; 
	static final byte ASCII_c = 0x63; 
	static final byte ASCII_d = 0x64; 
	static final byte ASCII_e = 0x65; 
	static final byte ASCII_f = 0x66; 
	static final byte ASCII_g = 0x67; 
	static final byte ASCII_h = 0x68; 
	static final byte ASCII_i = 0x69; 
	static final byte ASCII_j = 0x6A; 
	static final byte ASCII_k = 0x6B; 
	static final byte ASCII_l = 0x6C;
	static final byte ASCII_m = 0x6D; 
	static final byte ASCII_n = 0x6E; 
	static final byte ASCII_o = 0x6F; 
	static final byte ASCII_p = 0x70; 
	static final byte ASCII_q = 0x71; 
	static final byte ASCII_r = 0x72; 
	static final byte ASCII_s = 0x73; 
	static final byte ASCII_t = 0x74;
	static final byte ASCII_u = 0x75; 
	static final byte ASCII_v = 0x76; 
	static final byte ASCII_w = 0x77; 
	static final byte ASCII_x = 0x78;
	static final byte ASCII_y = 0x79;
	static final byte ASCII_z = 0x7A;
	static final byte ASCII_A = 0x41; 
	static final byte ASCII_B = 0x42; 
	static final byte ASCII_C = 0x43; 
	static final byte ASCII_D = 0x44; 
	static final byte ASCII_E = 0x45; 
	static final byte ASCII_F = 0x46; 
	static final byte ASCII_G = 0x47; 
	static final byte ASCII_H = 0x48; 
	static final byte ASCII_I = 0x49; 
	static final byte ASCII_J = 0x4A; 
	static final byte ASCII_K = 0x4B; 
	static final byte ASCII_L = 0x4C;
	static final byte ASCII_M = 0x4D; 
	static final byte ASCII_N = 0x4E; 
	static final byte ASCII_O = 0x4F; 
	static final byte ASCII_P = 0x50; 
	static final byte ASCII_Q = 0x51; 
	static final byte ASCII_R = 0x52; 
	static final byte ASCII_S = 0x53; 
	static final byte ASCII_T = 0x54;
	static final byte ASCII_U = 0x55; 
	static final byte ASCII_V = 0x56; 
	static final byte ASCII_W = 0x57; 
	static final byte ASCII_X = 0x58; 
	static final byte ASCII_Y = 0x59; 
	static final byte ASCII_Z = 0x5A; 
	static final byte ASCII_0 = 0x30; 
	static final byte ASCII_1 = 0x31; 
	static final byte ASCII_2 = 0x32; 
	static final byte ASCII_3 = 0x33; 
	static final byte ASCII_4 = 0x34; 
	static final byte ASCII_5 = 0x35; 
	static final byte ASCII_6 = 0x36; 
	static final byte ASCII_7 = 0x37; 
	static final byte ASCII_8 = 0x38; 
	static final byte ASCII_9 = 0x39; 
	
	/**
	 * Constantes con los valores hexadecimales de los caracteres EBCDIC.
	 */
	static final byte EBCDIC_a = -127; 
	static final byte EBCDIC_b = -126; 
	static final byte EBCDIC_c = -125; 
	static final byte EBCDIC_d = -124; 
	static final byte EBCDIC_e = -123; 
	static final byte EBCDIC_f = -122; 
	static final byte EBCDIC_g = -121; 
	static final byte EBCDIC_h = -120; 
	static final byte EBCDIC_i = -119;
	static final byte EBCDIC_j = -111;
	static final byte EBCDIC_k = -110; 
	static final byte EBCDIC_l = -109; 
	static final byte EBCDIC_m = -108; 
	static final byte EBCDIC_n = -107; 
	static final byte EBCDIC_o = -106; 
	static final byte EBCDIC_p = -105; 
	static final byte EBCDIC_q = -104; 
	static final byte EBCDIC_r = -103; 
	static final byte EBCDIC_s = -94; 
	static final byte EBCDIC_t = -93;
	static final byte EBCDIC_u = -92; 
	static final byte EBCDIC_v = -91; 
	static final byte EBCDIC_w = -90; 
	static final byte EBCDIC_x = -89; 
	static final byte EBCDIC_y = -88; 
	static final byte EBCDIC_z = -87;
	static final byte EBCDIC_A = -63; 
	static final byte EBCDIC_B = -62; 
	static final byte EBCDIC_C = -61; 
	static final byte EBCDIC_D = -60; 
	static final byte EBCDIC_E = -59; 
	static final byte EBCDIC_F = -58; 
	static final byte EBCDIC_G = -57; 
	static final byte EBCDIC_H = -56; 
	static final byte EBCDIC_I = -55; 
	static final byte EBCDIC_J = -47;
	static final byte EBCDIC_K = -46; 
	static final byte EBCDIC_L = -45; 
	static final byte EBCDIC_M = -44; 
	static final byte EBCDIC_N = -43; 
	static final byte EBCDIC_O = -42; 
	static final byte EBCDIC_P = -41; 
	static final byte EBCDIC_Q = -40; 
	static final byte EBCDIC_R = -39; 
	static final byte EBCDIC_S = -30; 
	static final byte EBCDIC_T = -29;
	static final byte EBCDIC_U = -28; 
	static final byte EBCDIC_V = -27; 
	static final byte EBCDIC_W = -26; 
	static final byte EBCDIC_X = -25; 
	static final byte EBCDIC_Y = -24; 
	static final byte EBCDIC_Z = -23;  
	static final byte EBCDIC_0 = -16; 
	static final byte EBCDIC_1 = -15; 
	static final byte EBCDIC_2 = -14; 
	static final byte EBCDIC_3 = -13; 
	static final byte EBCDIC_4 = -12; 
	static final byte EBCDIC_5 = -11; 
	static final byte EBCDIC_6 = -10; 
	static final byte EBCDIC_7 = -9; 
	static final byte EBCDIC_8 = -8;
	static final byte EBCDIC_9 = -7; 
	
	/**
	 * Mtodo que calcula el MAC.
	 * @param dataBytes Array de bytes de los datos.
	 * @param keyBytes Array de bytes de la clave.
	 * @return Clave de contraste formada por 8 caracteres hexadecimales.
	 * @throws Exception
	 */
	public static String calcularMAC(byte[] dataBytes, byte[] keyBytes) throws Exception 
	{ 			
		KeyParameter key = new KeyParameter(keyBytes); 
		BlockCipher cipher = new DESEngine(); 
		Mac mac = new CBCBlockCipherMac(cipher); 
		mac.init(key); 
		mac.update(dataBytes, 0, dataBytes.length); 
		byte[] out = new byte[4]; 
		mac.doFinal(out, 0);       
		return (new String(Hex.encode(out))).toUpperCase(); 
	} 
	
	/**
	 * Metodo que realiza el XOR de dos arrays de bytes.
	 * @param clave1
	 * @param clave2
	 * @return Array de bytes con el resultado de la operacin.
	 */
	public static byte[] doXOR(String clave1, String clave2) throws Exception{
		
		if(clave1.length()!=clave2.length()){
			throw new Exception("Las dos cadenas deben tener la misma longitud.");
		}
		
		byte[] keyBytes1 = Hex.decode(clave1);
		byte[] keyBytes2 = Hex.decode(clave2);		
 
		byte[] keyBytesXOR = new byte[keyBytes1.length];
		
		for(int i=0;i<keyBytesXOR.length;i++){
			int intValue = new Byte(keyBytes1[i]).intValue()^new Byte(keyBytes2[i]).intValue();
			keyBytesXOR[i]=new Integer(intValue).byteValue();
		}
		
		return keyBytesXOR;
	}
	
	/**
	 * Mtodo que convuierte una cadena de bytes ASCII a EBCDIC
	 * @param dataBytes
	 * @return
	 */
	public static byte[] fromASCII_to_EBCDIC(byte[] dataBytes) throws Exception{
		byte[] dataBytes_EBCDIC = new byte[dataBytes.length];
		
		for(int i=0;i<dataBytes.length;i++){
			switch(dataBytes[i]){
			case ASCII_a:
				dataBytes_EBCDIC[i] = EBCDIC_a;
				break;
			case ASCII_b:
				dataBytes_EBCDIC[i] = EBCDIC_b;
				break;
			case ASCII_c:
				dataBytes_EBCDIC[i] = EBCDIC_c;
				break;
			case ASCII_d:
				dataBytes_EBCDIC[i] = EBCDIC_d;
				break;
			case ASCII_e:
				dataBytes_EBCDIC[i] = EBCDIC_e;
				break;
			case ASCII_f:
				dataBytes_EBCDIC[i] = EBCDIC_f;
				break;
			case ASCII_g:
				dataBytes_EBCDIC[i] = EBCDIC_g;
				break;
			case ASCII_h:
				dataBytes_EBCDIC[i] = EBCDIC_h;
				break;
			case ASCII_i:
				dataBytes_EBCDIC[i] = EBCDIC_i;
				break;
			case ASCII_j:
				dataBytes_EBCDIC[i] = EBCDIC_j;
				break;
			case ASCII_k:
				dataBytes_EBCDIC[i] = EBCDIC_k;
				break;
			case ASCII_l:
				dataBytes_EBCDIC[i] = EBCDIC_l;
				break;
			case ASCII_m:
				dataBytes_EBCDIC[i] = EBCDIC_m;
				break;
			case ASCII_n:
				dataBytes_EBCDIC[i] = EBCDIC_n;
				break;
			case ASCII_o:
				dataBytes_EBCDIC[i] = EBCDIC_o;
				break;
			case ASCII_p:
				dataBytes_EBCDIC[i] = EBCDIC_p;
				break;
			case ASCII_q:
				dataBytes_EBCDIC[i] = EBCDIC_q;
				break;
			case ASCII_r:
				dataBytes_EBCDIC[i] = EBCDIC_r;
				break;
			case ASCII_s:
				dataBytes_EBCDIC[i] = EBCDIC_s;
				break;
			case ASCII_t:
				dataBytes_EBCDIC[i] = EBCDIC_t;
				break;
			case ASCII_u:
				dataBytes_EBCDIC[i] = EBCDIC_u;
				break;
			case ASCII_v:
				dataBytes_EBCDIC[i] = EBCDIC_v;
				break;
			case ASCII_w:
				dataBytes_EBCDIC[i] = EBCDIC_w;
				break;
			case ASCII_x:
				dataBytes_EBCDIC[i] = EBCDIC_x;
				break;
			case ASCII_y:
				dataBytes_EBCDIC[i] = EBCDIC_y;
				break;
			case ASCII_z:
				dataBytes_EBCDIC[i] = EBCDIC_z;
				break;
			case ASCII_A:
				dataBytes_EBCDIC[i] = EBCDIC_A;
				break;
			case ASCII_B:
				dataBytes_EBCDIC[i] = EBCDIC_B;
				break;
			case ASCII_C:
				dataBytes_EBCDIC[i] = EBCDIC_C;
				break;
			case ASCII_D:
				dataBytes_EBCDIC[i] = EBCDIC_D;
				break;
			case ASCII_E:
				dataBytes_EBCDIC[i] = EBCDIC_E;
				break;
			case ASCII_F:
				dataBytes_EBCDIC[i] = EBCDIC_F;
				break;
			case ASCII_G:
				dataBytes_EBCDIC[i] = EBCDIC_G;
				break;
			case ASCII_H:
				dataBytes_EBCDIC[i] = EBCDIC_H;
				break;
			case ASCII_I:
				dataBytes_EBCDIC[i] = EBCDIC_I;
				break;
			case ASCII_J:
				dataBytes_EBCDIC[i] = EBCDIC_J;
				break;
			case ASCII_K:
				dataBytes_EBCDIC[i] = EBCDIC_K;
				break;
			case ASCII_L:
				dataBytes_EBCDIC[i] = EBCDIC_L;
				break;
			case ASCII_M:
				dataBytes_EBCDIC[i] = EBCDIC_M;
				break;
			case ASCII_N:
				dataBytes_EBCDIC[i] = EBCDIC_N;
				break;
			case ASCII_O:
				dataBytes_EBCDIC[i] = EBCDIC_O;
				break;
			case ASCII_P:
				dataBytes_EBCDIC[i] = EBCDIC_P;
				break;
			case ASCII_Q:
				dataBytes_EBCDIC[i] = EBCDIC_Q;
				break;
			case ASCII_R:
				dataBytes_EBCDIC[i] = EBCDIC_R;
				break;
			case ASCII_S:
				dataBytes_EBCDIC[i] = EBCDIC_S;
				break;
			case ASCII_T:
				dataBytes_EBCDIC[i] = EBCDIC_T;
				break;
			case ASCII_U:
				dataBytes_EBCDIC[i] = EBCDIC_U;
				break;
			case ASCII_V:
				dataBytes_EBCDIC[i] = EBCDIC_V;
				break;
			case ASCII_W:
				dataBytes_EBCDIC[i] = EBCDIC_W;
				break;
			case ASCII_X:
				dataBytes_EBCDIC[i] = EBCDIC_X;
				break;
			case ASCII_Y:
				dataBytes_EBCDIC[i] = EBCDIC_Y;
				break;
			case ASCII_Z:
				dataBytes_EBCDIC[i] = EBCDIC_Z;
				break;
			case ASCII_0:
				dataBytes_EBCDIC[i] = EBCDIC_0;
				break;
			case ASCII_1:
				dataBytes_EBCDIC[i] = EBCDIC_1;
				break;
			case ASCII_2:
				dataBytes_EBCDIC[i] = EBCDIC_2;
				break;
			case ASCII_3:
				dataBytes_EBCDIC[i] = EBCDIC_3;
				break;
			case ASCII_4:
				dataBytes_EBCDIC[i] = EBCDIC_4;
				break;
			case ASCII_5:
				dataBytes_EBCDIC[i] = EBCDIC_5;
				break;
			case ASCII_6:
				dataBytes_EBCDIC[i] = EBCDIC_6;
				break;
			case ASCII_7:
				dataBytes_EBCDIC[i] = EBCDIC_7;
				break;
			case ASCII_8:
				dataBytes_EBCDIC[i] = EBCDIC_8;
				break;
			case ASCII_9:
				dataBytes_EBCDIC[i] = EBCDIC_9;
				break;
			default:
				throw new Exception("Caracter no vlido");
			}
		}
		
		return dataBytes_EBCDIC;
	}
	
	public static void main(String[] args) {
		
		System.out.println("----------> PRUEBA LA CAIXA");
		String datos = "00000000";
		String clave1 ="C3C3C3C3F1D7E5F5";
		String clave2 ="C2C2C2C2E6C1C5F2";
		String clave;
		
		try {
			clave = new String(Hex.encode(doXOR(clave1, clave2))).toUpperCase();
			
			System.out.println("Clave1 (Hex): " + clave1);
			System.out.println("Clave2 (Hex): " + clave2);
			System.out.println("Clave  (Hex): " + clave);
			System.out.println("Datos  	    : \"" + datos + "\"");
			byte[] dataBytes = datos.getBytes();
			byte[] dataBytes_EBCDIC = fromASCII_to_EBCDIC(dataBytes);
			byte[] keyBytes = Hex.decode(clave);
			System.out.println("Datos  (Hex): " + (new String(Hex.encode(dataBytes_EBCDIC))).toUpperCase());
			System.out.println("MAC: " + calcularMAC(dataBytes_EBCDIC, keyBytes));
		} catch (Exception e) {
			System.out.println("Se ha producido una excepcion el el cifrado...");
			e.printStackTrace();
		}
		
		System.out.println("\n----------> PRUEBA FIPS PUB 113");
		datos = "7654321 Now is the time for ";
		clave ="0123456789ABCDEF";
		
		try {			
			System.out.println("Clave  (Hex): " + clave);
			System.out.println("Datos  	    : \"" + datos + "\"");
			byte[] dataBytes = datos.getBytes();
			byte[] keyBytes = Hex.decode(clave);
			System.out.println("Datos  (Hex): " + (new String(Hex.encode(dataBytes))).toUpperCase());
			System.out.println("MAC: " + calcularMAC(dataBytes, keyBytes));
		} catch (Exception e) {
			System.out.println("Se ha producido una excepcion el el cifrado...");
			e.printStackTrace();
		}
	}
}
