/*
 * Created on 23-jun-2005
 * @author co01347e
 */
package p12e.exe.pasarelapagos.test;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.bouncycastle.util.encoders.Hex;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.test.utils.NRCHelper;
import p12f.exe.pasarelapagos.objects.Estado;
import p12f.exe.pasarelapagos.objects.Mensaje;
import p12f.exe.pasarelapagos.objects.Pago;
import p12f.exe.pasarelapagos.objects.PaymentData;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.redirection.SessionAttrs;
import p12f.exe.pasarelapagos.utils.LimitDateHelper;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;

/**
 * Servlet encargado de la realizacin de un pago en la Entidad Financiera.
 */
public class RealizarPagoServlet extends HttpServlet {

    /**
     * Constructor of the object.
     */
    public RealizarPagoServlet() {
        super();
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        doExec(request, response);
    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to post.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        doExec(request, response);
    }
    
    /**
     * The doExec method of the servlet. <br>
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doExec(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
    	
        boolean pagoError = (new Boolean (request.getParameter("pagoError"))).booleanValue();
        
        /*
         * Recogemos los datos del pago en funcion del modo en que hayamos redirigido al
         * cliente a la aplicacin de banca electrnica.
         */		
		
		/*	Mtodo 1: Redireccin de servidor utilizando session.
		 *	  	En la llamada a setPaymentData se puso en session el objeto EFClass
		 */
        HttpSession session = request.getSession();
		EFClass ef = (EFClass)session.getAttribute(SessionAttrs.EFCLASS);
		
		/*	Mtodo 2: Redireccin de servidor sin utilizar session.
		 *		En la llamada a setPaymentData se puso en la request el objeto EFClass 
		 */ 
		//EFClass ef = (EFClass)request.getAttribute(RequestAttrs.EFCLASS);
		
		/* 	Mtodo 3: Redireccin de servidor a travs del cliente.
		 *	  	Se utiliz una redireccin de cliente para llegar a esta pgina.
		 *  	En la redireccin se pasaron como parmetro los XML y ahora hay
		 *  	que obtener de nuevo los objetos.
		 */
		//String paymentDataXML = request.getParameter(RequestParams.PAYMENT_DATA);
		//String presentationDataXML = request.getParameter(RequestParams.PRESENTATION_DATA);
		//String protocolDataXML = request.getParameter(RequestParams.PROTOCOL_DATA);
		//EFClass ef = new EFClass(paymentDataXML, presentationDataXML, protocolDataXML);
        
        // Realizar los pagos
        try{
            PaymentData paymentData = ef.getPaymentData();
            /*
             * Realizar cada uno de los pagos en una transaccin INDEPENDIENTE contra el HOST.
             * En la peticin puede llegar un slo pago o un pago mltiple, hay que realizar 
             * una transaccin de pago para cada uno de los pagos del lote.
             * El objeto PaymentData tiene un mapa con todos los pagos del lote. 
             * Si se trata de un pago sencillo unicamente hay un elemento.
             * Basta con recorrer el objeto y realizar una transaccin para cada uno.
             */
            Pago currPago = null;
            int hostResponse = -1;
            /*
             * Transaccin por cada pago del lote.
             */
            for(Iterator it = paymentData.pagos.keySet().iterator(); it.hasNext();){
                currPago = (Pago)paymentData.pagos.get(it.next());
                
                // Activamos el periodo de pago adecuado
                Map periodosPago = currPago.datosPago.periodosPago;

                PeriodoPago periodoNormal = (PeriodoPago)periodosPago.get(PeriodoPago.PERIODO_NORMAL);
                PeriodoPago periodoVoluntario = (PeriodoPago)periodosPago.get(PeriodoPago.PERIODO_VOLUNTARIO);
                PeriodoPago periodoConRecargo = (PeriodoPago)periodosPago.get(PeriodoPago.PERIODO_CON_RECARGO);
                
                // Si se ha superado la fecha limite del pago se produce un error
                boolean error = true;
                // Si hay periodo normal y esta dentro de el
                if(periodosPago.get(PeriodoPago.PERIODO_NORMAL)!=null) {           
                    if(LimitDateHelper.comprobarFecha(periodoNormal.fechaFin)) {
                        //periodoNormal.activo = true;
                        currPago.activarPeriodoPago(PeriodoPago.PERIODO_NORMAL);
                        error = false;
                    }
                } 
                // Si hay periodo voluntario y esta dentro de el
                if(periodosPago.get(PeriodoPago.PERIODO_VOLUNTARIO)!=null) {
                    if(LimitDateHelper.comprobarFecha(periodoVoluntario.fechaFin)) {
                        //periodoVoluntario.activo = true;
                        currPago.activarPeriodoPago(PeriodoPago.PERIODO_VOLUNTARIO);
                        error = false;
                    }
                }
                // Si hay periodo con recargo
                if(periodosPago.get(PeriodoPago.PERIODO_CON_RECARGO)!=null) {
                    if(LimitDateHelper.comprobarFecha(periodoConRecargo.fechaFin) && !LimitDateHelper.comprobarFecha(periodoVoluntario.fechaFin)) {
                        //periodoConRecargo.activo = true;
                        currPago.activarPeriodoPago(PeriodoPago.PERIODO_CON_RECARGO);
                        error = false;
                    }
                }
                
                /*
                 * Aqu se tienen todos los datos del pago que son accesibles
                 * como un objeto Java normal, se puede acceder a los datos de
                 * cualquier miembro de los sealados en la documentacin.
                 */
                String cpr = currPago.datosPago.cpr; // CPR: Cdigo de Procedimiento Recaudatorio
                String rafaga = currPago.datosPago.codigo; // Cdigo de barras
                // ... acceder a cualquier dato del pago .. //
                try{
                    /*
                     * Aqu la entidad financiera realizaria una transaccin contra su host
                     * con los datos que considere necesarios de los que estn disponibles
                     * en el objeto de pago.
                     * Haciendo una suposicin de la llamada, suponiendo que el host devuelve
                     * nicamente un nmero indicativo del resultado (seguramente no sea
                     * un caso real... es un ejemplo)
                     */
                    hostResponse = HostEntidadFinanciera.transaccionPago(cpr, rafaga);
                    if(error){
                    	hostResponse = -30;
                    }
                }catch(Exception ex){
                    hostResponse = -30;	// Para poder marcar el error en el justificante
                    ex.printStackTrace();
                    //System.out.println(">>>Error transaccion HOST " + ex.toString());
                    throw new Exception();
                }
                // Componer un objeto PaymentStateData con el resultado del pago actual.
                Estado estado = new Estado();
                if(hostResponse==0){
                    estado.paymentID = currPago.id;
                    if(currPago.id==null){
                    	estado.paymentID = "9050704833001111111111111111111100000001000";
                    }
                    // Devolvemos el estado de forma aleatoria: 80% pagado, 20% sin datos
                    /*int aleat = (int) Math.round(Math.random()*100);
                    if (aleat<=80) {
                    	estado.codigo = Estado.PAGADO;
                    } else{
                    	estado.codigo = Estado.NO_DATA;
                    }*/
                    // Develvemos pagado o no segn lo seleccionado el paso anterior

                    if (pagoError){
                    	estado.codigo = Estado.NO_DATA;   
                    }else{
                    	estado.codigo = Estado.PAGADO;              
                    }
                    	                   	
                    estado.numeroOperacion = "12345678901234";   
                    Date fecha = new Date();
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("ddMMyy");
                    SimpleDateFormat hourFormatter = new SimpleDateFormat("hhmmss");
                    estado.fechaPago = dateFormatter.format(fecha);
                    estado.horaPago = hourFormatter.format(fecha);
                    estado.importe = new Long(currPago.getImporte()).toString();
                    estado.entidad = "9999";
                    estado.oficina = "0001";
                    
                    String emisor = currPago.datosPago.emisor;
                    String referencia = currPago.datosPago.referencia;
                    String importe = estado.importe;
                    String justificante = estado.numeroOperacion;
                    
                    String clave1 = "1111111111111111";
                    String clave2 = "AAAAAAAAAAAAAAAA";
                    String clave = new String(Hex.encode(NRCHelper.doXOR(clave1, clave2))).toUpperCase();                    
                    
                    if(currPago.datosPago.formato.equals("507")){
                    	emisor = emisor.substring(0,8) + emisor.substring(9,12);
                    } else if (currPago.datosPago.formato.equals("502") || currPago.datosPago.formato.equals("521")){
                    	emisor = emisor + currPago.datosPago.tipo;
                    } else if (currPago.datosPago.formato.equals("522")){
                    	emisor = emisor + currPago.datosPago.tipo;
                    	String referenciaBase = referencia.substring(0,10);
                    	String codigoControlVoluntario = referencia.substring(10,12);
                    	String codigoControlRecargo = referencia.substring(12,14);
                    	
                    	if (importe.equals(periodoVoluntario)) {
                    		// Se ha pagado el importe voluntario
                    		referencia = referenciaBase + codigoControlVoluntario;
                    	} else if (importe.equals(periodoConRecargo)) {
                    		// Se ha pagado el importe con recargo
                    		referencia = referenciaBase + codigoControlRecargo;
                    	}
                    }        
                    
                    emisor = StringUtils.lPadWithChar(emisor, '0', 11);
                    referencia = StringUtils.lPadWithChar(referencia, '0', 14);
                    importe = StringUtils.lPadWithChar(importe, '0', 11);       
                    
                    String datos = emisor + referencia + importe + justificante;
                    
            		byte[] dataBytes = datos.getBytes();
            		byte[] dataBytes_EBCDIC = NRCHelper.fromASCII_to_EBCDIC(dataBytes);
            		byte[] keyBytes = Hex.decode(clave);
        			
        			String mac = NRCHelper.calcularMAC(dataBytes_EBCDIC, keyBytes);
                    
        			estado.nrc = justificante + mac;
                    
                }else{
                    estado.codigo = Estado.ERROR_PAGO;
                    estado.entidad = "2095";
                    Mensaje mensaje1 = new Mensaje();
                 
                    mensaje1.texto.put("es", "Error en la realizacion del pago");
                    mensaje1.texto.put("eu", "Error en la realizacion del pago_eu");
                    estado.mensajes.put(mensaje1.id, mensaje1);
                    
                    Mensaje mensaje2 = new Mensaje();
                    mensaje2.id = "error2";
                    mensaje2.texto.put("es", "El error se debe a que se ha superado la fecha limite del pago");
                    mensaje2.texto.put("eu", "El error se debe a que se ha superado la fecha limite del pago_eu");
                    estado.mensajes.put(mensaje2.id, mensaje2);
                    
        			
    	
                    
                    /*
                     *	Indicar la razn del error en el pago, ya que este dato se
                     *	utiliza para componer el justificante de pago e indicar que
                     *	pagos han fallado y por qu motivo. 
                     */ 
                    if(hostResponse == -20){
                        // El emisor/sufijo no esta dado de alta en el HOST...
                        estado.razonError = "No existe el sufijo";
                    }else if(hostResponse == -30){
                        // Error tcnico general...
                        estado.razonError = "Error general";
                    }
                }
                /*
                 * El resultado de cada pago individual se va almacenando en un objeto que "acumula"
                 * los resultados de cada transaccin para devolver el resultado a la Pasarela de
                 * la Administracin.
                 */
                
                
                ef.returnSinglePaymentResult(currPago.id, currPago.datosPago ,estado);
            } // Cada uno de los pagos
            /*
             * Una vez realizadas las transacciones individuales de pago, devolver el resultado
             * de pago a la pasarela de la Administracin.
             */            
            //PaymentResult paymentResult = ef.returnPaymentResult();
            // Si no hay error, redirigimos al cliente a la pgina de emisin del justificante. 
            RequestDispatcher rd = request.getRequestDispatcher("/confirmacion.jsp");                   
            rd.forward(request, response);
        }catch(Exception ex){
            ex.printStackTrace();
            System.out.println(">>> Ha ocurrido un error en la tramitacin contra el HOST " + ex.toString());
            // Si hay error, redirigimos al cliente a la pgina de error.
            RequestDispatcher rd = request.getRequestDispatcher("/error.jsp");       
            rd.forward(request, response);
        }
    }
    
    
    public static void main(String[] argv) throws XOMarshallerException {
        
     
        
    }
    
    
    
    
    
    
    
    
    
}
