/*
 * Created on 23-jun-2005
 * @author co01347e
 */
package p12e.exe.pasarelapagos.test;

import p12f.exe.pasarelapagos.objects.Estado;


/**
 * Clase que encapsula la funcionalidad del host de la Entidad Financiera.
 */
public class HostEntidadFinanciera {
    
    /**
     * Mtodo que simula una transaccin de pago en el host.
     * @param cpr CPR del pago
     * @param rafaga Cdigo de barras que identifica el pago.
     * @return
     */
    public static int transaccionPago(String cpr, String rafaga){
        //System.out.println("----> Se va a realizar la siguiente transaccin de pago:");
        //System.out.println("\t\t\tCPR: " + cpr);
        //System.out.println("\t\t\tRafaga: " + rafaga);
        return 0;
    }
    
    /**
     * Metodo que consulta el resultado de un pago a partir de su cdigo de barras
     * @param paymentCode
     * @return
     */
    public static HostData consultarPorRafaga(String paymentCode){
        HostData hostData = new HostData();
        // Devolvemos el estado de forma aleatoria: 80% pagado, 20% sin datos
        int aleat = (int) Math.round(Math.random()*100);
        if (aleat<=20) {
        	hostData.estadoPago = Estado.PAGADO;
        	hostData.fechaPago = "010206";
            hostData.horaPago = "120000";
            hostData.numeroOperacion = "4874653875643";
            hostData.importe = "8324";
        } else{
        	hostData.estadoPago = Estado.ERROR_PAGO;
        }
        return hostData;
    }
    
    /**
     * Metodo que consulta el resultado de un pago a partir de su cdigo de barras
     * @param paymentCode
     * @return
     */
    public static HostData consultarPorNRC(String nrc){
        HostData hostData = new HostData();        
        // Devolvemos el estado de forma aleatoria: 80% pagado, 20% sin datos
        int aleat = (int) Math.round(Math.random()*100);
        if (aleat<=20) {
        	hostData.estadoPago = Estado.PAGADO;
        	hostData.fechaPago = "010206";
            hostData.horaPago = "120000";
            hostData.numeroOperacion = "4874653875643";
            hostData.importe = "8324";
        } else{
        	hostData.estadoPago = Estado.ERROR_PAGO;
        }
        return hostData;
    }
    
    /**
     * Metodo que consulta el resultado de un pago a partir de su nmero de operacin
     * @param paymentCode
     * @return
     */
    public static HostData consultarPorCodigo(String numeroOperacion){
        HostData hostData = new HostData();  
        // Devolvemos el estado de forma aleatoria: 80% pagado, 20% sin datos
        int aleat = (int) Math.round(Math.random()*100);
        if (aleat<=20) {
        	hostData.estadoPago = Estado.PAGADO;
        	hostData.fechaPago = "010206";
            hostData.horaPago = "120000";
            hostData.numeroOperacion = "4874653875643";
            hostData.importe = "8324";
        } else{
        	hostData.estadoPago = Estado.ERROR_PAGO;
        }
        return hostData;
    }
    
    /**
     * Metodo que consulta el resultado de un pago a partir de su ID
     * @param paymentId
     * @return
     */
    public static HostData consultarPorId(String paymentId){
        HostData hostData = new HostData();
        // Devolvemos el estado de forma aleatoria: 80% pagado, 20% sin datos
        int aleat = (int) Math.round(Math.random()*100);
        if (aleat<=20) {
        	hostData.estadoPago = Estado.PAGADO;
        	hostData.fechaPago = "010206";
            hostData.horaPago = "120000";
            hostData.numeroOperacion = "4874653875643";
            hostData.importe = "8324";
        } else{
        	hostData.estadoPago = Estado.ERROR_PAGO;
        }
        return hostData;
    }
}
