/*
 * Created on 21-jul-2005
 * @author co01347e
 */
package p12e.exe.pasarelapagos.test;

import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.base.FinantialOrgFunctions;
import p12e.exe.pasarelapagos.redirection.ClientRedirector;
import p12f.exe.pasarelapagos.exceptions.FinantialOrgException;
import p12f.exe.pasarelapagos.objects.Estado;
import p12f.exe.pasarelapagos.objects.Pago;
import p12f.exe.pasarelapagos.objects.PaymentData;
import p12f.exe.pasarelapagos.objects.PeriodoPago;

/**
 * Clase de implementacin de ejemplo de los mtodos de la Entidad Financiera.
 */
public class FinantialOrgFunctionsImpl implements FinantialOrgFunctions, java.io.Serializable {
    
    /**
     * Mtodo que realiza las validaciones internas de la Entidad financiera. 
     * @param paymentData Datos de los pagos a realizar.
     * @throws FinantialOrgException
     */
    public void doInternalValidations(PaymentData paymentData)
            throws FinantialOrgException {
        for(Iterator it=paymentData.pagos.keySet().iterator(); it.hasNext(); ) {
            Pago pago = (Pago)paymentData.pagos.get(it.next());
            
            PeriodoPago periodoNormal = (PeriodoPago)pago.datosPago.periodosPago.get(PeriodoPago.PERIODO_NORMAL);
            PeriodoPago periodoVoluntario = (PeriodoPago)pago.datosPago.periodosPago.get(PeriodoPago.PERIODO_VOLUNTARIO);
            PeriodoPago periodoConRecargo = (PeriodoPago)pago.datosPago.periodosPago.get(PeriodoPago.PERIODO_CON_RECARGO);
            
            // Se activa alguno de los periodos.
            if(periodoNormal!=null) {
                periodoNormal.activo = true;
            } else if (periodoVoluntario!=null) {
                periodoVoluntario.activo = true;
            } else if (periodoConRecargo!=null) {
                periodoConRecargo.activo = true;
            }
        }
    }

    /**
     * Mtodo que obtiene el estado de un pago identificado por su CSB.
     * @throws FinantialOrgException
     */
    public Estado doGetPaymentStateDataByCSB(String csb) throws FinantialOrgException {

        HostData hostData = null;	

        hostData = HostEntidadFinanciera.consultarPorRafaga(csb);
 
        Estado estado = new Estado();
        if(Estado.PAGADO.equals(hostData.estadoPago)){
            estado.codigo = Estado.PAGADO;
            estado.numeroOperacion = hostData.numeroOperacion;
            estado.fechaPago = hostData.fechaPago;
            estado.horaPago = hostData.horaPago;
            estado.entidad = "0001";
            estado.importe = hostData.importe;
            estado.nrc = "976376567495696976";
        } else {
        	estado.codigo = Estado.ERROR_PAGO;
        }
        return estado;
    }
    
    /**
     * Mtodo que obtiene el estado de un pago identificado por su NRC.
     * @throws FinantialOrgException
     */
    public Estado doGetPaymentStateDataByNRC(String nrc) throws FinantialOrgException {

        HostData hostData = null;	

        hostData = HostEntidadFinanciera.consultarPorNRC(nrc);
 
        Estado estado = new Estado();
        if(Estado.PAGADO.equals(hostData.estadoPago)){
        	estado.paymentID = "9050704833001501111111111111111111100000001000";
            estado.codigo = Estado.PAGADO;
            estado.numeroOperacion = hostData.numeroOperacion;
            estado.fechaPago = hostData.fechaPago;
            estado.horaPago = hostData.horaPago;
            estado.entidad = "0001";
            estado.importe = hostData.importe;
            estado.nrc = "976376567495696976";
        }else {
            estado.codigo = Estado.ERROR_PAGO;
        }            
        return estado;
    }
    
    /**
     * Mtodo encargado de redirigir al cliente a la pantalla de login de la Entidad Financiera.
     * @param request
     * @param response
     * @param paymentData
     * @param presentationData
     */
    public void doRedirectClient(HttpServletRequest request,
            HttpServletResponse response, 
            String targetUrl,
            EFClass ef) {        
        ClientRedirector.doServerSessionRedirection(request, response, targetUrl, ef);
    }

}
