/*
 * Created on 17-nov-2005
 *
 * @author co01347e
 */
package p12e.exe.pasarelapagos.test;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.bouncycastle.util.encoders.Hex;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.base.FinantialOrgFunctions;
import p12e.exe.pasarelapagos.test.utils.NRCHelper;
import p12f.exe.pasarelapagos.exceptions.FinantialOrgException;
import p12f.exe.pasarelapagos.exceptions.GatewayException;
import p12f.exe.pasarelapagos.objects.AditionalData;
import p12f.exe.pasarelapagos.objects.CreditCardData;
import p12f.exe.pasarelapagos.objects.Estado;
import p12f.exe.pasarelapagos.objects.Pago;
import p12f.exe.pasarelapagos.objects.PaymentData;
import p12f.exe.pasarelapagos.objects.PaymentResult;

import com.ejie.r01f.log.R01FLog;

/**
 * Entidad Financiera Mobile de Simulacin
 */
public class EFMobileServlet extends HttpServlet {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
     * Constructor of the object.
     */
    public EFMobileServlet() {
        super();
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doExec(request, response);
    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to post.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doExec(request, response);
    }
    
    /**
     * The doExec method of the servlet. <br>
     *
     * This method is called from doGet and doPost methods.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doExec(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        
        // Se recogen los parmetros de la peticin
        String module = request.getParameter("module");
        String function = request.getParameter("function");
        String paymentDataXML = request.getParameter("paymentData");
        String presentationDataXML = request.getParameter("presentationData");
        String protocolDataXML = request.getParameter("protocolData");
        String creditCardDataXML = request.getParameter("creditCardData");      
       
        
        
        R01FLog.to("p12e.EFServlet").info("module:\n " + module);
        R01FLog.to("p12e.EFServlet").info("function: " + function);
        R01FLog.to("p12e.EFServlet").info("paymentDataXML: \n" + paymentDataXML);
        R01FLog.to("p12e.EFServlet").info("presentationDataXML:\n " + presentationDataXML);
        R01FLog.to("p12e.EFServlet").info("protocolDataXML: \n" + protocolDataXML);
        
     
      
        String prestacion = request.getParameter("PRESTACION");
        String accion = request.getParameter("ACCION");
        String funcion = request.getParameter("FUNCION");
        String idioma = request.getParameter("idioma");
        
                
        try {
        	
            PrintWriter out = response.getWriter();
        	
            //Se chequea un mnimo de paremtros. Si stos no vienen no hacer nada.
            //En este ejemplo se checkea que vienen los datos de pago y el creditCardData.
        	String[] parameters = {paymentDataXML,creditCardDataXML};
        	
        	if (_checkParameters(parameters) ){
        	
	       
		        // Se instancia la clase que implementa la lgica propia de la Entidad Financiera.
		        FinantialOrgFunctions fof = new FinantialOrgFunctionsImpl();
		       // 1 REALIZAR VALIDACIN CONTRA LA PASARELA"
		        EFClass ef = new EFClass(fof);
		        
		        R01FLog.to("p12e.EFServlet").info(" 1 REALIZAR VALIDACIN CONTRA LA PASARELA");
		        
		        
		        // Se llama al mtodo setPaymentData()
		        ef.setPaymentData(paymentDataXML,
		                          presentationDataXML,
		                          protocolDataXML,
		                          request,
		                          response);
		        
		        //2 REALIZAR VALIDACIN CREDIT CARD DATA
		        R01FLog.to("p12e.EFServlet").info(" 2 REALIZAR VALIDACIN CREDIT CARD DATA :\n");
		        R01FLog.to("p12e.EFServlet").info("creditCardDataXML:\n " + creditCardDataXML);
		        
		        
		        CreditCardData creditCardData = CreditCardData.getObject(creditCardDataXML);
	
		        System.out.println("Parsed="+creditCardData.toXML());
		        System.out.println("******encType:" + creditCardData.encData.encType.toString()); 
		        
		        
		        String creditCardDataExpirationYear =   ((AditionalData)creditCardData.aditionalDataList.get("creditCardDataExpirationYear")).value;
		        String creditCardDataExpirationMonth =  ((AditionalData)creditCardData.aditionalDataList.get("creditCardDataExpirationMonth")).value;
		        
	
	        	System.out.println("creditCardDataExpirationYear="+creditCardDataExpirationYear);      
	        	System.out.println("creditCardDataExpirationMonth="+creditCardDataExpirationMonth);      
	        	
		        
	        	
	        	AditionalData aditionalDataMonth   = new AditionalData();
	            
	        	aditionalDataMonth.name="creditCardDataExpirationMonth";
		        
		        //3 DEVOLVER RESULTADO A LA PASARELA
		        
		       
	            PaymentData paymentData = ef.getPaymentData();
	            /*
	             * Realizar cada uno de los pagos en una transaccin INDEPENDIENTE contra el HOST.
	             * En la peticin puede llegar un slo pago o un pago mltiple, hay que realizar 
	             * una transaccin de pago para cada uno de los pagos del lote.
	             * El objeto PaymentData tiene un mapa con todos los pagos del lote. 
	             * Si se trata de un pago sencillo unicamente hay un elemento.
	             * Basta con recorrer el objeto y realizar una transaccin para cada uno.
	             */
	            Pago currPago = null;
	            int hostResponse = -1;
	            /*
	             * Transaccin por cada pago del lote.
	             */
	            for(Iterator it = paymentData.pagos.keySet().iterator(); it.hasNext();){
		                currPago = (Pago)paymentData.pagos.get(it.next());	     		        
				        Estado estado = new Estado();
				        estado.codigo = Estado.PAGADO;
			            estado.numeroOperacion = "12345678901234";   
			            Date fecha = new Date();
			            SimpleDateFormat dateFormatter = new SimpleDateFormat("ddMMyy");
			            SimpleDateFormat hourFormatter = new SimpleDateFormat("hhmmss");
			            estado.fechaPago = dateFormatter.format(fecha);
			            estado.horaPago = hourFormatter.format(fecha);
			            estado.importe = new Long(currPago.getImporte()).toString();
			            estado.entidad = "9999";
			            estado.oficina = "0001";
			            
			            String emisor = currPago.datosPago.emisor;
			            String referencia = currPago.datosPago.referencia;
			            String importe = estado.importe;
			            String justificante = estado.numeroOperacion;
			            
			            String clave1 = "1111111111111111";
			            String clave2 = "AAAAAAAAAAAAAAAA";
			            String clave = new String(Hex.encode(NRCHelper.doXOR(clave1, clave2))).toUpperCase(); 	            
			            R01FLog.to("p12e.EFServlet").info(" 3 DEVOLVER RESULTADO A LA PASARELA"); 
			            ef.returnSinglePaymentResult(currPago.id, currPago.datosPago ,estado);
	               }
	        
		        
		        //4 DEJAR EN EL RESPONSE EN PAYMENT RESULT PARA EL DISPOSTIVO PETICIONARIO.
		            R01FLog.to("p12e.EFServlet").info(" 4 DEJAR EN EL RESPONSE EN PAYMENT RESULT PARA EL DISPOSTIVO PETICIONARIO.");
		        
					PaymentResult estado = ef.getPaymentResult();
					// Se enva de vuelta el XML del resultado de la operacin
					String returnXML = estado.toXML();
					out.println(returnXML);  
					
        	   }
				
				out.flush();
				out.close();
	             
	      
	        
        } catch(GatewayException ex){
        	throw new ServletException(ex);
        	
        } catch (FinantialOrgException e) {
        	throw new ServletException(e);
		} catch (Exception e) {
			throw new ServletException(e);
		}
    }
    
    
    /*************************************************************************************/
    /*  Funciones Internas    
    /*************************************************************************************/
        
    private static boolean  _checkParameters(String[] params){
    	
    	for (int i = 0 ; i< params.length ;i ++)
    		if (params[i] == null || params[i].equalsIgnoreCase("")) 
    			return false;
    	
    	return true;
    	
    }
    
    
    public static void main(String[] argv) {
    	
    	String param1 = null;
    	String param2 = "peppe";
    	
    	String[] params  = {param1,param2};
    	
    	boolean  resultado = _checkParameters( params );
    	
    	System.out.println(resultado);
    	
    	
    }
    
    
    
}
