package p12e.exe.pasarelapagos.test;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.bouncycastle.util.encoders.Hex;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.base.FinantialOrgFunctions;
import p12e.exe.pasarelapagos.test.utils.NRCHelper;
import p12f.exe.pasarelapagos.exceptions.FinantialOrgException;
import p12f.exe.pasarelapagos.exceptions.GatewayException;
import p12f.exe.pasarelapagos.objects.AccountData;
import p12f.exe.pasarelapagos.objects.Estado;
import p12f.exe.pasarelapagos.objects.Pago;
import p12f.exe.pasarelapagos.objects.PaymentData;
import p12f.exe.pasarelapagos.objects.SignedAuth;
import p12f.exe.pasarelapagos.utils.sign.SignHelper;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;

/**
 * Entidad Financiera de Pago en Cuenta de Simulacin
 */
public class EFAccountServlet extends HttpServlet {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
     * Constructor of the object.
     */
    public EFAccountServlet() {
        super();
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doExec(request, response);
    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to post.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doExec(request, response);
    }
    
    /**
     * The doExec method of the servlet. <br>
     *
     * This method is called from doGet and doPost methods.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doExec(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        
        // Se recogen los parmetros de la peticin
        String module              = request.getParameter("module");
        String function            = request.getParameter("function");
        String paymentDataXML      = request.getParameter("paymentData");
        String presentationDataXML = request.getParameter("presentationData");
        String protocolDataXML     = request.getParameter("protocolData");
        String accountDataXML      = request.getParameter("accountData");    
        String signedAuthDataXML   = request.getParameter("signedAuth");    

        R01FLog.to("p12e.EFServlet").info("[P12E] EFAccountServlet ----------------------------------------- (params)");
        R01FLog.to("p12e.EFServlet").info("[P12E] module   : " + module);
        R01FLog.to("p12e.EFServlet").info("[P12E] function : " + function);
        R01FLog.to("p12e.EFServlet").info("[P12E] XML paymentData:\n       --- " + paymentDataXML);
        R01FLog.to("p12e.EFServlet").info("[P12E] XML presentationData:\n       --- " + presentationDataXML);
        R01FLog.to("p12e.EFServlet").info("[P12E] XML protocolData:\n       --- " + protocolDataXML);
        R01FLog.to("p12e.EFServlet").info("[P12E] XML accountData:\n       --- " + accountDataXML);
        //R01FLog.to("p12e.EFServlet").info("[P12E] XML signedAuth (substring):\n       " + signedAuthDataXML.substring(0, 120) + "...\n"); // doc.original y auth.firmada
        R01FLog.to("p12e.EFServlet").info("[P12E] XML signedAuth:\n       --- " + signedAuthDataXML); // doc.original y auth.firmada
        R01FLog.to("p12e.EFServlet").info("[P12E] EFAccountServlet --------------------------------------------------\n\n");

        // COMPATIBILIDAD DEPRECATED -----------------------------------
		try {
			SignedAuth signedAuth = SignedAuth.getObject(signedAuthDataXML);
	        if (signedAuth.baseAuthContent.document==null || signedAuth.signedAuthContent.signature==null) { // deprecated
	            R01FLog.to("p12e.EFServlet").info("[P12E] !!!!!!!!!!! Convirtiendo signedAuth deprecated recibido a nuevo...");
	    		String signType     = XMLProperties.get("p12f","nshf/defaultReceive/ejgvDocument/header/type"); // xades/SIMPLE_SIGNATURE(cades:PKCS7)
	    		String signLocation = XMLProperties.get("p12f","nshf/defaultReceive/ejgvDocument/header/placement"); // detached

	    		AccountData accountData = AccountData.getObject(accountDataXML);

	    		signedAuthDataXML = SignHelper.iniNewFromDeprecated(signedAuth, accountData.encData.encType, signType, signLocation).toXML(); // compatibilidad provisional con atributos en libreras viejas EF
	        } else {
	            R01FLog.to("p12e.EFServlet").info("[P12E] !!!!!!!!!!! signedAuth recibido...");
	        }
	        R01FLog.to("p12e.EFServlet").info("[P12E] EFAccountServlet --------------------------------------------------\n\n");
		} catch (XOMarshallerException e1) {
			e1.printStackTrace();
		}
        // COMPATIBILIDAD DEPRECATED -----------------------------------
		R01FLog.to("p12e.EFServlet").info("[P12E] XML signedAuth :\n       *** " + signedAuthDataXML); // doc.original y auth.firmada
        
        /**
         * Ejemplo de parmetos variables por Entidad Financiera.
         */
        String prestacion     = request.getParameter("PRESTACION");
        String accion         = request.getParameter("ACCION");
        String funcion        = request.getParameter("FUNCION");
        String idioma         = request.getParameter("idioma");
        String finantialOrgId = request.getParameter("finantialOrgId");

        R01FLog.to("p12e.EFServlet").info("[P12E] Parametros URL PRESTACION: " + prestacion);
        R01FLog.to("p12e.EFServlet").info("[P12E] Parametros URL ACCION:     " + accion);
        R01FLog.to("p12e.EFServlet").info("[P12E] Parametros URL FUNCION:    " + funcion);
        R01FLog.to("p12e.EFServlet").info("[P12E] Parametros URL IDIOMA:     " + idioma);

        try {
	        // Se instancia la clase que implementa la lgica propia de la Entidad Financiera.
	        FinantialOrgFunctions fof = new FinantialOrgFunctionsImpl();

	        // 1 REALIZAR VALIDACIN CONTRA LA PASARELA - - - - - - - - - - - -
	        EFClass ef = new EFClass(fof);
	        
	        R01FLog.to("p12e.EFServlet").info("[P12E] 1 REALIZAR VALIDACIN CONTRA LA PASARELA");
	        
	        // Se llama al mtodo setPaymentData()
	        ef.setPaymentData(paymentDataXML,
	                          presentationDataXML,
	                          protocolDataXML,
	                          accountDataXML,
	                          signedAuthDataXML,
	                          request,
	                          response);

	        R01FLog.to("p12e.EFServlet").info("[P12E] Resultado Validacion [Guardar por la Entidad Finaciera si procede ] :\n" + ef.getValidationtResult());

	        // 2 REALIZAR VALIDACIN ACCOUNT DATA - - - - - - - - - - - - - - -
	        R01FLog.to("p12e.EFServlet").info("[P12E] 2 REALIZAR VALIDACIN ACCOUNT DATA:\n");
	        R01FLog.to("p12e.EFServlet").info("[P12E] creditCardDataXML:\n" + accountDataXML);
	        
	        // 3 DEVOLVER RESULTADO A LA PASARELA - - - - - - - - - - - - - - -
            PaymentData paymentData = ef.getPaymentData();
            /*
             * Realizar cada uno de los pagos en una transaccin INDEPENDIENTE contra el HOST.
             * En la peticin puede llegar un slo pago o un pago mltiple, hay que realizar 
             * una transaccin de pago para cada uno de los pagos del lote.
             * El objeto PaymentData tiene un mapa con todos los pagos del lote. 
             * Si se trata de un pago sencillo unicamente hay un elemento.
             * Basta con recorrer el objeto y realizar una transaccin para cada uno.
             */
            Pago currPago = null;
            /*
             * Transaccin por cada pago del lote.
             */
            for(Iterator it = paymentData.pagos.keySet().iterator(); it.hasNext();){
                currPago = (Pago)paymentData.pagos.get(it.next());	     		        
		        Estado estado = new Estado();
		        estado.codigo = Estado.PAGADO;
	            estado.numeroOperacion = "12345678901234";   
	            Date fecha = new Date();
	            SimpleDateFormat dateFormatter = new SimpleDateFormat("ddMMyy");
	            SimpleDateFormat hourFormatter = new SimpleDateFormat("hhmmss");
	            estado.fechaPago = dateFormatter.format(fecha);
	            estado.horaPago = hourFormatter.format(fecha);
	            estado.importe = new Long(currPago.getImporte()).toString();
	            if (finantialOrgId==null) {
	            	finantialOrgId = "9999";
	            }
	            estado.entidad = finantialOrgId;
	            estado.oficina = "0001";
	            
	            try {
		            String emisor = StringUtils.lPadWithChar(currPago.id.substring(5,16), '0', 11);
		            String referencia = StringUtils.lPadWithChar(currPago.id.substring(16,29), '0', 14);
		            String importe = StringUtils.lPadWithChar(currPago.id.substring(35,45), '0', 11);
		            
		            //String datos = currPago.id;
		            String datos = emisor + referencia + importe + estado.numeroOperacion;
		            
		    		byte[] dataBytes = datos.getBytes();
		    		byte[] dataBytes_EBCDIC = NRCHelper.fromASCII_to_EBCDIC(dataBytes);
		    		
		    		String clave1 = "1111111111111111";
		            String clave2 = "AAAAAAAAAAAAAAAA";
		            String clave = new String(Hex.encode(NRCHelper.doXOR(clave1, clave2))).toUpperCase(); 	            
		    		
		    		byte[] keyBytes = Hex.decode(clave);
	
		            estado.nrc =  estado.numeroOperacion + NRCHelper.calcularMAC(dataBytes_EBCDIC, keyBytes);
	            } catch (Exception e) { }
	            
	            R01FLog.to("p12e.EFServlet").info("[P12E] 3 >>>>>>>>>>>>>>>>>>  DEVOLVER RESULTADO A LA PASARELA"); 
	            
	            ef.returnSinglePaymentResult(currPago.id, currPago.datosPago ,estado);
            }
	        
        } catch(GatewayException ex){
        	throw new ServletException(ex);
        } catch (FinantialOrgException e) {
        	throw new ServletException(e);
		} catch (Exception e) {
			throw new ServletException(e);
		}
    }
}
