package p12e.exe.holdercert.test.host.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import p12e.exe.holdercert.host.engine.HostCertificationEnginePerformerInterface;
import p12e.exe.holdercert.test.utils.HolderCertNRCGenerator;
import p12f.exe.holdercert.utils.HolderCertUtil;
import p12f.exe.pasarelapagos.objects.AccountConstraint;
import p12f.exe.pasarelapagos.objects.AditionalData;
import p12f.exe.pasarelapagos.objects.AditionalHolderDataItem;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertConstants;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;
import p12f.exe.pasarelapagos.objects.HolderCertResponse;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.config.FinantialOrgConfig;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;
import p12f.exe.pasarelapagos.utils.SecurityContextUtils;
import p12m.exe.pasarelapagos.services.config.P12MConfigAPI;
import p12m.exe.pasarelapagos.services.config.P12MConfigFactoryAPI;

import com.ejie.r01f.log.R01FLog;

/**
 * Realiza una validacin mltiple.
 * @author iolabaro
 *
 */
public class HostCertificationEnginePerformerImpl implements HostCertificationEnginePerformerInterface{
	
	HolderCertDataList data= null;
	ProtocolData procolData = null;
	
	/**
	 * Establecer los datos de entrada para validar.
	 * @param data
	 * @param protocolData
	 */
	public void setData(HolderCertDataList data , ProtocolData protocolData) {
		this.data =  data;
		this.procolData = protocolData;
	}
	
	/**
	 * Reaalizar la validacin de los datos de entrada.
	 * @return
	 * @throws Exception 
	 */
	public HolderCertCertifiedDataList  performCertification() throws Exception{
		R01FLog.to("p12e.holderCert").info("MultipleHolderCerPerformer.doCertification");
		HolderCertCertifiedDataList certifiedDataList = new HolderCertCertifiedDataList();
		R01FLog.to("p12e.holderCert").info(">> "+this.data.toXML());
		FinantialOrgConfig finantialOrgConfig = null;
		for (Iterator it =  this.data.dataList.iterator(); it.hasNext();){
			
			HolderCertData currentCertData = (HolderCertData) it.next();
			
			AditionalData aditionalData = (AditionalData)currentCertData.aditionalDataList.get("finantialOrgId");
			String oidEntidad = aditionalData.value;
			if (finantialOrgConfig == null) {
				P12MConfigAPI configApi = P12MConfigFactoryAPI.getConfigManagerAPI();
				SecurityContext cxt = SecurityContextUtils.getSecurityContext("p12e", SecurityContextUtils.SERVICE_CONFIG);
				finantialOrgConfig = FinantialOrgConfig.getObject(configApi.loadFinantialOrgConfigWithKeys(cxt, oidEntidad).resultado.returnValue);
			}
			//currentCertData.aditionalDataList.remove("finantialOrgId");
			
			HolderCertCertifiedData certifiedData = new HolderCertCertifiedData();
			
			certifiedData.holderCertData  = currentCertData;
			
			HolderCertResponse  response = new HolderCertResponse();
			response.finantialOrgCode = oidEntidad;
			
			R01FLog.to("p12e.holderCert").info(" Establecer el tipo de relacin >> -1 : ninguna ; 1 : Titular/cotitular ; 2: Autorizado, -2 : Titular/cotitular con restricciones");
			// Aleatorizar el resultado
			double aleatorio = Math.random();
			R01FLog.to("p12e.holderCert").info("Aleatorio: "+aleatorio);
			if (aleatorio < 0.9) { // Certificacin vlida
				if (aleatorio < 0.1) {
					response.certCode = 2; // autorizado
				} else {
					if (aleatorio < 0.2) { // cambiar por 0.2
						response.certCode = -2; // titular/cotitular con cambio de oficina
						HolderCertData decryptedHolderCertData = HolderCertUtil.decrypt(currentCertData, finantialOrgConfig);
						String newAccount = null;
						String newOffice = (new Double(Math.random())).toString().substring(3, 7);
						if (HolderCertData.ACCOUNT_NUMBER_FORMAT_CC.equals(decryptedHolderCertData.accountNumberFormat)) {
							newAccount = decryptedHolderCertData.itemToCertNumber.substring(0, 4)
									+ newOffice
									+ decryptedHolderCertData.itemToCertNumber.substring(8);
						} else {
							newAccount = decryptedHolderCertData.itemToCertNumber.substring(0, 8)
									+ newOffice
									+ decryptedHolderCertData.itemToCertNumber.substring(12);
						}
						R01FLog.to("p12e.holderCert").info(decryptedHolderCertData.itemToCertNumber+" >>> "+newAccount);
						Map aditionalHolderDataItemMap = new HashMap();
						AditionalHolderDataItem ahdi = new AditionalHolderDataItem();
						ahdi.id = HolderCertConstants.ADITIONAL_ACCOUNT_DATA_CURRENT_HOLDER_DATA;
						decryptedHolderCertData.itemToCertNumber = newAccount;
						decryptedHolderCertData = HolderCertUtil.encrypt(decryptedHolderCertData, finantialOrgConfig);
						ahdi.value = decryptedHolderCertData.itemToCertNumber;
						aditionalHolderDataItemMap.put(ahdi.id, ahdi);
						response.aditionalHolderData = aditionalHolderDataItemMap;
					} else {
						response.certCode = 1; // titular/cotitular
					}
					int aleatConstraint = (new Integer((new Double(aleatorio)).toString().substring(5,6))).intValue();
					if (aleatConstraint < 2) { // tiene restricciones
						AccountConstraint accountConstraint = new AccountConstraint();
						accountConstraint.id = HolderCertConstants.CONSTRAINT_LIST_DISALLOW_WITHDRAW;
						response.accountConstraintList = new HashMap();
						response.accountConstraintList.put(accountConstraint.id, accountConstraint);
					}
				}
				String adminData = currentCertData.requestID;
				String finantialOrgData = oidEntidad + "000000000083739";
				String clave1 = "065E5143070E2D05";
				String clave2 = "0B070A060A0D0F00";
				
				R01FLog.to("p12e.holderCert").info(" Ejemplo de Clculo de NRC con los siguientes datos:\n [Ver clase : p12e.exe.holdercert.test.utils. HolderCertNRCGenerator !!]");
				R01FLog.to("p12e.holderCert").info(" @adminData:"+ adminData+ "\n");
				R01FLog.to("p12e.holderCert").info(" @finantialOrgData:"+ finantialOrgData+ "\n");
				R01FLog.to("p12e.holderCert").info(" @clave1:"+ clave1+ "\n");
				R01FLog.to("p12e.holderCert").info(" @clave1:"+ clave2+ "\n");
				
				String nrc = HolderCertNRCGenerator.generateNRC(adminData, finantialOrgData, clave1, clave2);
				
				R01FLog.to("p12e.holderCert").info("NRC generado: = " + nrc);
				R01FLog.to("p12e.holderCert").info("nrc length = " +  nrc.length());
				
				response.nrc = nrc;
			} else { // Certificacin no vlida
				response.certCode = -1;
			}
			response.timeStamp = Long.toString(System.currentTimeMillis());;
			
			certifiedData.holderCertResponse  = response;
			certifiedDataList.certCertifiedDataList.add(certifiedData);
		}
		certifiedDataList.itemCount = certifiedDataList.certCertifiedDataList.size();
		certifiedDataList.packageID = this.data.packageID;
		R01FLog.to("p12e.holderCert").info("paquete : " + certifiedDataList.packageID );
		return certifiedDataList;
	}

}
