package p12e.exe.holdercert.test.communications;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import p12e.exe.holdercert.communications.HolderCertHTTPPerformerAPI;
import p12f.exe.holdercert.utils.HolderCertDataListZipper;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertResponse;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.Url;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.net.HttpClient;
import com.ejie.r01f.xmlproperties.XMLProperties;

/**
 * Clase que ejecuta la peticin del estado de una pago sobre una entidad financiera.
 */
public class HolderCertHTTPPerformerImpl implements HolderCertHTTPPerformerAPI{
	
	/**
	 * Mtodo que pregunta como cliente a una entidad financiera por el estado de un pago
	 * identificado por su CSB.
	 * @param csb CSB del pago
	 * @param url URL del banco a la que hay que preguntar
	 * @return Estado del pago que se ha solicitado
	 */
	public void performHTTPHolderCertReturnResultAction(HolderCertCertifiedData holderCertData,ProtocolData protocolData){
		R01FLog.to("p12e.holderCert").info("Se ha llamado al metodo performHTTPHolderCertReturnResultAction() del HolderCertHTTPPerformer.");
		try {
			String urlToPost = ((Url) protocolData.urls.get("urlCallBack")).url;
			Map parametersToPost = new HashMap();
			parametersToPost.put("module","certGateway");
			parametersToPost.put("function","holderCertified");
			parametersToPost.put("holderCertCertifiedData",holderCertData.toXML());
			parametersToPost.put("protocolData",protocolData.toXML());
			HttpClient httpClient = new  HttpClient(urlToPost,parametersToPost);
			
			returnHolderCertResponse(httpClient,urlToPost);
		} catch (Exception e) {
			R01FLog.to("p12e.holderCert").info("No se ha recibido el estado de la entidad financiera.");
		
		}
	}
	
	
	/**
	 * Mtodo que pregunta como cliente a una entidad financiera por el estado de un pago
	 * identificado por su CSB.
	 * @param csb CSB del pago
	 * @param protoclData datos de protocolo
	 * @param url URL del banco a la que hay que preguntar
	 * @return Estado del pago que se ha solicitado
	 */
	public void performHTTPHolderCertReturnResultAction(HolderCertCertifiedDataList holderCertDataList, ProtocolData protocolData){
		R01FLog.to("p12e.holderCert").info("Se ha llamado al metodo performHTTPHolderCertReturnResultAction() del HolderCertHTTPPerformer.");
		try {
			byte[] bytes  = HolderCertDataListZipper.zip(holderCertDataList.toXML().getBytes());
			
			ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
			
			String urlToPost = ((Url) protocolData.urls.get("urlCallBack")).url;
			Map parametersToPost = new HashMap();
			parametersToPost.put("module","certGateway");
			parametersToPost.put("function","multipleHolderCertified");
			parametersToPost.put("protocolData",protocolData.toXML());
			parametersToPost.put("holderCertCertifiedDataList", bis);
			
			HttpClient httpClient = new  HttpClient(urlToPost,parametersToPost);
			httpClient.setContentType(HttpClient.MULTIPART_FORM_DATA_FILES_CONTENT_TYPE);
			
			returnHolderCertResponse(httpClient,urlToPost);
		} catch (Exception e) {
			R01FLog.to("p12e.holderCert").info("No se ha recibido el estado de la entidad financiera.");
			e.printStackTrace();
		}
	
	}
	
	
	/**
	 * Mtodo que pregunta como cliente a una entidad financiera por el estado de un pago
	 * identificado por su CSB.
	 * @param csb CSB del pago
	 * @param protoclData datos de protocolo
	 * @param url URL del banco a la que hay que preguntar
	 * @return Estado del pago que se ha solicitado
	 */
	public void performHTTPHolderCertReturnResultActionBatch(HolderCertCertifiedDataList holderCertDataList, ProtocolData protocolData){
		R01FLog.to("p12e.holderCert").info("Se ha llamado al metodo performHTTPHolderCertReturnResultActionBatch() del HolderCertHTTPPerformer.");
		try {
			byte[] bytes  = HolderCertDataListZipper.zip(holderCertDataList.toXML().getBytes());
			
			ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
			
			String urlToPost = ((Url) protocolData.urls.get("urlCallBack")).url;
			Map parametersToPost = new HashMap();
			parametersToPost.put("module","certGateway");
			parametersToPost.put("function","multipleHolderCertifiedBatch");
			parametersToPost.put("protocolData",protocolData.toXML());
			parametersToPost.put("holderCertCertifiedDataList", bis);	
			
			HttpClient httpClient = new  HttpClient(urlToPost,parametersToPost);
			httpClient.setContentType(HttpClient.MULTIPART_FORM_DATA_FILES_CONTENT_TYPE);
			
			returnHolderCertResponse(httpClient,urlToPost);
		} catch (Exception e) {
			R01FLog.to("p12e.holderCert").info("No se ha recibido el estado de la entidad financiera.");
			e.printStackTrace();
		}
	}
	
	
	/* ********************************************************************** */
	/* 							Metodos Privados 							  */
	/* ********************************************************************** */
	
	/**
	 * Mtodo que pregunta como cliente a una entidad financiera por el estado de un pago
	 * @param paymentId Identificador del pago
	 * @param url URL del banco a la que hay que preguntar
	 * @return Estado del pago que se ha solicitado
	 */
	private HolderCertResponse returnHolderCertResponse(HttpClient httpClient,String urlToPost){
		R01FLog.to("p12e.holderCert").info("Se ha llamado al metodo returnHolderCertResposne() del HolderCertHTTPPerformer : " + urlToPost);
		try {
			String proxyHost = null;
			String proxyPort = null;
			String proxyUsr = null;
			String proxyPwd = null;
			if ( XMLProperties.getPropertyNode("p12g","accesoExterior/proxy") != null ){
				String proxyRequired = XMLProperties.getProperty("p12g","accesoExterior/proxy/@required");
				if (proxyRequired.equalsIgnoreCase("true")){
					// Vemos si hay excepciones a la utilizacin del proxy y si la url entra dentro de estas excepciones
					boolean cumpleExcepcion = false;
					String strNumExcepciones = XMLProperties.getProperty("p12g","accesoExterior/numExceptions");
					int numExcepciones = 0;
					if (strNumExcepciones!=null && !"".equals(strNumExcepciones)) {
						try {
							numExcepciones = (new Integer(strNumExcepciones)).intValue();
						} catch (Exception e) { }
					}
					// Recorremos las excepciones para ver si la url cumple alguna
					for (int i=1;i<=numExcepciones;i++) {
						try {
							String excepcion = XMLProperties.getProperty("p12g","accesoExterior/exceptions/exception_"+i);
							Pattern patt = Pattern.compile(excepcion);
							Matcher matcher = patt.matcher(urlToPost);
							if (matcher.matches()) {
								R01FLog.to("p12g.PaymentStateQueryPerformer").info("No se aade proxy a la url: "+urlToPost);
								R01FLog.to("p12g.PaymentStateQueryPerformer").info("Cumple la excepcin: "+excepcion);
								cumpleExcepcion = true;
								break;
							}
						} catch (Exception e) { 
							e.printStackTrace();
						}
					}
					
					if (!cumpleExcepcion) {
						R01FLog.to("p12g.PaymentStateQueryPerformer").info("Se aade proxy a la url: "+urlToPost);
						proxyHost = XMLProperties.getProperty("p12g","accesoExterior/proxy/host");
						proxyPort = XMLProperties.getProperty("p12g","accesoExterior/proxy/port");
						httpClient.setProxyHost(proxyHost, proxyPort); 
						if ( XMLProperties.getPropertyNode("p12g","accesoExterior/proxy/authorization") != null ){
							String authorizationRequired = XMLProperties.getProperty("p12g","accesoExterior/proxy/authorization/@required") ;
							if (authorizationRequired.equalsIgnoreCase("true")){
								proxyUsr = XMLProperties.getProperty("p12g","accesoExterior/proxy/authorization/usr") ;
								proxyPwd = XMLProperties.getProperty("p12g","accesoExterior/proxy/authorization/pwd") ;
								httpClient.setProxyAuthorization(proxyUsr, proxyPwd);
							}
						}
					}
				}
			}
			
			httpClient.sendPostHttpCall();
		}catch(IOException e){
			R01FLog.to("p12e.holderCert").info("No se ha recibido contestacion de la entidad financiera.");
			e.printStackTrace();
		}catch (Exception ex){
			ex.printStackTrace();
		}
		return null;
	}
	
}
