package p12e.exe.holdercert.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.holdercert.api.HolderCerFinantialAPI;
import p12e.exe.holdercert.communications.HolderCertHTTPPerformerAPI;
import p12e.exe.holdercert.host.engine.HostCertificationEnginePerformerInterface;
import p12f.exe.holdercert.utils.HolderCertParamParser;
import p12f.exe.pasarelapagos.objects.AditionalData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;
import p12f.exe.pasarelapagos.objects.ProtocolData;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;

public class EFHolderCertAsynchronousServlet extends HttpServlet {
	
	/**
	 * Constructor of the object.
	 */
	public EFHolderCertAsynchronousServlet() {
		super();
	}
	
	public void init() throws ServletException {

	}
	
	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			_doExec(request, response);
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			_doExec(request, response);
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	private void _doExec(HttpServletRequest request, HttpServletResponse response) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InterruptedException {
		HostCertificationEnginePerformerInterface _hostImplementationClass  = (HostCertificationEnginePerformerInterface) Class.forName(XMLProperties.getProperty("p12e","hostPerformerImplementation/class")).newInstance();
		HolderCertHTTPPerformerAPI _httpPerformerImplementationClass =  (HolderCertHTTPPerformerAPI) Class.forName(XMLProperties.getProperty("p12e","httpPerformerImplementation/class")).newInstance();
		
		HolderCertParamParser paramParser = new HolderCertParamParser ();
		paramParser.parse(request,response);
		long timeToSleep = -1;
		try {
			if (paramParser.parameters.containsKey("sleep")) {
				try {
					timeToSleep = (new Long((String)paramParser.parameters.get("sleep"))).longValue();
					if (paramParser.parameters.containsKey("random") && "true".equals((String)paramParser.parameters.get("random"))) {
						timeToSleep = (new Double(Math.random()*timeToSleep)).longValue();
					}
				} catch (Exception e) { }
			}
		} catch (Exception e) { }
		
		boolean isMultipartContent = isMultipartContent(request);
		ProcessAsynchronousRequest processAsynchronousRequest = new ProcessAsynchronousRequest(_hostImplementationClass, 
				_httpPerformerImplementationClass, paramParser, isMultipartContent, timeToSleep);
		processAsynchronousRequest.start();
		
		try {
			if (paramParser.parameters.containsKey("sleepReturnConx")) {
				try {
					long timeToSleepBeforeReturnCons = (new Long((String)paramParser.parameters.get("sleepReturnConx"))).longValue();
					if (paramParser.parameters.containsKey("random") && "true".equals((String)paramParser.parameters.get("random"))) {
						timeToSleepBeforeReturnCons = (new Double(Math.random()*timeToSleepBeforeReturnCons)).longValue();
					}
					R01FLog.to("p12e.holderCert").info("\n>>>> Inicio simulacin espera de "+timeToSleepBeforeReturnCons+" milisegundos antes de cerrar la conexin\n");
					Thread.sleep(timeToSleepBeforeReturnCons);
				} catch (Exception e) { }
			}
		} catch (Exception e) { }
		R01FLog.to("p12e.holderCert").info("[EFHolderCertAsynchronousServlet Finalizada llamada asncrona]");
	}
	
	
	private class ProcessAsynchronousRequest  extends Thread implements Runnable {
		
		private HostCertificationEnginePerformerInterface	_hostImplementationClass; 
		private HolderCertHTTPPerformerAPI					_httpPerformerImplementationClass;
		private HolderCertParamParser 						_paramParser;
		private boolean										_isMultiplart;
		private long										_sleep;
		
		ProcessAsynchronousRequest(HostCertificationEnginePerformerInterface _hostImplementationClass, 
				HolderCertHTTPPerformerAPI _httpPerformerImplementationClass,
				HolderCertParamParser paramParser, boolean isMultiplart, long sleep){
			this._hostImplementationClass = _hostImplementationClass;
			this._httpPerformerImplementationClass = _httpPerformerImplementationClass;
			this._paramParser = paramParser;
			this._isMultiplart = isMultiplart;
			this._sleep = sleep;
		}
		
		public void run() {
			doExec();
		}
		
		/**
		 * Ejecucin de la Validacion
		 * @param request
		 * @param response
		 * @throws ServletException 
		 */
		private void doExec() {
			try {
				R01FLog.to("p12e.holderCert").info("[EFHolderCertAsynchronousServlet  EF HOLDER CERT SERVLET]");
				R01FLog.to("p12e.holderCert").info("=========================================================");
				
				if (_sleep > 0) {
					R01FLog.to("p12e.holderCert").info("\n>>>> Inicio simulacin espera de "+_sleep+" milisegundos antes de responder\n");
					Thread.sleep(_sleep);
				}
				
				if (!_isMultiplart){
					
					HolderCertData data = (HolderCertData)  HolderCertData.getObject((String)_paramParser.getParam(HolderCertParamParser.HOLDERCERT_DATA));
					ProtocolData protocolData = (ProtocolData) ProtocolData.getObject( (String) _paramParser.getParam(HolderCertParamParser.PROTOCOL_DATA));
					String finantialOrgId = (String)_paramParser.getParam(HolderCertParamParser.FINANTIALORGCODE);
					if (data.aditionalDataList==null) {
						data.aditionalDataList = new HashMap();
					}
					AditionalData datoAdicional = new AditionalData();
					datoAdicional.name = "finantialOrgId";
					datoAdicional.value = finantialOrgId;
					//data.aditionalDataList.put("finantialOrgId", finantialOrgId);
					data.aditionalDataList.put("finantialOrgId", datoAdicional);
					
					R01FLog.to("p12e.holderCert").info(">> Validacin Simple Asncrona");
					HolderCerFinantialAPI holderCertAPI = new HolderCerFinantialAPI();	
					
					R01FLog.to("p12e.holderCert").info("\n>> 1. Set Function");
					holderCertAPI.setFunction(HolderCerFinantialAPI.HOLDER_CERT_FUNCTION);
					
					R01FLog.to("p12e.holderCert").info("\n>> 2. Add HolderCertData to cert");
					holderCertAPI.addHolderCertDataItem(data);
					
					R01FLog.to("p12e.holderCert").info("\n>> 3. Set host engine ");
					holderCertAPI.setHostCertificationEngine(this._hostImplementationClass);
					
					R01FLog.to("p12e.holderCert").info("\n>> 4. Do Certification ");
					HolderCertCertifiedData certData = (HolderCertCertifiedData)holderCertAPI.doCertification().certCertifiedDataList.get(0);
				
					R01FLog.to("p12e.holderCert").info("\n>> 5. Return result ");
					_httpPerformerImplementationClass.performHTTPHolderCertReturnResultAction(certData, protocolData);
					
				} else {
					
					R01FLog.to("p12e.holderCert").info(">> Validacin Mltiple Asncrona");
					InputStream  is = (InputStream)_paramParser.getParam(HolderCertParamParser.HOLDERCERT_DATA_LIST);
					ProtocolData protocolData = (ProtocolData) ProtocolData.getObject((String)_paramParser.getParam(HolderCertParamParser.PROTOCOL_DATA));
					String function  =  (String)_paramParser.getParam(HolderCertParamParser.FUNCTION);
					String finantialOrgId = (String)_paramParser.getParam(HolderCertParamParser.FINANTIALORGCODE);
					
					R01FLog.to("p12e.holderCert").info(" Convertir Stream a  HoldercertDatalist");
					HolderCertDataList list =  HolderCerFinantialAPI.convertStreamToHolderCertdataList(is, protocolData);
					HolderCerFinantialAPI holderCertAPI = new HolderCerFinantialAPI();	
					
					R01FLog.to("p12e.holderCert").info("\n>> 1. Set Function :");
					if (function.equalsIgnoreCase(HolderCertParamParser.HOLDERCERT_MULTIPLE_FUNCTION_RECEIVE)){
						R01FLog.to("p12e.holderCert").info("Multiple Holder Cert Function");
						holderCertAPI.setFunction(HolderCerFinantialAPI.MULTIPLE_HOLDER_CERT_FUNCTION);
					}else{
						R01FLog.to("p12e.holderCert").info("Multiple Holder Cert Batch Function");
						holderCertAPI.setFunction(HolderCerFinantialAPI.MULTIPLE_HOLDER_CERT_FUNCTION_BATCH);
					}	
					
					R01FLog.to("p12e.holderCert").info("\n>> 2. Add HolderCertData to cert");
					for (Iterator it = list.dataList.iterator(); it.hasNext(); ){
						HolderCertData currentHolderCertdata = (HolderCertData) it.next();
						if (currentHolderCertdata.aditionalDataList==null) {
							currentHolderCertdata.aditionalDataList = new HashMap();
						}
						AditionalData datoAdicional = new AditionalData();
						datoAdicional.name = "finantialOrgId";
						datoAdicional.value = finantialOrgId;
						//currentHolderCertdata.aditionalDataList.put("finantialOrgId", finantialOrgId);
						currentHolderCertdata.aditionalDataList.put("finantialOrgId", datoAdicional);
						holderCertAPI.addHolderCertDataItem(currentHolderCertdata);
					}
					
					R01FLog.to("p12e.holderCert").info("\n>> 3. Set PackageID");
					holderCertAPI.setPackageID(list.packageID);;
					
					R01FLog.to("p12e.holderCert").info("\n>> 4. Set host engine ");
					holderCertAPI.setHostCertificationEngine(this._hostImplementationClass);
					
					R01FLog.to("p12e.holderCert").info("\n>> 5. Do Certification ");
					HolderCertCertifiedDataList certData = holderCertAPI.doCertification();
					
					R01FLog.to("p12e.holderCert").info("\n>> 6. Return result ");
					if (function.equalsIgnoreCase(HolderCertParamParser.HOLDERCERT_MULTIPLE_FUNCTION_RECEIVE)){	
						_httpPerformerImplementationClass.performHTTPHolderCertReturnResultAction(certData, protocolData);
					}  else {
						_httpPerformerImplementationClass.performHTTPHolderCertReturnResultActionBatch(certData, protocolData);
					}
					
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
			R01FLog.to("p12e.holderCert").info("=======  END  ==========");
		}
		
	}
	
	public static final boolean isMultipartContent(HttpServletRequest request) {
		if (!"post".equals(request.getMethod().toLowerCase())) {
			return false;
		}
		String contentType = request.getContentType();
		if (contentType == null) {
			return false;
		}
		return contentType.toLowerCase().startsWith("multipart/");
	}
	
}
