package p12e.exe.pasarelapagos.test.utils;

import java.io.Serializable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.base.FinantialOrgFunctions;
import p12e.exe.pasarelapagos.gatewayclient.GatewayAPI;
import p12f.exe.pasarelapagos.cancellation.CancellationData;
import p12f.exe.pasarelapagos.cancellation.CancellationResult;
import p12f.exe.pasarelapagos.exceptions.FinantialOrgException;
import p12f.exe.pasarelapagos.exceptions.GatewayException;
import p12f.exe.pasarelapagos.objects.AccountData;
import p12f.exe.pasarelapagos.objects.DatosPago;
import p12f.exe.pasarelapagos.objects.Estado;
import p12f.exe.pasarelapagos.objects.HolderCertResponse;
import p12f.exe.pasarelapagos.objects.Mensaje;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.pasarelapagos.objects.Pago;
import p12f.exe.pasarelapagos.objects.PaymentData;
import p12f.exe.pasarelapagos.objects.PaymentQueryData;
import p12f.exe.pasarelapagos.objects.PaymentResult;
import p12f.exe.pasarelapagos.objects.PaymentStateData;
import p12f.exe.pasarelapagos.objects.PresentationData;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.SignedAuth;
import p12f.exe.pasarelapagos.objects.ValidationResult;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.rpcdispatcher.RPCException;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;

/**
 * Clase que implementa la comunicacin entre la Entidad Financiera y la Pasarela de Pagos
 */
public class EFClassSampleImpl implements EFClass, Serializable {
	
	private static final long serialVersionUID = -6340481739372435320L;
	
	private FinantialOrgFunctions _foImpl = null;
	
	// Parmetros de Entrada.
	private PaymentData _paymentData = null;
	private CancellationData _cancellationData = null;
	private PresentationData _presentationData = null;
	private ProtocolData _protocolData = null;
	private PaymentResult _paymentResult = null;
	private CancellationResult _cancellationResult = null;
	private AccountData _accountData = null;
	private SignedAuth _signedAuth = null;
	
	// Parmetros de salida.
	private  ValidationResult _validationResult = null;
	
	/** 
	 * @return Devuelve un objeto PaymentData.
	 */
	public PaymentData getPaymentData() {
		return _paymentData;
	}
	
	/**
	 * @return Devuelve un objeto PresentationData.
	 */
	public PresentationData getPresentationData() {
		return _presentationData;
	}
	
	/**
	 * @return Devuelve un objeto ProtocolData.
	 */
	public ProtocolData getProtocolData() {
		return _protocolData;
	}
	
	/**
	 * @return Devuelve un objeto PaymentResult.
	 */
	public ValidationResult getValidationtResult() {
		return this._validationResult;
	}
	
	/**
	 * @return Devuelve un objeto PaymentResult.
	 */
	public PaymentResult getPaymentResult() {
		return _paymentResult;
	}
	
	/**
	 * Constructor of the object.
	 * @param impl
	 * @param request
	 * @param response
	 */
	public EFClassSampleImpl(final FinantialOrgFunctions impl) {
		_foImpl = impl;
	}
	
	public EFClassSampleImpl( final String paymentDataXML, 
						final String presentationDataXML, 
						final String protocolDataXML){
		try {
			_paymentData = PaymentData.getObject(paymentDataXML);
			_presentationData = PresentationData.getObject(presentationDataXML);
			_protocolData = ProtocolData.getObject(protocolDataXML);
			//	_protocolData = new ProtocolData();
		} catch(XOMarshallerException ex) {
			ex.printStackTrace();
		}
	}
	
	/**
	 * Mtodo que establece los datos del pago y la forma en que van a ser presentados.
	 * @param paymentData Datos del pago
	 * @param presentationData Datos de presentacion visual del pago. 
	 * @throws RPCException Si se produce algn error durante el proceso.
	 */
	public void setPaymentData( final String paymentDataXML, 
								final String presentationDataXML, 
								final String protocolDataXML,
								final HttpServletRequest request,
								final HttpServletResponse response) throws GatewayException, FinantialOrgException{
		try {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>>> Recibidos datos para realizar un nuevo pago:");
			// Convertimos los XMLs recibidos en objetos.            
			_paymentData = PaymentData.getObject(paymentDataXML);
			_presentationData = PresentationData.getObject(presentationDataXML);
			_protocolData = ProtocolData.getObject(protocolDataXML);
			
			/*
			 * PASO 1: Validacin de los datos Contra la Pasarela de la Administracin 
			 */
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>> Se validan los pagos contra la pasarela.");
			
			// Si la validacion es errnea saltar una excepcin
			_validatePaymentData();
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>> La validacin contra la pasarela ha sido CORRECTA.");
			
			/*
			 * PASO 2: Validaciones internas de la entidad financiera
			 */
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La Entidad Financiera realiza su validacion.");            
			//FinantialOrgFunctions fof = (FinantialOrgFunctions)ReflectionUtils.getObjectInstance(XMLProperties.get("p12et","/finantialOrgFuntionsImplClassName"));
			_foImpl.doInternalValidations(_paymentData);
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La validacion de la Entidad Financiera ha sido CORRECTA.");
			
			/*
			 * Normalmente una vez hechas las validaciones de los datos, la Entidad
			 * Financiera redirige al usuario a una pgina en la que se presentan los
			 * datos del pago al ciudadano.
			 */
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Se redirige al cliente a la pantalla de login de la Entidad Financiera.");        
		} catch (XOMarshallerException ex) {
			throw new GatewayException("Se ha producido un error en el parseo XML.");
		}
	}
	
	/**
	 * Mtodo que establece los datos del pago y la forma en que van a ser presentados.
	 * @param cancellationData Datos de cancelacin
	 * @param protocolData Datos de protocolo. 
	 * @throws RPCException Si se produce algn error durante el proceso.
	 */
	public String setCancellationData(final String cancellationDataXML, 
									  final String protocolDataXML,
									  final HttpServletRequest request,
									  final HttpServletResponse response) throws GatewayException, FinantialOrgException{
		try{
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>>> Recibidos datos para cancelar pago:");
			// Convertimos los XMLs recibidos en objetos.
			_cancellationData = CancellationData.getObject(cancellationDataXML);
			_protocolData = ProtocolData.getObject(protocolDataXML);
			
			/*
			 * PASO 1: Validacin de los datos Contra la Pasarela de la Administracin 
			 */
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>> Se validan los pagos contra la pasarela.");
			
			// Si la validacion es errnea saltar una excepcin
			String pagoId = _validateCancellationData();
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>> La validacin contra la pasarela ha sido CORRECTA.");
			
			/*
			 * PASO 2: Validaciones internas de la entidad financiera
			 */
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La Entidad Financiera realiza su validacion.");
			//FinantialOrgFunctions fof = (FinantialOrgFunctions)ReflectionUtils.getObjectInstance(XMLProperties.get("p12et","/finantialOrgFuntionsImplClassName"));
			// TODO simular alguna validacin interna de las entidades financieras
			//_foImpl.doInternalValidations(_paymentData);
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La validacion de la Entidad Financiera ha sido CORRECTA.");
			
			/*
			 * Normalmente una vez hechas las validaciones de los datos, la Entidad
			 * Financiera redirige al usuario a una pgina en la que se presentan los
			 * datos del pago al ciudadano.
			 */
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Se redirige al cliente a la pantalla de login de la Entidad Financiera.");
			
			return pagoId;
		}catch(XOMarshallerException ex){
			throw new GatewayException("Se ha producido un error en el parseo XML.");
		}
	}
	
	/**
	 * Mtodo que establece los datos del pago y la forma en que van a ser presentados.
	 * @param paymentData Datos del pago
	 * @param presentationData Datos de presentacion visual del pago. 
	 * @throws RPCException Si se produce algn error durante el proceso.
	 */
	public void setPaymentData( final String paymentDataXML, 
								final String presentationDataXML, 
								final String protocolDataXML,
								final String accountDataXML,
								final String signedAuthDataXML,
								final HttpServletRequest request,
								final HttpServletResponse response) throws GatewayException, FinantialOrgException{
		try {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>>> Recibidos datos para realizar un nuevo pago en cuenta: ");
			// Convertimos los XMLs recibidos en objetos.
			_paymentData      = PaymentData.getObject(paymentDataXML);
			_presentationData = PresentationData.getObject(presentationDataXML);
			_protocolData     = ProtocolData.getObject(protocolDataXML);
			_accountData      = AccountData.getObject(accountDataXML); 
			_signedAuth       = SignedAuth.getObject(signedAuthDataXML); 
			/*
			 * PASO 1: Validacin de los datos Contra la Pasarela de la Administracin 
			 */
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] Se validan los pagos contra la pasarela.");
			
			// Si la validacion es errnea saltar una excepcin
			_validatePaymentOnAccountData();
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] La VALIDACION contra la PASARELA ha sido CORRECTA.");
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] XML resultado validacin: " + this._validationResult.toXML());	
			
			/*
			 * PASO 2: Validaciones internas de la entidad financiera
			 */
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] La Entidad Financiera realiza su validacion.");            
			_foImpl.doInternalValidations(_paymentData);
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] La VALIDACION de la ENTIDAD FINANCIERA ha sido CORRECTA.");
			
			/*
			 * Normalmente una vez hechas las validaciones de los datos, la Entidad
			 * Financiera redirige al usuario a una pgina en la que se presentan los
			 * datos del pago al ciudadano.
			 */
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] Se redirige al cliente a la pantalla de login de la Entidad Financiera.");        
		} catch (XOMarshallerException ex) {
			throw new GatewayException("Se ha producido un error en el parseo XML.");
		}
	}
	
	/**
	 * Mtodo que valida los pagos recibidos contra la pasarela.
	 * @return Resultado de la validacin.
	 */
	private void _validatePaymentOnAccountData() throws GatewayException{
		try {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] Llamar a la Pasarela para validar los pagos recibidos.");
			GatewayAPI gatewayAPI = new GatewayAPI();
			OperationResult operationResult = gatewayAPI.validatePaymentData(_paymentData, _protocolData,_accountData,_signedAuth);
			
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] Comprobar que el resultado de la validacin sea correcto.");
			
			ValidationResult result = ValidationResult.getObject(operationResult.resultado.returnValue);
			
			this._validationResult = result;
			
			boolean resultadoOK = result.resultado;
			
			if (resultadoOK) {
				R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] La validacin ha sido CORRECTA.");	
			} else {
				R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS][PAGODIRECTO] La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
				throw new GatewayException("La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
			}
		} catch (Exception ex) {
			throw new GatewayException("La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
		}
	} 
	
	/**
	 * Mtodo que valida los pagos recibidos contra la pasarela.
	 * @return Resultado de la validacin.
	 */
	private void _validatePaymentData() throws GatewayException{
		try {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Llamar a la Pasarela para validar los pagos recibidos.");
			GatewayAPI gatewayAPI = new GatewayAPI();
			OperationResult operationResult = gatewayAPI.validatePaymentData(_paymentData, _protocolData);
			
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Comprobar que el resultado de la validacin sea correcto.");
			ValidationResult result = ValidationResult.getObject(operationResult.resultado.returnValue);
			
			this._validationResult = result;
			
			boolean resultadoOK = result.resultado;
			
			if (resultadoOK) {
				R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La validacin ha sido CORRECTA.");	
			} else {
				R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
				throw new GatewayException("La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
			}
		}catch (Exception  ex){
			ex.printStackTrace();
			throw new GatewayException("La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
		}
	}
	
	/**
	 * Mtodo que valida los pagos recibidos contra la pasarela.
	 * @return Resultado de la validacin.
	 */
	private String _validateCancellationData() throws GatewayException{
		R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Llamar a la Pasarela para validar los pagos recibidos.");
		GatewayAPI gatewayAPI = new GatewayAPI();
		OperationResult operationResult = null;
		ValidationResult result = null;
		try {
			operationResult = gatewayAPI.validateCancellationData(_cancellationData, _protocolData);
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Comprobar que el resultado de la validacin sea correcto.");
			result = ValidationResult.getObject(operationResult.resultado.returnValue);
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new GatewayException("La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
		}
		this._validationResult = result;
		
		boolean resultadoOK = result.resultado;
		
		if (resultadoOK) {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La validacin ha sido CORRECTA.");
			return result.pago.id;
		} else {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
			if (result.mensajes.containsKey("errorCancellation")) {
				Mensaje errorMsg = (Mensaje)result.mensajes.get("errorCancellation");
				R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS] Error cancelacin: "+errorMsg.texto.get("es"));
				throw new GatewayException("La operacin de validacin ha sido INCORRECTA: "+errorMsg.texto.get("es"));
			}
			throw new GatewayException("La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
		}
	}
	
	/**
	 *	Mtodo que introduce el resultado de un pago individual dentro de la estructura
	 *	que ser enviada a la Pasarela de Pagos.
	 */
	public void setSinglePaymentResult(final String idPago, final DatosPago datosPago, final Estado estado) {
		if(_paymentResult==null){
			_paymentResult = new PaymentResult();
		}
		// Se crea el objeto en el que se guarda el resultado de un pago.
		PaymentStateData paymentStateData = new PaymentStateData();
		paymentStateData.id = idPago;
		paymentStateData.datosPago = datosPago;
		paymentStateData.estado = estado;
		
		_paymentResult.paymentStateDatas.put(paymentStateData.id, paymentStateData);
	}
	
	/**
	 *	Mtodo que devuelve el resultado de un pago individual a la Pasarela de Pagos.
	 */
	public void returnSinglePaymentResult(final String idPago, final DatosPago datosPago, final Estado estado) throws GatewayException{        
		if(_paymentResult==null){
			_paymentResult = new PaymentResult();
		}
		// Se crea el objeto en el que se guarda el resultado de un pago.
		PaymentStateData paymentStateData = new PaymentStateData();
		paymentStateData.id = idPago;
		paymentStateData.datosPago = datosPago;
		paymentStateData.estado = estado;
		
		_paymentResult.paymentStateDatas.put(paymentStateData.id, paymentStateData);
		// Se crea una nueva estructura PeymentResult que sera la que contenga el pago simple
		PaymentResult paymentResult = new PaymentResult();
		paymentResult.paymentStateDatas.put(paymentStateData.id, paymentStateData);
		
		GatewayAPI pasarela = new GatewayAPI();
		
		try {
			OperationResult resultado = pasarela.setPaymentResult(paymentResult, _protocolData);
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]OperationResult:\n" + resultado.toXML());
		} catch(GatewayException ex) {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Se ha producido un error en la pasarela.");
			throw ex;
		} catch (XOMarshallerException ex) {
			ex.printStackTrace();
		}
	}
	
	/**
	 *	Mtodo que devuelve el resultado de un pago individual a la Pasarela de Pagos.
	 */
	public void returnCancellationResult(final String idPago, final CancellationData datosCancelacion, final Estado estado) throws GatewayException{        
		if(_cancellationResult==null){
			_cancellationResult = new CancellationResult();
		}
		// Se crea el objeto en el que se guarda el resultado de un pago.
		_cancellationResult.id = idPago;
		_cancellationResult.cancellationData = datosCancelacion;
		_cancellationResult.estado = estado;
		
		GatewayAPI pasarela = new GatewayAPI();
		
		try{
			OperationResult resultado = pasarela.setCancellationResult(_cancellationResult, _protocolData);
			
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]OperationResult:\n" + resultado.toXML());
		}catch(GatewayException ex){
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Se ha producido un error en la pasarela.");
			throw ex;
		}catch(XOMarshallerException ex){
			ex.printStackTrace();
		}
	}
	
	/**
	 * Mtodo que devuelve el resultado de los pagos a la Pasarela de la Administracin.
	 */
	public void returnPaymentResult() throws GatewayException {
		GatewayAPI pasarela = new GatewayAPI();
		// Como no ha llegado el ProtocolData se crea aqui
		_protocolData = new ProtocolData();
		try {
			OperationResult resultado = pasarela.setPaymentResult(_paymentResult, _protocolData);
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]OperationResult:\n" + resultado.toXML());
		} catch (GatewayException ex) {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Se ha producido un error en la pasarela.");
			throw ex;
		} catch (XOMarshallerException ex) {
			ex.printStackTrace();
		}
	}
	
	/**
	 * Mtodo que obtiene el estado de un pago identificado por su CSB.  
	 * @param csb
	 * @return Estado
	 * @throws RPCException
	 */
	public Estado getPaymentStateDataByCSB(final String csb, final String protocolDataXML) throws GatewayException, FinantialOrgException{    
		try {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Se valida la solicitud de validacin contra la pasarela.");
			PaymentQueryData paymentQueryData = new PaymentQueryData();
			paymentQueryData.csb = csb;
			ProtocolData protocolData = ProtocolData.getObject(protocolDataXML);
			_protocolData = protocolData;
			// Si la validacion es errnea saltar una excepcin
			_validatePaymentQuery(paymentQueryData);
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La validacin contra la pasarela ha sido CORRECTA.");
			
			// Se llama a la clase que implementa la lgica necesaria del host para construir un objeto Estado :
			Estado estado =  _foImpl.doGetPaymentStateDataByCSB(csb);
			return estado;
		} catch (XOMarshallerException e) {
			throw new FinantialOrgException("Error de parseo del ProtocolData");
		} 
	}
	
	/**
	 * Mtodo que obtiene el estado de un pago identificado por su NRC.
	 * @param nrc
	 * @return Estado
	 * @throws RPCException
	 */
	public Estado getPaymentStateDataByNRC(final String nrc, final String protocolDataXML) throws GatewayException, FinantialOrgException{
		try {
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Se valida la solicitud de validacin contra la pasarela.");
			PaymentQueryData paymentQueryData = new PaymentQueryData();
			paymentQueryData.nrc = nrc;
			ProtocolData protocolData = ProtocolData.getObject(protocolDataXML);
			_protocolData = protocolData;
			// Si la validacion es errnea saltar una excepcin
			_validatePaymentQuery(paymentQueryData);
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La validacin contra la pasarela ha sido CORRECTA.");
			
			// Se llama a la clase que implementa la lgica necesaria del host para construir un objeto Estado :
			Estado estado =  _foImpl.doGetPaymentStateDataByNRC(nrc);     
			return estado;
		} catch (XOMarshallerException e) {
			throw new FinantialOrgException("Error de parseo del ProtocolData");
		} 
	}
	
	/**
	 * Mtodo que valida la solicitud de estado de pago recibida contra la pasarela.
	 * @param paymentQueryData Identificacin del pago cuyo estado se solicita.
	 * @return Resultado de la validacin.
	 */
	private Pago _validatePaymentQuery(final PaymentQueryData paymentQueryData) throws GatewayException{
		R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Llamamos a la pasarela para validar la solicitud de pago.");
		GatewayAPI gatewayAPI = new GatewayAPI();               
		OperationResult operationResult = gatewayAPI.validatePaymentQuery(paymentQueryData, _protocolData);
		R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]Comprobamos que el resultado de la validacin sea correcto.");
		boolean resultadoOK = operationResult.resultado.resultadoOK;
		if(resultadoOK){
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La validacin ha sido CORRECTA.");
			Pago pago;
			try {
				pago = Pago.getObject(operationResult.resultado.returnValue);
			} catch (XOMarshallerException e) {
				throw new GatewayException("Error de parseo de la informacin del pago recibida.");
			}
			return pago;
		}
		
		R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
		throw new GatewayException("La operacin de validacin ha sido INCORRECTA o no se ha podido realizar.");
	}
	
	public HolderCertResponse holderCert(final String holderCertDataXML) throws GatewayException {
		R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>> HolderCertResponse  Validacin de los siguientes datos\n : " + holderCertDataXML  );
		try {
			
			//HolderCertData holderCertData = HolderCertData.getObject(holderCertDataXML);
			HolderCertResponse response = new HolderCertResponse();
			response.finantialOrgCode  = "9999";
			response.timeStamp  = System.currentTimeMillis() + "";;
			
			//Random random =  new Random();
			
			//response.isValid  = random.nextBoolean();
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>> Resultado de la validacin : " + response.toXML() );
			
			return response;
			
		} catch (XOMarshallerException e) {
			throw new GatewayException(e);
		}
		
	} 
	
	public HolderCertResponse holderCert(final String holderCertDataXML, final String protocolDataXML) throws GatewayException {
		R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>> HolderCertResponse  Validacin de los siguientes datos\n : " + holderCertDataXML  );
		try {
			HolderCertResponse response = new HolderCertResponse();
			
			response.finantialOrgCode  = "9999";
			response.timeStamp  = System.currentTimeMillis() + "";;
			
			R01FLog.to("p12et.EFClass").info("[P12E][EFCLASS]>> Resultado de la validacin : " + response.toXML() );
			
			return response;
		} catch (XOMarshallerException e) {
			throw new GatewayException(e);
		}
		
	}
	
}
