package p12e.exe.pasarelapagos.test;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.test.utils.EFClassSampleImpl;


/**
 * 
 */
public class EFVentanillaServlet extends HttpServlet {

	private static final long serialVersionUID = -3678313625286607211L;

	/**
     * Constructor of the object.
     */
    public EFVentanillaServlet() {
        super();
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doExec(request, response);
    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to post.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doExec(request, response);
    }
    
    /**
     * The doExec method of the servlet. <br>
     *
     * This method is called from doGet and doPost methods.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doExec(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {        
        String module = request.getParameter("module");
        String function = request.getParameter("function");
        
        if(function.equals("setPaymentData")){
            String paymentDataDataXML = request.getParameter("paymentData");
            String presentationDataXML = request.getParameter("presentationData");
            String protocolDataXML = request.getParameter("protocolData");
        
            FinantialOrgFunctionsImplVentanilla fof = new FinantialOrgFunctionsImplVentanilla();
            
            EFClass ef = new EFClassSampleImpl(fof);
            try{
	            ef.setPaymentData(paymentDataDataXML,
	                    presentationDataXML,
	                    protocolDataXML,
	                    request,
	                    response);
	            // Se redirige al cliente a la pgina de login de la Entidad Financiera
	            fof.doRedirectClient(request,response,"loginVentanilla.jsp?",ef);
            }catch(Exception ex){
                ex.printStackTrace();
            }
        }
    }

}
