package p12e.exe.holdercert.test.utils;

import org.bouncycastle.util.encoders.Hex;

import p12e.exe.pasarelapagos.utils.NRCHelper;

/**
 * Calse que gener un NRC vlido para una generac 
 * @author iolabaro
 */
public class HolderCertNRCGenerator {
	
	/**
	 * Ejemplo de Generacin de NRC para validacin de datos.
	 * @param adminData
	 * @param finantialOrgdata
	 * @param clave1
	 * @param clave2
	 * @return
	 * @throws Exception
	 */
	public static String generateNRC ( String adminData , String finantialOrgdata, String clave1, String clave2) throws Exception {
		
		String clave = new String(Hex.encode(NRCHelper.doXOR(clave1, clave2))).toUpperCase();
		
		String datos = adminData +  finantialOrgdata + "0"; // Digito de paridad.
		
		byte[] dataBytes = datos.getBytes();
		byte[] dataBytes_EBCDIC = NRCHelper.fromASCII_to_EBCDIC(dataBytes);
		byte[] keyBytes = Hex.decode(clave);
		
		String mac = NRCHelper.calcularMAC(dataBytes_EBCDIC, keyBytes);
		
		return finantialOrgdata + mac;
	}

}
