package p12e.exe.holdercert.test.host.engine;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;

import p12e.exe.holdercert.host.engine.HostCertificationEnginePerformerInterface;
import p12e.exe.holdercert.test.utils.HolderCertNRCGenerator;
import p12f.exe.holdercert.utils.HolderCertUtil;
import p12f.exe.pasarelapagos.objects.AccountConstraint;
import p12f.exe.pasarelapagos.objects.AditionalData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertConstants;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;
import p12f.exe.pasarelapagos.objects.HolderCertResponse;
import p12f.exe.pasarelapagos.objects.HolderCertResponse.UpdatedHolderCertData;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.config.FinantialOrgConfig;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;
import p12f.exe.pasarelapagos.utils.SecurityContextUtils;
import p12m.exe.pasarelapagos.services.config.P12MConfigAPI;
import p12m.exe.pasarelapagos.services.config.P12MConfigFactoryAPI;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;

/**
 * Realiza una validacin mltiple.
 * @author iolabaro
 *
 */
public class HostCertificationEnginePerformerImpl implements HostCertificationEnginePerformerInterface{
	
	HolderCertDataList data= null;
	ProtocolData procolData = null;
	
	/**
	 * Establecer los datos de entrada para validar.
	 * @param data
	 * @param protocolData
	 */
	public void setData(HolderCertDataList data , ProtocolData protocolData) {
		this.data =  data;
		this.procolData = protocolData;
	}
	
	/**
	 * Reaalizar la validacin de los datos de entrada.
	 * @return
	 * @throws Exception 
	 */
	public HolderCertCertifiedDataList  performCertification() throws Exception{
		R01FLog.to("p12et.holderCert").info("MultipleHolderCerPerformer.doCertification");
		HolderCertCertifiedDataList certifiedDataList = new HolderCertCertifiedDataList();
		R01FLog.to("p12et.holderCert").info(">> "+this.data.toXML());
		FinantialOrgConfig finantialOrgConfig = null;
		for (Iterator<HolderCertData> it =  this.data.dataList.iterator(); it.hasNext();){
			
			HolderCertData currentCertData = it.next();
			
			AditionalData aditionalData = (AditionalData)currentCertData.aditionalDataList.get("finantialOrgId");
			String oidEntidad = aditionalData.value;
			if (finantialOrgConfig == null) {
				P12MConfigAPI configApi = P12MConfigFactoryAPI.getConfigManagerAPI();
				SecurityContext cxt = SecurityContextUtils.getSecurityContext("p12et", SecurityContextUtils.SERVICE_CONFIG);
				finantialOrgConfig = FinantialOrgConfig.getObject(configApi.loadFinantialOrgConfigWithKeys(cxt, oidEntidad).resultado.returnValue);
			}
			//currentCertData.aditionalDataList.remove("finantialOrgId");
			
			HolderCertCertifiedData certifiedData = new HolderCertCertifiedData();
			
			certifiedData.holderCertData  = currentCertData;
			
			HolderCertResponse  response = new HolderCertResponse();
			response.finantialOrgCode = oidEntidad;
			
			R01FLog.to("p12et.holderCert").info(" Establecer el tipo de relacin >> -1 : ninguna ; 1 : Titular/cotitular ; 2: Autorizado, -2 : Titular/cotitular con restricciones");
			
			// Aleatorizar el resultado
			// TODO double aleatorio = Math.random();
			
			HolderCertData decryptedHolderCertData = HolderCertUtil.decrypt(currentCertData, finantialOrgConfig);
			//TODO
			double aleatorio = checkAccountInFile(decryptedHolderCertData.itemToCertNumber);
			
			R01FLog.to("p12et.holderCert").info("Aleatorio: "+aleatorio);
			if (aleatorio < 0.9) { // Certificacin vlida
				if (aleatorio < 0.1) {
					response.certCode = HolderCertConstants.CERTCODE_AUTHORIZED; // autorizado
				} else {
					if (aleatorio < 0.2) { // cambiar por 0.2
						response.certCode = HolderCertConstants.CERTCODE_VALID_ACCOUNT_MODIFIED; // titular/cotitular con cambio de oficina
						if (finantialOrgConfig == null) {
							P12MConfigAPI configApi = P12MConfigFactoryAPI.getConfigManagerAPI();
							SecurityContext cxt = SecurityContextUtils.getSecurityContext("p12et", SecurityContextUtils.SERVICE_CONFIG);
							finantialOrgConfig = FinantialOrgConfig.getObject(configApi.loadFinantialOrgConfigWithKeys(cxt, oidEntidad).resultado.returnValue);
						}
						//TODO HolderCertData decryptedHolderCertData = HolderCertUtil.decrypt(currentCertData, finantialOrgConfig);
						String newAccount = null;
						String newOffice = (new Double(Math.random())).toString().substring(3, 7);
						if (HolderCertData.ACCOUNT_NUMBER_FORMAT_CC.equals(decryptedHolderCertData.accountNumberFormat)) {
							newAccount = _generarCuentaCC ( decryptedHolderCertData.itemToCertNumber.substring(0, 4), 
															newOffice, 
															decryptedHolderCertData.itemToCertNumber.substring(10));
						} else {
							newAccount = _generarCuentaIBAN (decryptedHolderCertData.itemToCertNumber.substring(0, 2),
															 decryptedHolderCertData.itemToCertNumber.substring(4, 8), 
															 newOffice, 
															 decryptedHolderCertData.itemToCertNumber.substring(14));
						}
						R01FLog.to("p12et.holderCert").info(decryptedHolderCertData.itemToCertNumber+" >>> "+newAccount);
						// se crea un nuevo objeto para meter la cuenta modificada
						/*
						Map<String,AditionalHolderDataItem> aditionalHolderDataItemMap = new HashMap<String,AditionalHolderDataItem>();
						AditionalHolderDataItem ahdi = new AditionalHolderDataItem();
						ahdi.id = HolderCertConstants.ADITIONAL_ACCOUNT_DATA_CURRENT_HOLDER_DATA;
						decryptedHolderCertData.itemToCertNumber = newAccount;
						decryptedHolderCertData = HolderCertUtil.encrypt(decryptedHolderCertData, finantialOrgConfig);
						ahdi.value = decryptedHolderCertData.itemToCertNumber;
						aditionalHolderDataItemMap.put(ahdi.id, ahdi);
						response.aditionalHolderData = aditionalHolderDataItemMap;
						*/
						UpdatedHolderCertData updatedData = new UpdatedHolderCertData();
						updatedData.accountNumberFormat = certifiedData.holderCertData.accountNumberFormat;
						updatedData.type = certifiedData.holderCertData.type;
						updatedData.encType = certifiedData.holderCertData.encType;
						
						decryptedHolderCertData.itemToCertNumber = newAccount;
						decryptedHolderCertData = HolderCertUtil.encrypt(decryptedHolderCertData, finantialOrgConfig);
						updatedData.itemToCertNumber = decryptedHolderCertData.itemToCertNumber;
						
						response.updatedHolderCertData = updatedData;
						
					} else {
						response.certCode = HolderCertConstants.CERTCODE_VALID; // titular/cotitular
					}
					int aleatConstraint = (new Integer((new Double(aleatorio)).toString().substring(5,6))).intValue();
					if (aleatConstraint < 2) { // tiene restricciones
						AccountConstraint accountConstraint = new AccountConstraint();
						accountConstraint.id = HolderCertConstants.CONSTRAINT_LIST_DISALLOW_WITHDRAW;
						response.accountConstraintList = new HashMap<String,AccountConstraint>();
						response.accountConstraintList.put(accountConstraint.id, accountConstraint);
					}
				}
				String adminData = currentCertData.requestID;
				String finantialOrgData = oidEntidad + "000000000083739";
				String clave1 = "065E5143070E2D05";
				String clave2 = "0B070A060A0D0F00";
				
				R01FLog.to("p12et.holderCert").info(" Ejemplo de Clculo de NRC con los siguientes datos:\n [Ver clase : p12e.exe.holdercert.test.utils. HolderCertNRCGenerator !!]");
				R01FLog.to("p12et.holderCert").info(" @adminData:"+ adminData+ "\n");
				R01FLog.to("p12et.holderCert").info(" @finantialOrgData:"+ finantialOrgData+ "\n");
				R01FLog.to("p12et.holderCert").info(" @clave1:"+ clave1+ "\n");
				R01FLog.to("p12et.holderCert").info(" @clave1:"+ clave2+ "\n");
				
				String nrc = HolderCertNRCGenerator.generateNRC(adminData, finantialOrgData, clave1, clave2);
				
				R01FLog.to("p12et.holderCert").info("NRC generado: = " + nrc);
				R01FLog.to("p12et.holderCert").info("nrc length = " +  nrc.length());
				
				response.nrc = nrc;
			} else { // Certificacin no vlida
				response.certCode = HolderCertConstants.CERTCODE_INVALID;
			}
			response.timeStamp = Long.toString(System.currentTimeMillis());;
			
			certifiedData.holderCertResponse  = response;
			certifiedDataList.certCertifiedDataList.add(certifiedData);
		}
		certifiedDataList.itemCount = certifiedDataList.certCertifiedDataList.size();
		certifiedDataList.packageID = this.data.packageID;
		R01FLog.to("p12et.holderCert").info("paquete : " + certifiedDataList.packageID );
		return certifiedDataList;
	}
	
	private String _generarCuentaIBAN(String strPais, String strEntidad, String strSucursal, String strCuenta) {
		String nuevaCuenta = _generarCuentaCC(strEntidad, strSucursal, strCuenta);
		String paisStr = _getIBANletterToNumber(strPais.substring(0, 1)) + _getIBANletterToNumber(strPais.substring(1, 2));
		String cuentaStrAux = nuevaCuenta + paisStr + "00";
		int module97 = (new BigInteger(cuentaStrAux)).mod(new BigInteger("97")).intValue();
		int ibanDc = 98 - module97;
		String strIbanDc = StringUtils.fillLeft(ibanDc + "", 2, "0");
		return strPais + strIbanDc + nuevaCuenta;
	}
	private String _generarCuentaCC (String strEntidad, String strSucursal, String strCuenta) {
		int entidad = (new Integer(strEntidad)).intValue();
		int sucursal = (new Integer(strSucursal)).intValue();
		long numeroCuenta = (new Long(strCuenta)).longValue();
		int dc = _validarCC_1(entidad, sucursal, numeroCuenta);
		String newDC = StringUtils.fillLeft(dc + "", 2, "0");
		return strEntidad + strSucursal + newDC + strCuenta;
	}
	private int _validarCC_1(int entidad, int sucursal, long cuenta) {
		int primer = (entidad * 10000) + (sucursal * 1);
		int d = _dcCcc(primer);
		d = d * 10;
		d += _dcCcc(cuenta);
		return d;
	}
	private int _dcCcc(long i) {
		int[] pesos = { 6, 3, 7, 9, 10, 5, 8, 4, 2, 1 };
		int contador = 0;
		int s = 0;
		long d;
		while (i != 0) {
			d = i % 10;
			i = i / 10;
			s += d * pesos[contador];
			contador++;
		}
		int resultado = 11 - (s % 11);
		if (resultado == 10) {
			resultado = 1;
		} else if (resultado == 11) {
			resultado = 0;
		}
		return resultado;
	}
	private String _getIBANletterToNumber(String letra) {
		if (letra.equals("A")) { return "10"; }
		else if (letra.equals("B")) { return "11"; }
		else if (letra.equals("C")) { return "12"; }
		else if (letra.equals("D")) { return "13"; }
		else if (letra.equals("E")) { return "14"; }
		else if (letra.equals("F")) { return "15"; }
		else if (letra.equals("G")) { return "16"; }
		else if (letra.equals("H")) { return "17"; }
		else if (letra.equals("I")) { return "18"; }
		else if (letra.equals("J")) { return "19"; }
		else if (letra.equals("K")) { return "20"; }
		else if (letra.equals("L")) { return "21"; }
		else if (letra.equals("M")) { return "22"; }
		else if (letra.equals("N")) { return "23"; }
		else if (letra.equals("O")) { return "24"; }
		else if (letra.equals("P")) { return "25"; }
		else if (letra.equals("Q")) { return "26"; }
		else if (letra.equals("R")) { return "27"; }
		else if (letra.equals("S")) { return "28"; }
		else if (letra.equals("T")) { return "29"; }
		else if (letra.equals("U")) { return "30"; }
		else if (letra.equals("V")) { return "31"; }
		else if (letra.equals("W")) { return "32"; }
		else if (letra.equals("X")) { return "33"; }
		else if (letra.equals("Y")) { return "34"; }
		else if (letra.equals("Z")) { return "35"; }
		return "";
	}
	
	private double checkAccountInFile(final String account){
		
		double returnAleatorio = Math.random();
		
		if(account != null && !"".equals(account)){
			try {
				String rutaFichero = XMLProperties.getString("p12et", "urls/urlDefaultHoldercertAccountResponseFile");
				FileReader inputFile = new FileReader(rutaFichero);
				BufferedReader bufferReader = new BufferedReader(inputFile);
				String line;
				while ((line = bufferReader.readLine()) != null) {
					if(!"".equals(line)){
						String[] splittedLine = line.split("#");
						if(account.equals(splittedLine[0])){
							returnAleatorio = Double.parseDouble(splittedLine[1]);
							break;
						}
					}
				}
				//Close the buffer reader
				bufferReader.close();
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		return returnAleatorio;
	}
}
