package p12e.exe.holdercert.test.communications;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import p12e.exe.holdercert.communications.HolderCertHTTPPerformerAPI;
import p12f.exe.holdercert.utils.HolderCertDataListZipper;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertResponse;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.Url;
import p12m.exe.utils.HttpClientProxyUtils;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.net.HttpClient;

/**
 * Clase que ejecuta la peticin del estado de una pago sobre una entidad financiera.
 */
public class HolderCertHTTPPerformerImpl implements HolderCertHTTPPerformerAPI{
	
	/**
	 * Mtodo que pregunta como cliente a una entidad financiera por el estado de un pago
	 * identificado por su CSB.
	 * @param csb CSB del pago
	 * @param url URL del banco a la que hay que preguntar
	 * @return Estado del pago que se ha solicitado
	 */
	public void performHTTPHolderCertReturnResultAction(HolderCertCertifiedData holderCertData,ProtocolData protocolData){
		R01FLog.to("p12et.holderCert").info("Se ha llamado al metodo performHTTPHolderCertReturnResultAction() del HolderCertHTTPPerformer.");
		try {
			String urlToPost = ((Url) protocolData.urls.get("urlCallBack")).url;
			Map parametersToPost = new HashMap();
			parametersToPost.put("module","certGateway");
			parametersToPost.put("function","holderCertified");
			parametersToPost.put("holderCertCertifiedData",holderCertData.toXML());
			parametersToPost.put("protocolData",protocolData.toXML());
			HttpClient httpClient = new  HttpClient(urlToPost,parametersToPost);
			
			returnHolderCertResponse(httpClient,urlToPost);
		} catch (Exception e) {
			R01FLog.to("p12et.holderCert").info("No se ha recibido el estado de la entidad financiera.");
		
		}
	}
	
	
	/**
	 * Mtodo que pregunta como cliente a una entidad financiera por el estado de un pago
	 * identificado por su CSB.
	 * @param csb CSB del pago
	 * @param protoclData datos de protocolo
	 * @param url URL del banco a la que hay que preguntar
	 * @return Estado del pago que se ha solicitado
	 */
	public void performHTTPHolderCertReturnResultAction(HolderCertCertifiedDataList holderCertDataList, ProtocolData protocolData){
		R01FLog.to("p12et.holderCert").info("Se ha llamado al metodo performHTTPHolderCertReturnResultAction() del HolderCertHTTPPerformer.");
		try {
			byte[] bytes  = HolderCertDataListZipper.zip(holderCertDataList.toXML().getBytes());
			
			ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
			
			String urlToPost = ((Url) protocolData.urls.get("urlCallBack")).url;
			Map parametersToPost = new HashMap();
			parametersToPost.put("module","certGateway");
			parametersToPost.put("function","multipleHolderCertified");
			parametersToPost.put("protocolData",protocolData.toXML());
			parametersToPost.put("holderCertCertifiedDataList", bis);
			
			HttpClient httpClient = new  HttpClient(urlToPost,parametersToPost);
			httpClient.setContentType(HttpClient.MULTIPART_FORM_DATA_FILES_CONTENT_TYPE);
			
			returnHolderCertResponse(httpClient,urlToPost);
		} catch (Exception e) {
			R01FLog.to("p12et.holderCert").info("No se ha recibido el estado de la entidad financiera.");
			e.printStackTrace();
		}
	
	}
	
	
	/**
	 * Mtodo que pregunta como cliente a una entidad financiera por el estado de un pago
	 * identificado por su CSB.
	 * @param csb CSB del pago
	 * @param protoclData datos de protocolo
	 * @param url URL del banco a la que hay que preguntar
	 * @return Estado del pago que se ha solicitado
	 */
	public void performHTTPHolderCertReturnResultActionBatch(HolderCertCertifiedDataList holderCertDataList, ProtocolData protocolData){
		R01FLog.to("p12et.holderCert").info("Se ha llamado al metodo performHTTPHolderCertReturnResultActionBatch() del HolderCertHTTPPerformer.");
		try {
			byte[] bytes  = HolderCertDataListZipper.zip(holderCertDataList.toXML().getBytes());
			
			ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
			
			String urlToPost = ((Url) protocolData.urls.get("urlCallBack")).url;
			Map parametersToPost = new HashMap();
			parametersToPost.put("module","certGateway");
			parametersToPost.put("function","multipleHolderCertifiedBatch");
			parametersToPost.put("protocolData",protocolData.toXML());
			parametersToPost.put("holderCertCertifiedDataList", bis);	
			
			HttpClient httpClient = new  HttpClient(urlToPost,parametersToPost);
			httpClient.setContentType(HttpClient.MULTIPART_FORM_DATA_FILES_CONTENT_TYPE);
			
			returnHolderCertResponse(httpClient,urlToPost);
		} catch (Exception e) {
			R01FLog.to("p12et.holderCert").info("No se ha recibido el estado de la entidad financiera.");
			e.printStackTrace();
		}
	}
	
	
	/* ********************************************************************** */
	/* 							Metodos Privados 							  */
	/* ********************************************************************** */
	
	/**
	 * Mtodo que pregunta como cliente a una entidad financiera por el estado de un pago
	 * @param paymentId Identificador del pago
	 * @param url URL del banco a la que hay que preguntar
	 * @return Estado del pago que se ha solicitado
	 */
	private HolderCertResponse returnHolderCertResponse(HttpClient httpClient,String urlToPost){
		R01FLog.to("p12et.holderCert").info("Se ha llamado al metodo returnHolderCertResposne() del HolderCertHTTPPerformer : " + urlToPost);
		try {
			String urlToPostAccesible = HttpClientProxyUtils.getGatewayUrlAccesible(urlToPost);
			HttpClientProxyUtils.setProxy(httpClient, urlToPostAccesible);
			httpClient.sendPostHttpCall();
		}catch(IOException e){
			R01FLog.to("p12et.holderCert").info("No se ha recibido contestacion de la entidad financiera.");
			e.printStackTrace();
		}catch (Exception ex){
			ex.printStackTrace();
		}
		return null;
	}
	
}
