package p12e.exe.holdercert.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.holdercert.api.HolderCerFinantialAPI;
import p12e.exe.holdercert.host.engine.HostCertificationEnginePerformerInterface;
import p12f.exe.holdercert.utils.HolderCertDataListZipper;
import p12f.exe.holdercert.utils.HolderCertParamParser;
import p12f.exe.pasarelapagos.objects.AditionalData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;
import p12f.exe.pasarelapagos.objects.ProtocolData;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;

/**
 *  Ejemplo de implementacin sncrona de la validacin de datos. 
 */
public class EFHolderCertSynchronousServlet extends HttpServlet {
	
	HostCertificationEnginePerformerInterface _hostImplementationClass = null; 

	/**
	 * Constructor of the object.
	 */
	public EFHolderCertSynchronousServlet() {
		super();
	}
	
	public void init() throws ServletException {
		try {
			_hostImplementationClass  = (HostCertificationEnginePerformerInterface) Class.forName(XMLProperties.getProperty("p12et","hostPerformerImplementation/class")).newInstance();
		} catch (InstantiationException e) {
			e.printStackTrace();
			throw new ServletException(e);
		} catch (IllegalAccessException e) {
			e.printStackTrace();
			throw new ServletException(e);
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			throw new ServletException(e);
		}
	}
	
	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doExec(request, response);
	}
	
	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doExec(request, response);
	}
	
	/**
	 * Performing de las utilidades.
	 * @param request
	 * @param response
	 * @throws ServletException 
	 */
	private void doExec(HttpServletRequest request, HttpServletResponse response) throws ServletException {
		try {
			R01FLog.to("p12et.holderCert").info("[ EF HOLDER CERT SERVLET]");
			R01FLog.to("p12et.holderCert").info("=========================");
			HolderCertParamParser paramParser = new HolderCertParamParser ();
			paramParser.parse(request,response);
			try {
				if (paramParser.parameters.containsKey("sleep")) {
					try {
						long timeToSleep = (new Long((String)paramParser.parameters.get("sleep"))).longValue();
						if (paramParser.parameters.containsKey("random") && "true".equals((String)paramParser.parameters.get("random"))) {
							timeToSleep = (new Double(Math.random()*timeToSleep)).longValue();
						}
						R01FLog.to("p12et.holderCert").info("\n>>>> Inicio simulacin espera de "+timeToSleep+" milisegundos antes de responder\n");
						Thread.sleep(timeToSleep);
					} catch (Exception e) { }
				}
			} catch (Exception e) { }
			
			if (!isMultipartContent(request)){
				HolderCertData data = (HolderCertData)  HolderCertData.getObject((String)paramParser.getParam(HolderCertParamParser.HOLDERCERT_DATA));
				//ProtocolData protocolData = (ProtocolData) ProtocolData.getObject( (String) paramParser.getParam(HolderCertParamParser.PROTOCOL_DATA));
				String finantialOrgId = (String)paramParser.getParam(HolderCertParamParser.FINANTIALORGCODE);
				if (data.aditionalDataList==null) {
					data.aditionalDataList = new HashMap();
				}
				AditionalData aditonalData = new AditionalData();
				aditonalData.name = "finantialOrgId";
				aditonalData.value = finantialOrgId;
				data.aditionalDataList.put("finantialOrgId", aditonalData);
				
				HolderCerFinantialAPI holderCertAPI = new HolderCerFinantialAPI();	
				holderCertAPI.setFunction(HolderCerFinantialAPI.HOLDER_CERT_FUNCTION);
				holderCertAPI.addHolderCertDataItem(data);
				
				holderCertAPI.setHostCertificationEngine(this._hostImplementationClass);
			
				HolderCertCertifiedData certifiedResults = (HolderCertCertifiedData)holderCertAPI.doCertification().certCertifiedDataList.get(0);
			
				PrintWriter out = response.getWriter();
				String returnXML = certifiedResults.toXML();
				out.println(returnXML);
				out.flush();
				out.close();
			} else {
				InputStream  is = (InputStream)paramParser.getParam(HolderCertParamParser.HOLDERCERT_DATA_LIST);
				ProtocolData protocolData = (ProtocolData) ProtocolData.getObject((String)paramParser.getParam(HolderCertParamParser.PROTOCOL_DATA));
				String finantialOrgId = (String)paramParser.getParam(HolderCertParamParser.FINANTIALORGCODE);
				
				R01FLog.to("p12et.holderCert").info(" Convertir Stream a  HoldercertDatalist");
				
				HolderCertDataList list =  HolderCerFinantialAPI.convertStreamToHolderCertdataList(is, protocolData);
				
				HolderCerFinantialAPI holderCertAPI = new HolderCerFinantialAPI();	
				holderCertAPI.setFunction(HolderCerFinantialAPI.MULTIPLE_HOLDER_CERT_FUNCTION);
				
				for (Iterator it = list.dataList.iterator(); it.hasNext(); ){
					
					HolderCertData currentHolderCertdata = (HolderCertData) it.next();
					if (currentHolderCertdata.aditionalDataList==null) {
						currentHolderCertdata.aditionalDataList = new HashMap();
					}
					AditionalData aditonalData = new AditionalData();
					aditonalData.name = "finantialOrgId";
					aditonalData.value = finantialOrgId;
					currentHolderCertdata.aditionalDataList.put("finantialOrgId", aditonalData);
					holderCertAPI.addHolderCertDataItem(currentHolderCertdata);
					
				}
				
				holderCertAPI.setPackageID(list.packageID);;
				holderCertAPI.setHostCertificationEngine(this._hostImplementationClass);
				HolderCertCertifiedDataList certifiedResults = holderCertAPI.doCertification();
				
				byte[] bytes  = HolderCertDataListZipper.zip(certifiedResults.toXML().getBytes());
				response.setContentType("application/zip");
				
				response.getOutputStream().write(bytes);
			}
			
		} catch (Exception ex) {
			throw new ServletException(ex);
		}
		R01FLog.to("p12et.holderCert").info("=======  END  ==========");
	}
	
	public static final boolean isMultipartContent(HttpServletRequest request) {
		if (!"post".equals(request.getMethod().toLowerCase())) {
			return false;
		}
		String contentType = request.getContentType();
		if (contentType == null) {
			return false;
		}
		return contentType.toLowerCase().startsWith("multipart/");
	}
	
	public  HolderCertDataList convertTOHolderCertDataList(InputStream is) throws Exception{
		String xml = "";
		BufferedReader in = new BufferedReader(new InputStreamReader(is));
		String inputLine=null;
		while ((inputLine = in.readLine()) != null) xml += inputLine;
		in.close();	 
		HolderCertDataList holderCertDataList = HolderCertDataList.getObject(xml);
		return holderCertDataList;
	}
	
}