package p12e.exe.holdercert.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Executors;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.holdercert.api.HolderCerFinantialAPI;
import p12e.exe.holdercert.communications.HolderCertHTTPPerformerAPI;
import p12e.exe.holdercert.host.engine.HostCertificationEnginePerformerInterface;
import p12f.exe.holdercert.utils.HolderCertParamParser;
import p12f.exe.pasarelapagos.objects.AditionalData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;
import p12f.exe.pasarelapagos.objects.ProtocolData;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;

public class EFHolderCertAsynchronousEventBusServlet extends HttpServlet {
	
	private static final long serialVersionUID = -5528788359105096822L;

	/**
	 * Constructor of the object.
	 */
	public EFHolderCertAsynchronousEventBusServlet() {
		super();
	}
	
	public void init() throws ServletException {

	}
	
	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			_doExec(request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			_doExec(request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void _doExec(HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		HostCertificationEnginePerformerInterface _hostImplementationClass = (HostCertificationEnginePerformerInterface) Class.forName(XMLProperties.getProperty("p12et","hostPerformerImplementation/class")).newInstance();
		HolderCertHTTPPerformerAPI _httpPerformerImplementationClass = (HolderCertHTTPPerformerAPI) Class.forName(XMLProperties.getProperty("p12et","httpPerformerImplementation/class")).newInstance();
		
		// Creamos el bus asncrono
		AsyncEventBus eventBus = new AsyncEventBus("AsynchronousHolderCertEventBus", Executors.newCachedThreadPool());
		// Creamos el escuchador
		AsynchronousHolderCertEventListener listener = new AsynchronousHolderCertEventListener(_hostImplementationClass, _httpPerformerImplementationClass);
		// Registramos el escuchador en el bus
		eventBus.register(listener);
		
		HolderCertParamParser paramParser = new HolderCertParamParser ();
		paramParser.parse(request,response);
		
		boolean isMultipartContent = _isMultipartContent(request);
		if (isMultipartContent) { // validacin mltiple
			MultipleHolderCertEvent eventoMultiple = _getMultipleEvent(paramParser);
			// Enviamos el evento mltiple al bus
			eventBus.post(eventoMultiple);
			
		} else { // validacin simple
			SimpleHolderCertEvent eventoSimple = _getSimpleEvent(paramParser);
			// Enviamos el evento simple al bus
			eventBus.post(eventoSimple);
		}
		R01FLog.to("p12et.holderCert").info("[EFHolderCertAsynchronousServlet Finalizada llamada asncrona]");
	}
	
	public class AsynchronousHolderCertEventListener {
		
		HostCertificationEnginePerformerInterface _hostImplementationClass  = null;
		HolderCertHTTPPerformerAPI _httpPerformerImplementationClass = null;
		
		public AsynchronousHolderCertEventListener( HostCertificationEnginePerformerInterface _hostImplementationClass,
													HolderCertHTTPPerformerAPI _httpPerformerImplementationClass) {
			this._hostImplementationClass = _hostImplementationClass;
			this._httpPerformerImplementationClass = _httpPerformerImplementationClass;
		}
		
		/**
		 * Mtodo que procesa una validacin simple.
		 * @param eventoSimple
		 */
		@SuppressWarnings("unchecked")
		@Subscribe
		@AllowConcurrentEvents
		public void listenSimpleEvent(SimpleHolderCertEvent eventoSimple) {
			try {
				AditionalData datoAdicional = new AditionalData();
				datoAdicional.name = "finantialOrgId";
				datoAdicional.value = eventoSimple.finantialOrgId;
				//data.aditionalDataList.put("finantialOrgId", finantialOrgId);
				eventoSimple.data.aditionalDataList.put("finantialOrgId", datoAdicional);
				
				R01FLog.to("p12et.holderCert").info(">> Validacin Simple Asncrona");
				HolderCerFinantialAPI holderCertAPI = new HolderCerFinantialAPI();	
				
				R01FLog.to("p12et.holderCert").info("\n>> 1. Set Function");
				holderCertAPI.setFunction(HolderCerFinantialAPI.HOLDER_CERT_FUNCTION);
				
				R01FLog.to("p12et.holderCert").info("\n>> 2. Add HolderCertData to cert");
				holderCertAPI.addHolderCertDataItem(eventoSimple.data);
				
				R01FLog.to("p12et.holderCert").info("\n>> 3. Set host engine ");
				holderCertAPI.setHostCertificationEngine(this._hostImplementationClass);
				
				R01FLog.to("p12et.holderCert").info("\n>> 4. Do Certification ");
				HolderCertCertifiedData certData = (HolderCertCertifiedData)holderCertAPI.doCertification().certCertifiedDataList.get(0);
			
				R01FLog.to("p12et.holderCert").info("\n>> 5. Return result ");
				this._httpPerformerImplementationClass.performHTTPHolderCertReturnResultAction(certData, eventoSimple.protocolData);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		/**
		 * Mtodo que procesa una validacin mltiple.
		 * @param eventoMultiple
		 */
		@SuppressWarnings("unchecked")
		@Subscribe
		@AllowConcurrentEvents
		public void listenMultipleEvent(MultipleHolderCertEvent eventoMultiple) {
			try {
				HolderCerFinantialAPI holderCertAPI = new HolderCerFinantialAPI();	
				
				R01FLog.to("p12et.holderCert").info("\n>> 1. Set Function :");
				if (eventoMultiple.function.equalsIgnoreCase(HolderCertParamParser.HOLDERCERT_MULTIPLE_FUNCTION_RECEIVE)){
					R01FLog.to("p12et.holderCert").info("Multiple Holder Cert Function");
					holderCertAPI.setFunction(HolderCerFinantialAPI.MULTIPLE_HOLDER_CERT_FUNCTION);
				}else{
					R01FLog.to("p12et.holderCert").info("Multiple Holder Cert Batch Function");
					holderCertAPI.setFunction(HolderCerFinantialAPI.MULTIPLE_HOLDER_CERT_FUNCTION_BATCH);
				}	
				
				R01FLog.to("p12et.holderCert").info("\n>> 2. Add HolderCertData to cert");
				for (Iterator<HolderCertData> it = eventoMultiple.data.dataList.iterator(); it.hasNext(); ){
					HolderCertData currentHolderCertdata = it.next();
					if (currentHolderCertdata.aditionalDataList==null) {
						currentHolderCertdata.aditionalDataList = new HashMap<String,AditionalData>();
					}
					AditionalData datoAdicional = new AditionalData();
					datoAdicional.name = "finantialOrgId";
					datoAdicional.value = eventoMultiple.finantialOrgId;
					//currentHolderCertdata.aditionalDataList.put("finantialOrgId", finantialOrgId);
					currentHolderCertdata.aditionalDataList.put("finantialOrgId", datoAdicional);
					holderCertAPI.addHolderCertDataItem(currentHolderCertdata);
				}
				
				R01FLog.to("p12et.holderCert").info("\n>> 3. Set PackageID");
				holderCertAPI.setPackageID(eventoMultiple.data.packageID);;
				
				R01FLog.to("p12et.holderCert").info("\n>> 4. Set host engine ");
				holderCertAPI.setHostCertificationEngine(this._hostImplementationClass);
				
				R01FLog.to("p12et.holderCert").info("\n>> 5. Do Certification ");
				HolderCertCertifiedDataList certData = holderCertAPI.doCertification();
				
				R01FLog.to("p12et.holderCert").info("\n>> 6. Return result ");
				if (eventoMultiple.function.equalsIgnoreCase(HolderCertParamParser.HOLDERCERT_MULTIPLE_FUNCTION_RECEIVE)){	
					this._httpPerformerImplementationClass.performHTTPHolderCertReturnResultAction(certData, eventoMultiple.protocolData);
				}  else {
					this._httpPerformerImplementationClass.performHTTPHolderCertReturnResultActionBatch(certData, eventoMultiple.protocolData);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * Clase que engloba todos los datos de una validacin simple.
	 */
	public class SimpleHolderCertEvent {
		String function = null;
		String finantialOrgId = null;
		ProtocolData protocolData = null;
		HolderCertData data = null;
	}
	
	/**
	 * Clase que engloba todos los datos de una validacin mltiple.
	 */
	public class MultipleHolderCertEvent {
		String function = null;
		String finantialOrgId = null;
		ProtocolData protocolData = null;
		HolderCertDataList data = null;
	}
	
	
//////////////////////////////////////////////////////////////////////////////////////////////
// MTODOS PRIVADOS
//////////////////////////////////////////////////////////////////////////////////////////////
	
	private SimpleHolderCertEvent _getSimpleEvent(HolderCertParamParser _paramParser) throws Exception {
		SimpleHolderCertEvent event = new SimpleHolderCertEvent();
		event.function  =  (String)_paramParser.getParam(HolderCertParamParser.FUNCTION);
		event.finantialOrgId = (String)_paramParser.getParam(HolderCertParamParser.FINANTIALORGCODE);
		event.protocolData = (ProtocolData) ProtocolData.getObject( (String) _paramParser.getParam(HolderCertParamParser.PROTOCOL_DATA));
		event.data = (HolderCertData)  HolderCertData.getObject((String)_paramParser.getParam(HolderCertParamParser.HOLDERCERT_DATA));
		return event;
	}
	
	private MultipleHolderCertEvent _getMultipleEvent(HolderCertParamParser _paramParser) throws Exception {
		MultipleHolderCertEvent event = new MultipleHolderCertEvent();
		event.function  =  (String)_paramParser.getParam(HolderCertParamParser.FUNCTION);
		event.finantialOrgId = (String)_paramParser.getParam(HolderCertParamParser.FINANTIALORGCODE);
		event.protocolData = (ProtocolData) ProtocolData.getObject( (String) _paramParser.getParam(HolderCertParamParser.PROTOCOL_DATA));
		InputStream  is = (InputStream)_paramParser.getParam(HolderCertParamParser.HOLDERCERT_DATA_LIST);
		event.data = HolderCerFinantialAPI.convertStreamToHolderCertdataList(is, event.protocolData);;
		return event;
	}
	
	private static final boolean _isMultipartContent(HttpServletRequest request) {
		if (!"post".equals(request.getMethod().toLowerCase())) {
			return false;
		}
		String contentType = request.getContentType();
		if (contentType == null) {
			return false;
		}
		return contentType.toLowerCase().startsWith("multipart/");
	}
	
}
