package p12e.exe.pasarelapagos.test;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.base.FinantialOrgFunctions;
import p12e.exe.pasarelapagos.test.utils.EFClassSampleImpl;
import p12e.exe.pasarelapagos.test.utils.FinantialOrgFunctionsSampleImpl;
import p12f.exe.pasarelapagos.objects.Estado;

public class EFServlet extends HttpServlet {
	
	private static final long serialVersionUID = 5479179520930244172L;
	
	/**
	 * Constructor of the object.
	 */
	public EFServlet() {
		super();
	}
	
	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doExec(request, response);
	}
	
	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doExec(request, response);
	}
	
	/**
	 * The doExec method of the servlet. <br>
	 *
	 * This method is called from doGet and doPost methods.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doExec(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		// Se recogen los parmetros de la peticin
		String module = request.getParameter("module");
		String function = request.getParameter("function");
		String paymentDataXML = request.getParameter("paymentData");
		String presentationDataXML = request.getParameter("presentationData");
		String protocolDataXML = request.getParameter("protocolData");
		String csb = request.getParameter("csb");
		String nrc = request.getParameter("nrc");
		
		//R01FLog.to("p12et.EFServlet").info("module: " + module);
		//R01FLog.to("p12et.EFServlet").info("function: " + function);
		
		// Estas implementaciones son implementaciones de ejemplo que se proporcionan desde la Pasarela de Pagos del Gobierno Vasco
		// y que podrn ser modificadas a conveniencia.
		// Lo IMPORTANTE es llamar a las funciones del GatewayApi indicadas en cada mtodo de la interface EFClass.
		
		// Se instancia la clase que implementa la lgica propia de la Entidad Financiera.
		FinantialOrgFunctions fof = new FinantialOrgFunctionsSampleImpl();
		// Se instancia un objeto de la clase EFClass
		EFClass ef = new EFClassSampleImpl(fof);
		
		// Se comprueba que mtodo remoto se ha invocado
		if (function!=null && function.equals("setPaymentData")) {
			try{
				// Se llama al mtodo setPaymentData()
				ef.setPaymentData(paymentDataXML,
						presentationDataXML,
						protocolDataXML,
						request,
						response);
				// Se redirige al cliente a la pgina de login de la Entidad Financiera
				fof.doRedirectClient(request,response,"login.jsp",ef);
			} catch(Exception e) {
				e.printStackTrace();
			}
		} else {
			if (function!=null && function.equals("getPaymentStateDataByCSB")) {
			//	R01FLog.to("p12et.EFServlet").info("Se ha recibido la peticion del estado del pago con CSB: " + csb);
				//R01FLog.to("p12et.EFServlet").info("ProtocolData: " + protocolDataXML);
				
				try {
					// Respuesta en forma de XML
					String returnXML =  null;
					String sleep = request.getParameter("sleep");
					if (sleep != null && !"".equals(sleep)) {
						long sleepMilis = (new Long(sleep)).longValue();
						try { 
							//R01FLog.to("p12et.EFServlet").info("sleep: " + sleepMilis);
							Thread.sleep(sleepMilis);
						} catch (Exception e) { }
					}
					String finantialOrg = request.getParameter("finantialOrg");
					PrintWriter out = response.getWriter();
					Estado estado = ef.getPaymentStateDataByCSB(csb, protocolDataXML);
					if (Estado.PAGADO.equals(estado.codigo)) {
						if (finantialOrg!=null && !"".equals(finantialOrg)) {
							estado.entidad = finantialOrg;
							if (estado.nrc!=null && estado.nrc.length()>4) {
								estado.nrc = finantialOrg + estado.nrc.substring(4);
							}
						}
					}
					// Se enva de vuelta el XML del resultado de la operacin
					returnXML = estado.toXML();
					out.println(returnXML);
					out.flush();
					out.close();
				} catch (Exception e) {
					//R01FLog.to("p12et.EFServlet").info("Error en la operacin: NO se devuelve respuesta.");
					e.printStackTrace();
				}
			} else if(function!=null && function.equals("getPaymentStateDataByNRC")) {
				//R01FLog.to("p12et.EFServlet").info("Se ha recibido la peticion del estado del pago con NRC: " + nrc);
				//R01FLog.to("p12et.EFServlet").info("ProtocolData: " + protocolDataXML);
				try {
					// Respuesta en forma de XML
					String returnXML = null;
					String finantialOrg = request.getParameter("finantialOrg");
					PrintWriter out = response.getWriter();
					Estado estado = ef.getPaymentStateDataByNRC(nrc, protocolDataXML);
					if (Estado.PAGADO.equals(estado.codigo)) {
						if (finantialOrg!=null && !"".equals(finantialOrg)) {
							estado.entidad = finantialOrg;
							if (estado.nrc!=null && estado.nrc.length()>4) {
								estado.nrc = finantialOrg + estado.nrc.substring(4);
							}
						}
					}
					// Se enva de vuelta el XML del resultado de la operacin
					returnXML = estado.toXML();
					out.println(returnXML);
					out.flush();
					out.close();
				} catch (Exception e) {
					//R01FLog.to("p12et.EFServlet").info("Error en la operacin: NO se devuelve respuesta.");
					e.printStackTrace();
				}
			}
		}
	}
	
}
