package p12e.exe.pasarelapagos.mobile.test;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.base.FinantialOrgFunctions;
import p12e.exe.pasarelapagos.utils.FinantialOrgFunctionsImpl;

import com.ejie.r01f.log.R01FLog;

/**
 * 
 */
public class EFMobilePaymentServlet extends HttpServlet {

	private static final long serialVersionUID = 5479179520930244172L;

	/**
	 * Constructor of the object.
	 */
	public EFMobilePaymentServlet() {
		super();
	}

	/**
	 * The doGet method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doExec(request, response);
	}

	/**
	 * The doPost method of the servlet. <br>
	 *
	 * This method is called when a form has its tag value method equals to post.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doExec(request, response);
	}
	
	/**
	 * The doExec method of the servlet. <br>
	 *
	 * This method is called from doGet and doPost methods.
	 * 
	 * @param request the request send by the client to the server
	 * @param response the response send by the server to the client
	 * @throws ServletException if an error occurred
	 * @throws IOException if an error occurred
	 */
	@SuppressWarnings("unused")
	public void doExec(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		// Se recogen los parmetros de la peticin
		String module = request.getParameter("module");
		String function = request.getParameter("function");
		String paymentDataXML = request.getParameter("paymentData");
		String presentationDataXML = request.getParameter("presentationData");
		String protocolDataXML = request.getParameter("protocolData");
		String csb = request.getParameter("csb");
		String nrc = request.getParameter("nrc");
		
		R01FLog.to("p12et.EFServlet").info("module: " + module);
		R01FLog.to("p12et.EFServlet").info("function: " + function);
		
		// Se instancia la clase que implementa la lgica propia de la Entidad Financiera.
		FinantialOrgFunctions fof = new FinantialOrgFunctionsImpl();
		// Se instancia un objeto de la clase EFClass
		EFClass ef = new EFClass(fof);
		
		// Se comprueba que mtodo remoto se ha invocado
		if(function!=null && function.equals("setPaymentData")){
			try{
				// Se llama al mtodo setPaymentData()
				ef.setPaymentData(paymentDataXML,
						presentationDataXML,
						protocolDataXML,
						request,
						response);
				// Se redirige al cliente a la pgina de login de la Entidad Financiera
				fof.doRedirectClient(request,response,"loginMobile.jsp",ef);
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
}