<%@ page import="java.util.Iterator" %>
<%@ page import="com.ejie.r01f.xmlproperties.XMLProperties" %>
<%@ page import="com.ejie.r01f.xmlproperties.XMLLiterals" %>
<%@ page import="p12e.exe.pasarelapagos.base.EFClass" %>
<%@ page import="p12e.exe.pasarelapagos.html.helpers.mobile.ConfirmacionMobileComposer" %>
<%@ page import="p12f.exe.pasarelapagos.objects.Pago"%>
<%@ page import="p12f.exe.pasarelapagos.objects.PaymentData" %>
<%@ page import="p12f.exe.pasarelapagos.objects.PaymentResult"%>
<%@ page import="p12f.exe.pasarelapagos.objects.PaymentStateData"%>
<%@ page import="p12f.exe.pasarelapagos.objects.Estado"%>
<%@ page import="p12f.exe.pasarelapagos.objects.PresentationData" %>
<%@ page import="p12f.exe.pasarelapagos.objects.ProtocolData" %>
<%@ page import="p12f.exe.pasarelapagos.redirection.RequestParams" %>
<%@ page import="p12f.exe.pasarelapagos.redirection.SessionAttrs" %>
<%
	EFClass ef = (EFClass)session.getAttribute(SessionAttrs.EFCLASS);
	PaymentData paymentData = ef.getPaymentData();
	ProtocolData protocolData = ef.getProtocolData();
	PresentationData presentationData = ef.getPresentationData();
	PaymentResult paymentResult = ef.getPaymentResult();

	String carpetaContenidosPaymentGateway = XMLProperties.get("p12kt","contentFolder/paymentGatewayMobile");
	XMLLiterals xmlLiterals = new XMLLiterals("p12et",presentationData.idioma);
	
	boolean pagado = false;
	if(paymentResult != null && paymentResult.paymentStateDatas != null && !paymentResult.paymentStateDatas.isEmpty()){
		Iterator iter = paymentResult.paymentStateDatas.keySet().iterator();
		PaymentStateData paymentStateData = (PaymentStateData)paymentResult.paymentStateDatas.get(iter.next());
		
		if(paymentStateData != null && paymentStateData.estado != null && Estado.PAGADO.equals(paymentStateData.estado.codigo)){
			pagado = true;
		}
	}
%>
<!DOCTYPE html>
<html>
	<head>
		<title>Entidad Financiera Mobile</title>
		<meta name="viewport" content="width=device-width, height=device-height, initial-scale=1">
		<script src="<%=carpetaContenidosPaymentGateway%>jquery/jquery.min.js"></script>
		<!-- Latest compiled and minified CSS -->
		<link rel="stylesheet" href="<%=carpetaContenidosPaymentGateway%>jquery/jquery.mobile.icons-1.4.5.min.css">
		<!-- Optional theme -->
		<link rel="stylesheet" href="<%=carpetaContenidosPaymentGateway%>jquery/jquery.mobile-1.4.5.css">
		<link rel="stylesheet" href="<%=carpetaContenidosPaymentGateway%>jquery/jquery.mobile.structure-1.4.5.min.css">
		<link rel="stylesheet" href="<%=carpetaContenidosPaymentGateway%>css/pasarelaMobile.css">
		<!-- Latest compiled and minified JavaScript -->
		<script src="<%=carpetaContenidosPaymentGateway%>jquery/jquery.mobile-1.4.5.min.js"></script>
	</head>
	<body class="ui-mobile-viewport ui-overlay-a">
		<div data-role="page" tabindex="0" class="ui-page ui-page-active" style="background-color: #707070;">
			<div class="ui-header ui-bar-a" data-swatch="a" data-theme="a" data-form="ui-bar-a" data-role="header" role="banner" style="background-color: #fff; border-bottom:1px solid #DCDCDC;" data-position="fixed" data-id="paymentHeader" data-tap-toggle="false">
				<h1 tabindex="0" role="heading" aria-level="1" style="margin:0; margin-left:1em; padding-top:0.9em; padding-bottom:0em; float:left;">
					<img border="0" src="https://www6.euskadi.net/appcont/newPaymentGateway2/images/logoentidades/tpv1.gif" alt="Logo" style="height:1.5em" />
				</h1>
				<h1 tabindex="0" role="heading" aria-level="1" style="margin:0; margin-right:1em; padding-bottom:0em; float:right; padding-top:0.4em;">
					<img border="0" src="https://www6.euskadi.net/appcont/newPaymentGateway2/images/logo_es.jpg" alt="Logo" style="height:2.5em" />
				</h1>
			</div>
			<div class="ui-content ui-page-theme-w" data-form="ui-page-theme-w" data-theme="w" role="main" style="overflow:visible !important;background-color: #707070;">
				<div id="ui-bar-test" class="ui-bar ui-bar-b ui-corner-all" style="background-image: linear-gradient(#fff,#cbc7c8); margin-top:0.3em; margin-bottom:1em; padding:0.6em 0.8em; color: black; text-shadow: none;">
					<span><%= xmlLiterals.get("mobile/entidadFinanciera/resumen/cabecera") %></span>
				</div>
				<%=ConfirmacionMobileComposer.composeConfirmacionMobile(paymentData, paymentResult, presentationData)%>
				
				<%
				if(pagado){
					out.println("<div>");
						out.println("<a href='javascript:document.p12FormEmisionJustificante.submit();' data-transition='none' data-role='button' data-theme='c' data-form='ui-btn-up-c' class='ui-btn' style='margin-top:1em; background-image: linear-gradient(#fff,#cbc7c8);'>"+ xmlLiterals.get("mobile/entidadFinanciera/resultadoPago/verJustificante") + "</a>");
					out.println("</div>");
				}
				%>
				<!-- En este formulario se introducen los parametros necesarios para hacer la llamada al justificante -->
				<form action="emisionJustificanteMobile.jsp?R01HNoPortal=true" name="p12FormEmisionJustificante" id="p12FormEmisionJustificante" method="post">
					<input type="hidden" name="<%=RequestParams.PAYMENT_DATA%>" value="<%=paymentData.toXML()%>">
					<input type="hidden" name="<%=RequestParams.PRESENTATION_DATA%>" value="<%=presentationData.toXML()%>">
					<input type="hidden" name="<%=RequestParams.PROTOCOL_DATA%>" value="<%=protocolData.toXML()%>">
					<input type="hidden" name="<%=RequestParams.PAYMENT_RESULT%>" value="<%=paymentResult.toXML()%>">
				</form>
			</div>
		</div>
	</body>
</html>