/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.services.sipca;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12d.exe.pasarelapagos.services.sipca.P12DSIPCAManagerBaseAPI;
import p12d.exe.pasarelapagos.services.sipca.P12DSIPCAManagerBzd;
import p12f.exe.pasarelapagos.exceptions.PaymentRequestException;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;
import p12f.exe.pasarelapagos.paymentrequest.PaymentRequestData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.paymentrequest.ResolutionRequestData;

public class P12DSIPCAManager
extends P12DSIPCAManagerBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(P12DSIPCAManager.class);
    private SecurityContext securityContext = null;

    public P12DSIPCAManager(String sipcaBZD) {
        super(sipcaBZD);
    }

    public void init(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public OperationResult cancelPayment(SecurityContext ctx, PaymentRequestData paymentRequestData) {
        log.info(">>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DSIPCAManager.cancelPayment ::::::::::::");
        OperationResult operationResult = new OperationResult();
        P12DSIPCAManagerBzd sipcaManagerBzd = null;
        try {
            sipcaManagerBzd = (P12DSIPCAManagerBzd)this.getBzd();
            if (this.securityContext != null) {
                sipcaManagerBzd.doExecCancelPayment(this.securityContext, paymentRequestData);
            } else {
                sipcaManagerBzd.doExecCancelPayment(ctx, paymentRequestData);
            }
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult cancelPayment(SecurityContext ctx, String pagoID) {
        log.info(">>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DSIPCAManager.cancelPayment ::::::::::::");
        OperationResult operationResult = new OperationResult();
        P12DSIPCAManagerBzd sipcaManagerBzd = null;
        try {
            sipcaManagerBzd = (P12DSIPCAManagerBzd)this.getBzd();
            PeticionPago peticionPago = null;
            peticionPago = this.securityContext != null ? sipcaManagerBzd.doExecCancelPayment(this.securityContext, pagoID) : sipcaManagerBzd.doExecCancelPayment(ctx, pagoID);
            String resultXML = peticionPago.toXML();
            PeticionPago peticionPagoResult = (PeticionPago)PeticionPago.getObject((String)resultXML);
            if (peticionPagoResult.validacion != null && !peticionPagoResult.validacion.valido) {
                operationResult.resultado.resultadoOK = false;
                operationResult.resultado.returnValue = peticionPagoResult.validacion.mensaje;
            } else {
                operationResult.resultado.resultadoOK = true;
                operationResult.resultado.returnValue = resultXML;
            }
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult refundPayment(SecurityContext ctx, ResolutionRequestData refundRequestData) {
        log.info(">>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DSIPCAManager.refundPayment ::::::::::::");
        OperationResult operationResult = new OperationResult();
        P12DSIPCAManagerBzd sipcaManagerBzd = null;
        try {
            sipcaManagerBzd = (P12DSIPCAManagerBzd)this.getBzd();
            ResolutionRequestData result = this.securityContext != null ? sipcaManagerBzd.doExecRefundPayment(this.securityContext, refundRequestData) : sipcaManagerBzd.doExecRefundPayment(ctx, refundRequestData);
            String resultXML = result.toXML();
            ResolutionRequestData refundRequestDataResult = ResolutionRequestData.getObject((String)resultXML);
            if (refundRequestDataResult.validacion != null && !refundRequestDataResult.validacion.valido) {
                operationResult.resultado.resultadoOK = false;
                operationResult.resultado.returnValue = refundRequestDataResult.validacion.mensaje;
            } else {
                operationResult.resultado.resultadoOK = true;
                operationResult.resultado.returnValue = resultXML;
            }
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult enforcePayment(SecurityContext ctx, ResolutionRequestData enforceRequestData) {
        log.info(">>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DSIPCAManager.refundPayment ::::::::::::");
        OperationResult operationResult = new OperationResult();
        P12DSIPCAManagerBzd sipcaManagerBzd = null;
        try {
            sipcaManagerBzd = (P12DSIPCAManagerBzd)this.getBzd();
            ResolutionRequestData result = this.securityContext != null ? sipcaManagerBzd.doExecEnforcePayment(this.securityContext, enforceRequestData) : sipcaManagerBzd.doExecEnforcePayment(ctx, enforceRequestData);
            String resultXML = result.toXML();
            ResolutionRequestData enforceRequestDataResult = ResolutionRequestData.getObject((String)resultXML);
            if (enforceRequestDataResult.validacion != null && !enforceRequestDataResult.validacion.valido) {
                operationResult.resultado.resultadoOK = false;
                operationResult.resultado.returnValue = enforceRequestDataResult.validacion.mensaje;
            } else {
                operationResult.resultado.resultadoOK = true;
                operationResult.resultado.returnValue = resultXML;
            }
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }
}

