/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.services.search;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12d.exe.pasarelapagos.services.search.P12DSearchManagerBaseAPI;
import p12d.exe.pasarelapagos.services.search.P12DSearchManagerBzd;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.search.LiquidationsReportQuery;
import p12f.exe.search.LiquidationsReportSearchResultList;
import p12f.exe.search.PaymentQuery;
import p12f.exe.search.PaymentSearchResultList;

public class P12DSearchManagerAPI
extends P12DSearchManagerBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(P12DSearchManagerAPI.class);

    public P12DSearchManagerAPI(String sipcaBZD) {
        super(sipcaBZD);
    }

    public List search(PaymentQuery paymentQuery) {
        log.debug(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.search <<<<<<<<<<<<<<<<<");
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            return searchManagerBzd.doExecSearch(paymentQuery);
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List search(PaymentQuery paymentQuery, boolean HistoricDataRequired) {
        log.debug(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.search <<<<<<<<<<<<<<<<<");
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            return searchManagerBzd.doExecSearch(paymentQuery, HistoricDataRequired);
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OperationResult executeSearch(PaymentQuery paymentQuery, boolean historicDataRequired) {
        log.debug(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.executeSearch <<<<<<<<<<<<<<<<<");
        OperationResult result = new OperationResult();
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            PaymentSearchResultList resultList = searchManagerBzd.doExecuteSearch(paymentQuery, historicDataRequired);
            result.resultado.returnValue = resultList.toXML();
            result.resultado.resultadoOK = true;
            return result;
        }
        catch (BzdConfigException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        return result;
    }

    public OperationResult executeSearch(PaymentQuery paymentQuery) {
        log.debug(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.executeSearch <<<<<<<<<<<<<<<<<");
        OperationResult result = new OperationResult();
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            PaymentSearchResultList resultList = searchManagerBzd.doExecuteSearch(paymentQuery);
            result.resultado.returnValue = resultList.toXML();
            result.resultado.resultadoOK = true;
            return result;
        }
        catch (BzdConfigException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        return result;
    }

    public OperationResult executeSearchForLiquidationsReport(LiquidationsReportQuery paymentQuery) {
        log.debug(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.executeSearch <<<<<<<<<<<<<<<<<");
        OperationResult result = new OperationResult();
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            LiquidationsReportSearchResultList resultList = searchManagerBzd.doExecuteSearchForLiquidationsReport(paymentQuery);
            result.resultado.returnValue = resultList.toXML();
            result.resultado.resultadoOK = true;
            return result;
        }
        catch (BzdConfigException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        return result;
    }
}

