/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.services.paymentreceiptlistener;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12d.exe.pasarelapagos.services.paymentreceiptlistener.HttpPaymentReceiptEventListener;
import p12f.exe.pasarelapagos.objects.paymentreceipt.PaymentReceiptOperationResult;

public abstract class HttpPaymentReceiptEventListenerBase
extends HttpServlet
implements HttpPaymentReceiptEventListener {
    private static final Logger log = LoggerFactory.getLogger(HttpPaymentReceiptEventListenerBase.class);
    private static final long serialVersionUID = 583537168180674199L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._doExec(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._doExec(request, response);
    }

    private void _doExec(HttpServletRequest request, HttpServletResponse response) {
        try {
            String module = request.getParameter("module");
            String function = request.getParameter("function");
            if ("paymentGateway".equals(module) && "getPaymentReceipt".equals(function)) {
                PaymentReceiptOperationResult paymentReceiptOperationResult = PaymentReceiptOperationResult.getObject((String)request.getParameter("paymentReceiptResult"));
                if (paymentReceiptOperationResult.operationResultOK) {
                    log.info("[HttpPaymentReceiptEventListenerBase] Evento de carta de pago recibido OK : " + paymentReceiptOperationResult.paymentReceiptOperationOid + " (" + paymentReceiptOperationResult.operationResult + ") : " + paymentReceiptOperationResult.operationResultOIDs);
                    this.onGetPaymentReceipt(paymentReceiptOperationResult);
                } else {
                    log.info("[HttpPaymentReceiptEventListenerBase] Evento de carta de pago recibido NOK : " + paymentReceiptOperationResult.paymentReceiptOperationOid + " (" + paymentReceiptOperationResult.operationResult + ") : " + paymentReceiptOperationResult.operationResultOIDs + " : " + paymentReceiptOperationResult.operationResultAditionalInfo);
                    this.onGetPaymentReceiptError(paymentReceiptOperationResult);
                }
            } else {
                log.info("[HttpPaymentReceiptEventListenerBase] Se ha llamado al listener de generaci\u00f3n de cartas de pago sin los par\u00e1metros necesarios : " + module + " - " + function);
            }
        }
        catch (Exception ex) {
            log.info("[HttpPaymentReceiptEventListenerBase] Se ha producido un error en la llamada al listener de generaci\u00f3n de cartas de pago : " + ex.getMessage());
        }
    }

    @Override
    public void onGetPaymentReceipt(PaymentReceiptOperationResult paymentReceiptOperationResult) {
        log.info("############ EVENTO RECIBIDO : onGetPaymentReceipt : " + paymentReceiptOperationResult.paymentReceiptOperationOid + " ###############");
    }

    @Override
    public void onGetPaymentReceiptError(PaymentReceiptOperationResult paymentReceiptOperationResult) {
        log.info("############ EVENTO RECIBIDO : onGetPaymentReceiptError : " + paymentReceiptOperationResult.paymentReceiptOperationOid + " ###############");
    }
}

