/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.services.holdercert;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12d.exe.pasarelapagos.services.holdercert.P12DHolderCertManagerBaseAPI;
import p12d.exe.pasarelapagos.services.holdercert.P12DHolderCertManagerBzd;
import p12f.exe.pasarelapagos.objects.Base64Content;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.config.HolderCertEventConfig;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;

public class P12DHolderCertManagerAPI
extends P12DHolderCertManagerBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(P12DHolderCertManagerAPI.class);
    private SecurityContext securityContext = null;

    P12DHolderCertManagerAPI(String newOid) {
        super(newOid);
    }

    public void init(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public OperationResult holderCert(HolderCertData holderCertData, ProtocolData protocolData) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.holderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doHolderCert(holderCertData, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult holderCert(HolderCertData holderCertData, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.holderCert (eventos propios) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doHolderCert(holderCertData, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCert(HolderCertDataList holderCertData, ProtocolData protocolData) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCert(holderCertData, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCert(HolderCertDataList holderCertData, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCert (eventos propios) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCert(holderCertData, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCert(Base64Content holderCertDataListZipped, ProtocolData protocolData) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCertBatch (ZIP) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCert(holderCertDataListZipped, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCert(Base64Content holderCertDataListZipped, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCertBatch (ZIP) (eventos propios) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCert(holderCertDataListZipped, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }
}

