/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.services.files;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12d.exe.pasarelapagos.services.files.P12DFilesManagerBaseAPI;
import p12d.exe.pasarelapagos.services.files.P12DFilesManagerBzd;
import p12f.exe.pasarelapagos.exceptions.PaymentRequestException;
import p12f.exe.pasarelapagos.helpers.FileUploadHelper;
import p12f.exe.pasarelapagos.objects.Base64Content;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.pasarelapagos.objects.PaymentOFFLineGenerationMetadataList;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;

public class P12DFilesManagerAPI
extends P12DFilesManagerBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(P12DFilesManagerAPI.class);
    private SecurityContext securityContext = null;

    P12DFilesManagerAPI(String newOid) {
        super(newOid);
    }

    public void init(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public OperationResult uploadAndUnzipTemplate(SecurityContext ctx, HttpServletRequest request, String grupo) {
        return this.uploadAndUnzipTemplate(ctx, request, grupo, null, null);
    }

    public OperationResult uploadAndUnzipTemplate(SecurityContext ctx, Base64Content zippedTemplate, String grupo) {
        return this.uploadAndUnzipTemplate(ctx, zippedTemplate, grupo, null, null);
    }

    public OperationResult uploadAndUnzipTemplate(SecurityContext ctx, HttpServletRequest request, String grupo, String admin) {
        return this.uploadAndUnzipTemplate(ctx, request, grupo, admin, null);
    }

    public OperationResult uploadAndUnzipTemplate(SecurityContext ctx, Base64Content zippedTemplate, String grupo, String admin) {
        return this.uploadAndUnzipTemplate(ctx, zippedTemplate, grupo, admin, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult uploadAndUnzipTemplate(SecurityContext ctx, HttpServletRequest request, String grupo, String admin, String sufijo) {
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "uploadAndUnzipTemplate";
        FileUploadHelper fileUploadHelper = new FileUploadHelper();
        StringBuffer uploadedAndUnzippedFiles = new StringBuffer();
        StringBuffer processErrors = new StringBuffer();
        boolean processPartiallyCompleted = false;
        try {
            String tmpUnique = "" + System.currentTimeMillis();
            String[] uploadedFiles = fileUploadHelper.uploadRequestFiles("p12dt", "saveZippedTemplateToFileDigester", request, tmpUnique);
            for (int currentUploadedFile = 0; currentUploadedFile < uploadedFiles.length; ++currentUploadedFile) {
                Base64Content zippedTemplate = new Base64Content();
                File uploadedFile = new File(uploadedFiles[currentUploadedFile]);
                try {
                    zippedTemplate.content = FileUploadHelper.getContentInBase64((File)uploadedFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        FileUtils.delete((File)uploadedFile);
                        FileUtils.delete((File)new File(uploadedFile.getParent()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                zippedTemplate.fileName = uploadedFile.getName();
                OperationResult uploadedFileOperationResult = this.uploadAndUnzipTemplate(ctx, zippedTemplate, grupo, admin, sufijo);
                if (uploadedFileOperationResult.resultado.resultadoOK) {
                    processPartiallyCompleted = true;
                    if (uploadedAndUnzippedFiles.length() > 0) {
                        uploadedAndUnzippedFiles.append(";");
                    }
                    uploadedAndUnzippedFiles.append(uploadedFileOperationResult.resultado.returnValue);
                    continue;
                }
                if (processErrors.length() > 0) {
                    processErrors.append(";");
                }
                processErrors.append(zippedTemplate.fileName);
                processErrors.append("-->Error: ");
                processErrors.append(uploadedFileOperationResult.resultado.returnValue);
            }
            if (processPartiallyCompleted) {
                operationResult.resultado.resultadoOK = true;
                operationResult.resultado.returnValue = uploadedAndUnzippedFiles.toString();
            } else {
                operationResult.resultado.resultadoOK = false;
                operationResult.resultado.returnValue = processErrors.toString();
            }
        }
        catch (ServletException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult uploadAndUnzipTemplate(SecurityContext ctx, Base64Content zippedTemplate, String grupo, String admin, String sufijo) {
        log.info(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.uploadAndUnzipTemplate ::::::::::::");
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "uploadAndUnzipTemplate";
        try {
            boolean success;
            String unzippedTemplateFileName = null;
            P12DFilesManagerBzd filesManagerBzd = (P12DFilesManagerBzd)this.getBzd();
            if (grupo != null && !"".equals(grupo)) {
                if (!"default".equals(grupo)) {
                    unzippedTemplateFileName = admin != null && !"".equals(admin) ? (sufijo != null && !"".equals(sufijo) ? filesManagerBzd.doExecUploadAndUnzipTemplate(ctx, zippedTemplate, grupo, admin, sufijo) : filesManagerBzd.doExecUploadAndUnzipTemplate(ctx, zippedTemplate, grupo, admin)) : filesManagerBzd.doExecUploadAndUnzipTemplate(ctx, zippedTemplate, grupo);
                } else {
                    operationResult.resultado.resultadoOK = false;
                    operationResult.resultado.returnValue = "No se puede sobreescribir la plantilla por defecto: grupo default";
                }
            } else {
                operationResult.resultado.resultadoOK = false;
                operationResult.resultado.returnValue = "Se debe indicar m\u00ednimo el grupo al que pertenece la plantilla";
            }
            operationResult.resultado.resultadoOK = success = unzippedTemplateFileName != null && unzippedTemplateFileName.trim().equalsIgnoreCase(zippedTemplate.fileName);
            operationResult.resultado.returnValue = zippedTemplate.fileName;
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (NullPointerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult recoverTemplateBackUp(SecurityContext ctx, String grupo, String admin, String sufijo, boolean makeBackUp) {
        log.info(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.recoverTemplateBackUp ::::::::::::");
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "recoverTemplateBackUp";
        try {
            String fileName = "";
            P12DFilesManagerBzd filesManagerBzd = (P12DFilesManagerBzd)this.getBzd();
            fileName = filesManagerBzd.doExecRecoverTemplateBackUp(ctx, grupo, admin, sufijo, makeBackUp);
            if (fileName == null) {
                operationResult.resultado.resultadoOK = false;
                operationResult.resultado.returnValue = "No existe back-up a recuperar";
            } else {
                operationResult.resultado.resultadoOK = true;
                operationResult.resultado.returnValue = fileName;
            }
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (NullPointerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult createZipTemplate(SecurityContext ctx, String grupo, String admin, String sufijo) {
        log.info(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.downloadTemplate ::::::::::::");
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "downloadTemplate";
        try {
            String fileName = "";
            P12DFilesManagerBzd filesManagerBzd = (P12DFilesManagerBzd)this.getBzd();
            fileName = filesManagerBzd.doExecCreateZipTemplate(ctx, grupo, admin, sufijo);
            if (fileName == null) {
                operationResult.resultado.resultadoOK = false;
                operationResult.resultado.returnValue = "No existe plantilla asociada";
            } else {
                operationResult.resultado.resultadoOK = true;
                operationResult.resultado.returnValue = fileName;
            }
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (NullPointerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult getPaymentOFFLineGenerationMetadataInfoList(SecurityContext ctx, String[] adminOid) {
        log.info(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.getPaymentOFFLineGenerationMetadataInfoList ::::::::::::");
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "getPaymentOFFLineGenerationMetadataInfoList";
        try {
            boolean success;
            PaymentOFFLineGenerationMetadataList listResult = new PaymentOFFLineGenerationMetadataList();
            P12DFilesManagerBzd filesManagerBzd = (P12DFilesManagerBzd)this.getBzd();
            listResult = filesManagerBzd.doExecGetPaymentOFFLineGenerationMetadataInfoList(ctx, adminOid);
            operationResult.resultado.resultadoOK = success = listResult != null;
            operationResult.resultado.returnValue = listResult.toXML();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (NullPointerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult deleteFile(SecurityContext ctx, String adminOid, String idToken) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.doExecDeleteFile <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "deleteFile";
        try {
            boolean success;
            P12DFilesManagerBzd filesManagerBzd = (P12DFilesManagerBzd)this.getBzd();
            String resultado = filesManagerBzd.doExecDeleteFile(ctx, adminOid, idToken);
            operationResult.resultado.resultadoOK = success = new Boolean(resultado).booleanValue();
            operationResult.resultado.returnValue = resultado;
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult deleteFile(SecurityContext ctx, String adminOid, String idToken, String fileName) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.doExecDeleteFile <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "deleteFile";
        try {
            boolean success;
            P12DFilesManagerBzd filesManagerBzd = (P12DFilesManagerBzd)this.getBzd();
            String resultado = filesManagerBzd.doExecDeleteFile(ctx, adminOid, idToken, fileName);
            operationResult.resultado.resultadoOK = success = new Boolean(resultado).booleanValue();
            operationResult.resultado.returnValue = resultado;
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult createFile(SecurityContext ctx, String adminOid, String idToken) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.doExecCreateFile <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "createFile";
        try {
            boolean success;
            P12DFilesManagerBzd filesManagerBzd = (P12DFilesManagerBzd)this.getBzd();
            String resultado = filesManagerBzd.doExecCreateFile(ctx, adminOid, idToken);
            operationResult.resultado.resultadoOK = success = new Boolean(resultado).booleanValue();
            operationResult.resultado.returnValue = resultado;
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult createFile(SecurityContext ctx, String adminOid, String idToken, String fileName) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.doExecCreateFile <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "createFile";
        try {
            boolean success;
            P12DFilesManagerBzd filesManagerBzd = (P12DFilesManagerBzd)this.getBzd();
            String resultado = filesManagerBzd.doExecCreateFile(ctx, adminOid, idToken, fileName);
            operationResult.resultado.resultadoOK = success = new Boolean(resultado).booleanValue();
            operationResult.resultado.returnValue = resultado;
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }
}

