/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.services;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12d.exe.pasarelapagos.services.P12DPaymentManagerBaseAPI;
import p12d.exe.pasarelapagos.services.P12DPaymentManagerBzd;
import p12f.exe.pasarelapagos.exceptions.PaymentRequestException;
import p12f.exe.pasarelapagos.helpers.SenderHelper;
import p12f.exe.pasarelapagos.objects.AccountData;
import p12f.exe.pasarelapagos.objects.NRCValidationResponse;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.pasarelapagos.objects.PaymentData;
import p12f.exe.pasarelapagos.objects.PaymentStateData;
import p12f.exe.pasarelapagos.objects.PresentationData;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.SignedAuth;
import p12f.exe.pasarelapagos.objects.Url;
import p12f.exe.pasarelapagos.objects.paymentreceipt.PaymentReceiptOperationResult;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;
import p12f.exe.pasarelapagos.paymentrequest.PaymentGatewayData;
import p12f.exe.pasarelapagos.paymentrequest.PaymentRequestData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.transformer.ObjectTransformer;
import p12f.exe.pasarelapagos.transformer.ObjectTransformerException;

public class P12DPaymentManagerAPI
extends P12DPaymentManagerBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(P12DPaymentManagerAPI.class);
    private SecurityContext securityContext = null;

    P12DPaymentManagerAPI(String newOid) {
        super(newOid);
    }

    public void init(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public OperationResult initializePayment(PaymentRequestData paymentRequest) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.initializePayment <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentRequestData paymentRequestInitialized = this.securityContext != null ? paymentManagerBzd.doExecInitializePayment(this.securityContext, paymentRequest) : paymentManagerBzd.doExecInitializePayment(paymentRequest);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentRequestInitialized.toXML();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult initializePayment(PaymentGatewayData gatewayData) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.initializePayment <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentGatewayData paymentRequestInitialized = this.securityContext != null ? paymentManagerBzd.doExecInitializePayment(this.securityContext, gatewayData) : paymentManagerBzd.doExecInitializePayment(gatewayData);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentRequestInitialized.toXML();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            e.printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult initializeAndRegisterPayment(PaymentRequestData paymentRequest, ProtocolData protocolData, PresentationData presentationData) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.initializeAndRegisterPayment <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentData paymentInitialized = this.securityContext != null ? paymentManagerBzd.doExecInitializeAndRegisterPayment(this.securityContext, paymentRequest, protocolData, presentationData) : paymentManagerBzd.doExecInitializeAndRegisterPayment(paymentRequest, protocolData, presentationData);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentInitialized.toXML();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getLocalizedMessage();
        }
        return operationResult;
    }

    public OperationResult initializeAndRegisterPaymentForPOS(PaymentRequestData paymentRequest, ProtocolData protocolData, PresentationData presentationData) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.initializeAndRegisterPaymentForPOS <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentData paymentInitialized = this.securityContext != null ? paymentManagerBzd.doExecInitializeAndRegisterPaymentForPOS(this.securityContext, paymentRequest, protocolData, presentationData) : paymentManagerBzd.doExecInitializeAndRegisterPaymentForPOS(paymentRequest, protocolData, presentationData);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentInitialized.toXML();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getLocalizedMessage();
        }
        return operationResult;
    }

    public OperationResult initializeAndPay(PaymentRequestData paymentRequest, ProtocolData protocolData, AccountData accountData, SignedAuth signedAuth, PresentationData presentationData) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.initializeAndPay <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentData paymentInitialized = this.securityContext != null ? paymentManagerBzd.doExecInitializeAndPay(this.securityContext, paymentRequest, protocolData, accountData, signedAuth, presentationData) : paymentManagerBzd.doExecInitializeAndPay(paymentRequest, protocolData, accountData, signedAuth, presentationData);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentInitialized.toXML();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult getPaymentStateDataByNRC(String nrc) throws PaymentRequestException {
        log.info(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.getPaymentStateDataByNRC ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentStateData paymentStateData = this.securityContext != null ? paymentManagerBzd.doExecGetPaymentStateDataByNRC(nrc) : paymentManagerBzd.doExecGetPaymentStateDataByNRC(nrc);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentStateData.toXML();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (NullPointerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult getPaymentStateDataByCSB(String csb) throws PaymentRequestException {
        log.info(" >>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.getPaymentStateDataByCSB ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            PaymentStateData paymentStateData = this.securityContext != null ? paymentManagerBzd.doExecGetPaymentStateDataByCSB(this.securityContext, csb) : paymentManagerBzd.doExecGetPaymentStateDataByCSB(csb);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = paymentStateData.toXML();
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (NullPointerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult isValidNRC(PeticionPago peticionPago, String nrc) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.checkNRC <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
            NRCValidationResponse checkNRCResult = new NRCValidationResponse();
            checkNRCResult = this.securityContext != null ? paymentManagerBzd.doExecIsValidNRC(this.securityContext, peticionPago, nrc) : paymentManagerBzd.doExecIsValidNRC(peticionPago, nrc);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = checkNRCResult.toXML();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult postPaymentCareChartList(String oids, String idioma, HttpServletRequest request, HttpServletResponse response) {
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "sendUsingPost";
        PrintWriter out = null;
        try {
            response.setHeader("expires", "0");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            out = response.getWriter();
            String paymentGatewayURI = XMLProperties.get((String)"p12dt", (String)"urls/urlPasarela");
            String code = SenderHelper.getHTMLJustificantePostCodeByOids((String)oids, (String)idioma, (String)paymentGatewayURI);
            out.println(code);
            out.flush();
            operationResult.resultado.resultadoOK = true;
        }
        catch (IOException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return operationResult;
    }

    public OperationResult sendUsingPost(PaymentGatewayData gatewayData, HttpServletRequest request, HttpServletResponse response) {
        return this.sendUsingPost(XMLProperties.get((String)"p12dt", (String)"urls/urlPasarela"), gatewayData, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult sendUsingPost(String url, PaymentGatewayData gatewayData, HttpServletRequest request, HttpServletResponse response) {
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "sendUsingPost";
        PrintWriter out = null;
        try {
            response.setHeader("expires", "0");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            out = response.getWriter();
            String paymentGatewayURI = url;
            String code = SenderHelper.getHTMLPostCode((PaymentGatewayData)gatewayData, (String)paymentGatewayURI);
            out.println(code);
            out.flush();
            operationResult.resultado.resultadoOK = true;
        }
        catch (IOException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return operationResult;
    }

    public OperationResult sendUsingGet(PaymentGatewayData gatewayData, HttpServletRequest request, HttpServletResponse response) {
        OperationResult operationResult = new OperationResult();
        operationResult.operationData.function = "sendByGet";
        try {
            String gatewayVersion = null;
            if (XMLProperties.getPropertyNode((String)"p12dt", (String)"urls/@gatewayVersion") != null) {
                gatewayVersion = XMLProperties.getPropertyNode((String)"p12dt", (String)"urls/@gatewayVersion").getNodeValue();
            }
            if (gatewayVersion != null && gatewayVersion.equalsIgnoreCase("1")) {
                String url = XMLProperties.get((String)"p12dt", (String)"urls/urlPasarela");
                String oidVersion2 = (String)gatewayData.paymentRequestData.peticionesPago.keySet().iterator().next();
                String oidVersion1 = new ObjectTransformer().getOldOIDFormat(oidVersion2);
                url = url + "?module=ia&pagoID=" + oidVersion1;
                response.sendRedirect(url);
            } else {
                String oids = "";
                Iterator it = gatewayData.paymentRequestData.peticionesPago.keySet().iterator();
                while (it.hasNext()) {
                    oids = oids + (String)it.next() + ",";
                }
                String url = XMLProperties.get((String)"p12dt", (String)"urls/urlPasarela");
                url = url + "?module=IU";
                url = url + "&p12iOidsPago=" + oids;
                url = url + "&p12iPresentationRequestData=" + gatewayData.presentationData.toXML();
                url = url + "&p12iProtocolData=" + gatewayData.protocolData.toXML();
                response.sendRedirect(url);
            }
            operationResult.resultado.resultadoOK = true;
        }
        catch (IOException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        catch (ObjectTransformerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult getPaymentReceipt(SecurityContext scx, List<String> paymentOids) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.getPaymentReceipt <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            if (paymentOids == null || paymentOids.size() == 0) {
                operationResult.resultado.resultadoOK = false;
                operationResult.resultado.returnValue = "paymentOids parameter is NULL";
            } else {
                P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
                PaymentReceiptOperationResult result = paymentManagerBzd.doExecGetPaymentReceipt(scx, this._getOidsAsString(paymentOids));
                if (result == null || "".equals(result)) {
                    operationResult.resultado.resultadoOK = false;
                } else {
                    operationResult.resultado.resultadoOK = true;
                    operationResult.resultado.returnValue = result.toXML();
                }
            }
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    public OperationResult getPaymentReceipt(SecurityContext scx, Url urlCallBack, List<String> paymentOids) {
        log.info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DPaymentManagerAPI.getPaymentReceipt <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            if (paymentOids == null || paymentOids.size() == 0) {
                operationResult.resultado.resultadoOK = false;
                operationResult.resultado.returnValue = "paymentOids parameter is NULL";
            } else {
                P12DPaymentManagerBzd paymentManagerBzd = (P12DPaymentManagerBzd)this.getBzd();
                String requestOid = paymentManagerBzd.doExecGetPaymentReceipt(scx, urlCallBack, this._getOidsAsString(paymentOids));
                operationResult.resultado.resultadoOK = requestOid != null && !"".equals(requestOid);
                operationResult.resultado.returnValue = requestOid;
            }
        }
        catch (PaymentRequestException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getMessage();
        }
        return operationResult;
    }

    private String _getOidsAsString(List<String> oids) {
        StringBuilder sb = new StringBuilder();
        for (String s : oids) {
            sb.append(",");
            sb.append(s);
        }
        return sb.substring(1);
    }
}

