/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.holdercerteventlistener;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import p12d.exe.pasarelapagos.holdercerteventlistener.HttpHolderCertEventListener;
import p12f.exe.holdercert.utils.HolderCertParamParser;
import p12f.exe.holdercert.utils.errors.HolderCertInternalError;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;

public abstract class HttpHolderCertEventListenerBase
extends HttpServlet
implements HttpHolderCertEventListener {
    private static final long serialVersionUID = 1393555402690461498L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doExec(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doExec(request, response);
    }

    private void doExec(HttpServletRequest request, HttpServletResponse response) {
        try {
            HolderCertParamParser paramParser = new HolderCertParamParser();
            paramParser.parse(request, response, false);
            String funcion = (String)paramParser.getParam("function");
            boolean isZipped = HttpHolderCertEventListenerBase._isMultipartContent(request);
            if ("holderCertInitialized".equals(funcion)) {
                HolderCertData holderCertData = HolderCertData.getObject((String)((String)paramParser.parameters.get("holderCertData")));
                this.onInitializeHolderCert(holderCertData);
            } else if ("multipleHolderCertInitialized".equals(funcion)) {
                if (isZipped) {
                    ByteArrayInputStream holderCertDataListStream = new ByteArrayInputStream((byte[])paramParser.parameters.get("holderCertDataList"));
                    this.onInitializeMultipleHolderCert(holderCertDataListStream);
                } else {
                    HolderCertDataList holderCertDataList = HolderCertDataList.getObject((String)((String)paramParser.parameters.get("holderCertDataList")));
                    this.onInitializeMultipleHolderCert(holderCertDataList);
                }
            } else if ("multipleHolderCertInitializedBatch".equals(funcion)) {
                if (isZipped) {
                    ByteArrayInputStream holderCertDataListStream = new ByteArrayInputStream((byte[])paramParser.parameters.get("holderCertDataList"));
                    this.onInitializeMultipleHolderCertBatch(holderCertDataListStream);
                } else {
                    HolderCertDataList holderCertDataList = HolderCertDataList.getObject((String)((String)paramParser.parameters.get("holderCertDataList")));
                    this.onInitializeMultipleHolderCertBatch(holderCertDataList);
                }
            } else if ("holderSentToCert".equals(funcion)) {
                String finantialOrg = (String)paramParser.parameters.get("finantialORGCode");
                HolderCertData holderCertData = HolderCertData.getObject((String)((String)paramParser.parameters.get("holderCertData")));
                this.onSendHolderCertToFinantialORG(finantialOrg, holderCertData);
            } else if ("multipleHolderSentToCert".equals(funcion)) {
                String finantialOrg = (String)paramParser.parameters.get("finantialORGCode");
                if (isZipped) {
                    ByteArrayInputStream holderCertDataListStream = new ByteArrayInputStream((byte[])paramParser.parameters.get("holderCertDataList"));
                    this.onSendMultipelHolderCertToFinantialORG(finantialOrg, holderCertDataListStream);
                } else {
                    HolderCertDataList holderCertDataList = HolderCertDataList.getObject((String)((String)paramParser.parameters.get("holderCertDataList")));
                    this.onSendMultipelHolderCertToFinantialORG(finantialOrg, holderCertDataList);
                }
            } else if ("multipleHolderSentToCertBatch".equals(funcion)) {
                String finantialOrg = (String)paramParser.parameters.get("finantialORGCode");
                if (isZipped) {
                    ByteArrayInputStream holderCertDataListStream = new ByteArrayInputStream((byte[])paramParser.parameters.get("holderCertDataList"));
                    this.onSendMultipelHolderCertToFinantialORGBatch(finantialOrg, holderCertDataListStream);
                } else {
                    HolderCertDataList holderCertDataList = HolderCertDataList.getObject((String)((String)paramParser.parameters.get("holderCertDataList")));
                    this.onSendMultipelHolderCertToFinantialORGBatch(finantialOrg, holderCertDataList);
                }
            } else if ("holderCertified".equals(funcion)) {
                HolderCertCertifiedData holderCertCertifiedData = HolderCertCertifiedData.getObject((String)((String)paramParser.parameters.get("holderCertCertifiedData")));
                this.onSetHolderCertResult(holderCertCertifiedData);
            } else if ("multipleHolderPartialCertified".equals(funcion)) {
                if (isZipped) {
                    ByteArrayInputStream holderCertCertifiedDataListStream = new ByteArrayInputStream((byte[])paramParser.parameters.get("holderCertCertifiedDataList"));
                    this.onSetMultipleHolderCertPartialResult(holderCertCertifiedDataListStream);
                } else {
                    HolderCertCertifiedDataList holderCertCertifiedDataList = HolderCertCertifiedDataList.getObject((String)((String)paramParser.parameters.get("holderCertCertifiedDataList")));
                    this.onSetMultipleHolderCertPartialResult(holderCertCertifiedDataList);
                }
            } else if ("multipleHolderPartialCertifiedBatch".equals(funcion)) {
                if (isZipped) {
                    ByteArrayInputStream holderCertCertifiedDataListStream = new ByteArrayInputStream((byte[])paramParser.parameters.get("holderCertCertifiedDataList"));
                    this.onSetMultipleHolderCertPartialResultBatch(holderCertCertifiedDataListStream);
                } else {
                    HolderCertCertifiedDataList holderCertCertifiedDataList = HolderCertCertifiedDataList.getObject((String)((String)paramParser.parameters.get("holderCertCertifiedDataList")));
                    this.onSetMultipleHolderCertPartialResultBatch(holderCertCertifiedDataList);
                }
            } else if ("multipleHolderCertified".equals(funcion)) {
                if (isZipped) {
                    ByteArrayInputStream holderCertCertifiedDataListStream = new ByteArrayInputStream((byte[])paramParser.parameters.get("holderCertCertifiedDataList"));
                    this.onSetMultipleHolderCertResult(holderCertCertifiedDataListStream);
                } else {
                    HolderCertCertifiedDataList holderCertCertifiedDataList = HolderCertCertifiedDataList.getObject((String)((String)paramParser.parameters.get("holderCertCertifiedDataList")));
                    this.onSetMultipleHolderCertResult(holderCertCertifiedDataList);
                }
            } else if ("multipleHolderCertifiedBatch".equals(funcion)) {
                if (isZipped) {
                    ByteArrayInputStream holderCertCertifiedDataListStream = new ByteArrayInputStream((byte[])paramParser.parameters.get("holderCertCertifiedDataList"));
                    this.onSetMultipleHolderCertResultBatch(holderCertCertifiedDataListStream);
                } else {
                    HolderCertCertifiedDataList holderCertCertifiedDataList = HolderCertCertifiedDataList.getObject((String)((String)paramParser.parameters.get("holderCertCertifiedDataList")));
                    this.onSetMultipleHolderCertResultBatch(holderCertCertifiedDataList);
                }
            } else if ("holderCertInternalError".equals(funcion)) {
                HolderCertInternalError holderCertInternalError = HolderCertInternalError.getObject((String)((String)paramParser.parameters.get("holderCertInternalError")));
                this.onError(holderCertInternalError);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onInitializeHolderCert(HolderCertData holderCertData) {
    }

    @Override
    public void onInitializeMultipleHolderCert(HolderCertDataList holderCertDataList) {
    }

    @Override
    public void onInitializeMultipleHolderCert(InputStream holderCertDataListZipped) {
    }

    @Override
    public void onInitializeMultipleHolderCertBatch(HolderCertDataList holderCertDataList) {
    }

    @Override
    public void onInitializeMultipleHolderCertBatch(InputStream holderCertDataListZipped) {
    }

    @Override
    public void onSendHolderCertToFinantialORG(String finantialOrg, HolderCertData holderCertData) {
    }

    @Override
    public void onSendMultipelHolderCertToFinantialORG(String finantialOrg, HolderCertDataList holderCertDataList) {
    }

    @Override
    public void onSendMultipelHolderCertToFinantialORG(String finantialOrg, InputStream holderCertDataListZipped) {
    }

    @Override
    public void onSendMultipelHolderCertToFinantialORGBatch(String finantialOrg, HolderCertDataList holderCertDataList) {
    }

    @Override
    public void onSendMultipelHolderCertToFinantialORGBatch(String finantialOrg, InputStream holderCertDataListZipped) {
    }

    @Override
    public void onSetHolderCertResult(HolderCertCertifiedData holderCertCertifiedData) {
    }

    @Override
    public void onSetMultipleHolderCertResult(HolderCertCertifiedDataList holderCertCertifiedDataList) {
    }

    @Override
    public void onSetMultipleHolderCertResult(InputStream holderCertCertifiedDataListZipped) {
    }

    @Override
    public void onSetMultipleHolderCertResultBatch(HolderCertCertifiedDataList holderCertCertifiedDataList) {
    }

    @Override
    public void onSetMultipleHolderCertResultBatch(InputStream holderCertCertifiedDataListZipped) {
    }

    @Override
    public void onSetMultipleHolderCertPartialResult(HolderCertCertifiedDataList holderCertCertifiedDataList) {
    }

    @Override
    public void onSetMultipleHolderCertPartialResult(InputStream holderCertCertifiedDataListZipped) {
    }

    @Override
    public void onSetMultipleHolderCertPartialResultBatch(HolderCertCertifiedDataList holderCertCertifiedDataList) {
    }

    @Override
    public void onSetMultipleHolderCertPartialResultBatch(InputStream holderCertCertifiedDataListZipped) {
    }

    @Override
    public void onError(HolderCertInternalError error) {
    }

    private static final boolean _isMultipartContent(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }
}

