/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.services.search;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.util.List;
import p12d.exe.pasarelapagos.services.search.P12DSearchManagerBaseAPI;
import p12d.exe.pasarelapagos.services.search.P12DSearchManagerBzd;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.search.PaymentQuery;
import p12f.exe.search.PaymentSearchResultList;

public class P12DSearchManagerAPI
extends P12DSearchManagerBaseAPI {
    public P12DSearchManagerAPI(String sipcaBZD) {
        super(sipcaBZD);
    }

    public List search(PaymentQuery paymentQuery) {
        R01FLog.to((String)"p12dt.searchAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.search <<<<<<<<<<<<<<<<<");
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            return searchManagerBzd.doExecSearch(paymentQuery);
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List search(PaymentQuery paymentQuery, boolean HistoricDataRequired) {
        R01FLog.to((String)"p12dt.searchAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.search <<<<<<<<<<<<<<<<<");
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            return searchManagerBzd.doExecSearch(paymentQuery, HistoricDataRequired);
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OperationResult executeSearch(PaymentQuery paymentQuery, boolean historicDataRequired) {
        R01FLog.to((String)"p12dt.searchAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.executeSearch <<<<<<<<<<<<<<<<<");
        OperationResult result = new OperationResult();
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            PaymentSearchResultList resultList = searchManagerBzd.doExecuteSearch(paymentQuery, historicDataRequired);
            result.resultado.returnValue = resultList.toXML();
            result.resultado.resultadoOK = true;
            return result;
        }
        catch (BzdConfigException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        return result;
    }

    public OperationResult executeSearch(PaymentQuery paymentQuery) {
        R01FLog.to((String)"p12dt.searchAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.executeSearch <<<<<<<<<<<<<<<<<");
        OperationResult result = new OperationResult();
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            PaymentSearchResultList resultList = searchManagerBzd.doExecuteSearch(paymentQuery);
            result.resultado.returnValue = resultList.toXML();
            result.resultado.resultadoOK = true;
            return result;
        }
        catch (BzdConfigException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            result.resultado.resultadoOK = false;
            result.resultado.returnValue = e.getDetailedMessage();
        }
        return result;
    }

    public OperationResult getPaymentRequest(String paymentId) {
        R01FLog.to((String)"p12dt.searchAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DSearchManagerAPI.getPaymentRequest <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DSearchManagerBzd searchManagerBzd = (P12DSearchManagerBzd)this.getBzd();
            PeticionPago peticionPago = searchManagerBzd.doExecGetPaymentRequest(paymentId);
            if (peticionPago == null) {
                R01FLog.to((String)"p12dt.searchAPI").finest(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DSearchManagerAPI.getPaymentRequest :: El Proceso de Consulta ha sido correcto, pero no existe ningun Pago de csb:" + paymentId);
            }
            operationResult.resultado.returnValue = peticionPago == null ? null : peticionPago.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (XOMarshallerException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }
}

