/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.services.holdercert;

import com.ejie.r01f.businessdelegate.BzdConfigException;
import com.ejie.r01f.log.R01FLog;
import java.util.List;
import p12d.exe.pasarelapagos.services.holdercert.P12DHolderCertManagerBaseAPI;
import p12d.exe.pasarelapagos.services.holdercert.P12DHolderCertManagerBzd;
import p12f.exe.holdercert.objects.config.query.BaseHolderCertQueryResult;
import p12f.exe.pasarelapagos.objects.Base64Content;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedData;
import p12f.exe.pasarelapagos.objects.HolderCertCertifiedDataList;
import p12f.exe.pasarelapagos.objects.HolderCertData;
import p12f.exe.pasarelapagos.objects.HolderCertDataList;
import p12f.exe.pasarelapagos.objects.OperationResult;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.config.HolderCertEventConfig;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;

public class P12DHolderCertManagerAPI
extends P12DHolderCertManagerBaseAPI {
    private SecurityContext securityContext = null;

    P12DHolderCertManagerAPI(String newOid) {
        super(newOid);
    }

    public void init(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public OperationResult holderCert(HolderCertData holderCertData, ProtocolData protocolData) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.holderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doHolderCert(holderCertData, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult holderCert(HolderCertData holderCertData, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.holderCert (eventos propios) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doHolderCert(holderCertData, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCert(HolderCertDataList holderCertData, ProtocolData protocolData) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCert(holderCertData, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCert(HolderCertDataList holderCertData, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCert (eventos propios) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCert(holderCertData, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCert(Base64Content holderCertDataListZipped, ProtocolData protocolData) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCertBatch (ZIP) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCert(holderCertDataListZipped, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCert(Base64Content holderCertDataListZipped, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCertBatch (ZIP) (eventos propios) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCert(holderCertDataListZipped, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCertBatch(HolderCertDataList holderCertData, ProtocolData protocolData) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCertBatch <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCertBatch(holderCertData, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCertBatch(HolderCertDataList holderCertData, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCertBatch (eventos propios) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCertBatch(holderCertData, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCertBatch(Base64Content holderCertDataListZipped, ProtocolData protocolData) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCertBatch (ZIP) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCertBatch(holderCertDataListZipped, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult multipleHolderCertBatch(Base64Content holderCertDataListZipped, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.multipleHolderCertBatch (ZIP) (eventos propios) <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doMultipleHolderCertBatch(holderCertDataListZipped, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult initializeHolderCert(HolderCertData holderCertData, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.initializeHolderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            HolderCertData holderCertResponse = holderCertManagerBzd.doInitializeHolderCert(holderCertData, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = holderCertResponse.toXML();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult initializeMultipleHolderCert(HolderCertDataList holderCertData, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.initializeMultipleHolderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            HolderCertDataList holderCertResponse = holderCertManagerBzd.doInitializeMultipleHolderCert(holderCertData, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = holderCertResponse.toXML();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult initializeMultipleHolderCertBatch(HolderCertDataList holderCertData, ProtocolData protocolData, HolderCertEventConfig eventBitMap) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.initializeMultipleHolderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            HolderCertDataList holderCertResponse = holderCertManagerBzd.doInitializeMultipleHolderCertBatch(holderCertData, protocolData, eventBitMap);
            operationResult.resultado.resultadoOK = true;
            operationResult.resultado.returnValue = holderCertResponse.toXML();
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult setHolderCertResult(HolderCertCertifiedData holderCertData, ProtocolData protocolData) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.setHolderCertResult <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doSetHolderCertResult(holderCertData, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult setMultipleHolderCertResult(HolderCertCertifiedDataList holderCertData, ProtocolData protocolData) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.setMultipleHolderCertResult <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doSetMultipleHolderCert(holderCertData, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult setMultipleHolderCertResultBatch(HolderCertCertifiedDataList holderCertData, ProtocolData protocolData) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.setMultipleHolderCertResultBatch <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doSetMultipleHolderCertBatch(holderCertData, protocolData);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult sendHolderCertToFinantialORGEvent(HolderCertData holderCertData, ProtocolData protocolData, String finantialORG) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.sendHolderCertToFinantialORG (Simple) :" + finantialORG);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doSendHolderCertToFinantialORG(holderCertData, protocolData, finantialORG);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult sendHolderCertToFinantialORGEvent(HolderCertDataList holderCertData, ProtocolData protocolData, String finantialORG) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.sendHolderCertToFinantialORG (Multiple): " + finantialORG);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doSendHolderCertToFinantialORG(holderCertData, protocolData, finantialORG);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult sendHolderCertToFinantialORGEventBatch(HolderCertDataList holderCertData, ProtocolData protocolData, String finantialORG) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.sendHolderCertToFinantialORG (Multiple): " + finantialORG);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doSendHolderCertToFinantialORGBatch(holderCertData, protocolData, finantialORG);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult generateNewReferenceForHolderCertTypeConfig(String adminOid, String holderCertType) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DHolderCertManagerAPI.generateNewReferenceForPaymentTypeConfig ::::::::::::");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            String reference = this.securityContext != null ? holderCertManagerBzd.doGenerateNewReferenceForHolderCertTypeConfig(this.securityContext, adminOid, holderCertType) : holderCertManagerBzd.doGenerateNewReferenceForPaymentTypeConfig(adminOid, holderCertType);
            if (reference == null) {
                R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(" >>>>>>>>>>>>>>>>>>>>>  CLIENT : P12DHolderCertManagerAPI.getPaymentRequestByNRC :: El Proceso de Generac\u00f3n ha fallado");
            }
            operationResult.resultado.returnValue = reference == null ? null : reference;
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            e.printStackTrace();
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        return operationResult;
    }

    public OperationResult getPendingHolderCertsByAllFinantialORG() {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingHolderCertsByAllFinantialORG (Simple): ");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingHolderCertsByAllFinantialORG();
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingHolderCertsByFinantialORG(List finantialORGs) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingHolderCertsByFinantialORG (Simple) ");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingHolderCertsByFinantialORG(finantialORGs);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingMultipleHolderCertsByAllFinantialORG() {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingMultipleHolderCertsByAllFinantialORG (Multiple)");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingMultipleHolderCertsByAllFinantialORG();
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingMultipleHolderCertsByFinantialORG(List finantialORGs) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingMultipleHolderCertsByFinantialORG (Multiple) ");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingMultipleHolderCertsByFinantialORG(finantialORGs);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingHolderCertsByAllAdmin() {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingHolderCertsByAllAdmin");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingHolderCertsByAllAdmin();
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingHolderCertsByAdmin(List admins) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingHolderCertsByAdmin ");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingHolderCertsByAdmin(admins);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingMultipleHolderCertsByAllAdmin() {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingMultipleHolderCertsByAllAdmin");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingMultipleHolderCertsByAllAdmin();
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingMultipleHolderCertsByAdmin(List admins) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingMultipleHolderCertsByAdmin ");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingMultipleHolderCertsByAdmin(admins);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingMultipleHolderCertsGroupByAllAdmin() {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingMultipleHolderCertsGroupByAllAdmin");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingMultipleHolderCertsGroupByAllAdmin();
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingMultipleHolderCertsGroupByAdmin(List admins) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingMultipleHolderCertsGroupByAdmin ");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingMultipleHolderCertsGroupByAdmin(admins);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingHolderCertsByHolderCertAdminAndType(String admin, String tipo) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingHolderCertsByHolderCertAdminAndType : " + admin + " - " + tipo);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingHolderCertsByHolderCertAdminAndType(admin, tipo);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingMultipleHolderCertsByHolderCertAdminAndType(String admin, String tipo) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingMultipleHolderCertsByHolderCertAdminAndType : " + admin + " - " + tipo);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingMultipleHolderCertsByHolderCertAdminAndType(admin, tipo);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingSimpleHolderCertByTimestamp(long timeToCheck, long timeToForward) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingSimpleHolderCertByTimestamp: " + timeToCheck + " - " + timeToForward);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingSimpleHolderCertByTimestamp(timeToCheck, timeToForward);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingMultipleHolderCertByTimestamp(long timeToCheck, long timeToForward) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingMultipleHolderCertByTimestamp: " + timeToCheck + " - " + timeToForward);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingMultipleHolderCertByTimestamp(timeToCheck, timeToForward);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getPendingMultipleBatchHolderCertByTimestamp(long timeToCheck, long timeToForward) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getPendingMultipleHolderCertByTimestamp: " + timeToCheck + " - " + timeToForward);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetPendingMultipleBatchHolderCertByTimestamp(timeToCheck, timeToForward);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult deleteHolderCertByRequestId(String requestId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.deleteHolderCertByRequestId: " + requestId);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doDeleteHolderCertByRequestId(requestId);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult deleteMultipleHolderCertByPackageId(String packageId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.deleteMultipleHolderCertByPackageId: " + packageId);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doDeleteMultipleHolderCertByPackageId(packageId);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getMultipleHolderCertByPackageId(String packageId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getMultipleHolderCertByPackageId : " + packageId);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResults = holderCertManagerBzd.doGetMultipleHolderCertByPackageId(packageId);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getMultipleHolderCertAditionalData(String packageId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getMultipleHolderCertAditionalData : " + packageId);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            HolderCertDataList queryResults = holderCertManagerBzd.doGetMultipleHolderCertAditionalData(packageId);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getMultipleHolderCertProtocolData(String packageId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").info(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.getMultipleHolderCertProtocolData : " + packageId);
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            ProtocolData queryResults = holderCertManagerBzd.doGetMultipleHolderCertProtocolData(packageId);
            operationResult.resultado.returnValue = queryResults.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult forwardSimpleHolderCert(String holderCertId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.forwardSimpleHolderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doForwardSimpleHolderCert(holderCertId);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult forwardMultipleHolderCert(String packageId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.forwardMultipleHolderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doForwardMultipleHolderCert(packageId);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult forwardMultipleHolderCert(String packageId, String finantialOrgId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.forwardMultipleHolderCert <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            holderCertManagerBzd.doForwardMultipleHolderCert(packageId, finantialOrgId);
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getHolderCertInfo(String holderCertId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.doGetHolderCertInfo <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResult = holderCertManagerBzd.doGetHolderCertInfo(holderCertId);
            operationResult.resultado.returnValue = queryResult.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }

    public OperationResult getMultipleHolderCertInfo(String packageId, String finantialOrgId) {
        R01FLog.to((String)"p12dt.clientHolderCertAPI").finest(">>>>>>>>>>>>>>>>>>>>> CLIENT : P12DHolderCertManagerAPI.doGetMultipleHolderCertInfo <<<<<<<<<<<<<<<<<");
        OperationResult operationResult = new OperationResult();
        try {
            P12DHolderCertManagerBzd holderCertManagerBzd = (P12DHolderCertManagerBzd)this.getBzd();
            BaseHolderCertQueryResult queryResult = holderCertManagerBzd.doGetMultipleHolderCertInfo(packageId, finantialOrgId);
            operationResult.resultado.returnValue = queryResult.toXML();
            operationResult.resultado.resultadoOK = true;
        }
        catch (BzdConfigException e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.getDetailedMessage();
        }
        catch (Exception e) {
            operationResult.resultado.resultadoOK = false;
            operationResult.resultado.returnValue = e.toString();
        }
        return operationResult;
    }
}

