/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.pasarelapagos.communications;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.rpcdispatcher.RPCCall;
import com.ejie.r01f.rpcdispatcher.RPCFunction;
import com.ejie.r01f.rpcdispatcher.RPCParameter;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.MarshallerArrayContainer;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import p12d.exe.pasarelapagos.communications.GatewayConnectorInterface;

public class RPCPaymentGatewayProxyHandler
implements InvocationHandler {
    private static boolean DEBUG = true;
    public static boolean hasBeenInitailized = false;
    private String rpcServletURL = null;
    private String rpcModule = null;
    private String xoMapFile = null;
    private String gatewayConectorClass = null;

    public RPCPaymentGatewayProxyHandler() {
    }

    public RPCPaymentGatewayProxyHandler(String newRPCServletURL, String newRPCModule, String newXOMapFile) {
        if (newRPCModule != null || newRPCModule != null) {
            this.rpcServletURL = newRPCServletURL;
            this.rpcModule = newRPCModule;
            this.xoMapFile = newXOMapFile;
        } else {
            R01FLog.to((String)"p12dt.proxyHandler").severe("Es necesario especificar la url del servlet RPC y el modulo que implementa el interfaz BZD!!!");
        }
    }

    private void _initialize() {
        String activeBZD = XMLProperties.getPropertyNode((String)"p12dt", (String)"businessDelegatesConfig/@active").getNodeValue();
        this.rpcServletURL = XMLProperties.get((String)"p12dt", (String)("businessDelegatesConfig/businessDelegate[@oid='" + activeBZD + "']/bzdRemote/rpcServlet"));
        this.rpcModule = XMLProperties.get((String)"p12dt", (String)("businessDelegatesConfig/businessDelegate[@oid='" + activeBZD + "']/bzdRemote/module"));
        this.xoMapFile = XMLProperties.get((String)"p12dt", (String)("businessDelegatesConfig/businessDelegate[@oid='" + activeBZD + "']/bzdRemote/xoMapFile"));
        this.gatewayConectorClass = XMLProperties.get((String)"p12dt", (String)("businessDelegatesConfig/businessDelegate[@oid='" + activeBZD + "']/bzdRemote/gatewayConnector/className"));
        hasBeenInitailized = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this._initialize();
        if (DEBUG) {
            R01FLog.to((String)"p12dt.proxyHandler").info("Invocando el metodo (" + method + ") en modulo " + this.rpcModule + " del RPCServlet " + this.rpcServletURL);
        }
        RPCCall rpcCall = new RPCCall(this.rpcModule);
        RPCFunction function = new RPCFunction(method.getName());
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].getClass().equals(String.class)) {
                    function.putParameter(new RPCParameter("param" + i, "String", args[i].toString()));
                    continue;
                }
                if (args[i].getClass().equals(Integer.class)) {
                    function.putParameter(new RPCParameter("param" + i, "int", args[i].toString()));
                    continue;
                }
                if (args[i].getClass().equals(Long.class)) {
                    function.putParameter(new RPCParameter("param" + i, "long", args[i].toString()));
                    continue;
                }
                if (args[i].getClass().equals(Double.class)) {
                    function.putParameter(new RPCParameter("param" + i, "double", args[i].toString()));
                    continue;
                }
                if (args[i].getClass().equals(Float.class)) {
                    function.putParameter(new RPCParameter("param" + i, "float", args[i].toString()));
                    continue;
                }
                if (args[i].getClass().equals(Boolean.class)) {
                    function.putParameter(new RPCParameter("param" + i, "Boolean", args[i].toString()));
                    continue;
                }
                if (args[i].getClass().equals(java.util.Date.class) || args[i].getClass().equals(Date.class)) {
                    function.putParameter(new RPCParameter("param" + i, "Date", DateUtils.getDateFormated((java.util.Date)((java.util.Date)args[i]), (String)"dd/MM/yyyy-hh:mm:ss:SSS")));
                    continue;
                }
                if (args[i].getClass().isArray()) {
                    try {
                        if (DEBUG) {
                            R01FLog.to((String)"p12dt.proxyHandler").fine("El parametro es de tipo array... se encapsula el array en un objeto MarshallerArrayContainer y se pasa a XML utilizando el fichero de mapeo " + this.xoMapFile);
                        }
                        MarshallerArrayContainer arrayContainer = new MarshallerArrayContainer((Object[])args[i]);
                        String xml = XOManager.getXML((String)this.xoMapFile, (Object)arrayContainer);
                        function.putParameter(new RPCParameter("param" + i, "XML", xml));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                if (DEBUG) {
                    R01FLog.to((String)"p12dt.proxyHandler").fine("El parametro es de tipo complejo... se convierte a XML utilizando el fichero de mapeo " + this.xoMapFile);
                }
                String xml = XOManager.getXML((String)this.xoMapFile, (Object)args[i]);
                function.putParameter(new RPCParameter("param" + i, "XML", xml));
            }
        }
        rpcCall.addFunction(function);
        if (DEBUG) {
            R01FLog.to((String)"p12dt.proxyHandler").info("\n\nHaciendo llamada al servlet RPC Remoto " + this.rpcServletURL + "\r\n" + rpcCall.toXML());
        }
        GatewayConnectorInterface gatewayConnector = (GatewayConnectorInterface)Class.forName(this.gatewayConectorClass).newInstance();
        String resultXML = null;
        try {
            InputStream is = gatewayConnector.send(this.rpcServletURL, rpcCall.toXML());
            resultXML = StringUtils.loadFromStream((InputStream)is);
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            throw tr;
        }
        if (method.getReturnType().equals(Void.class)) {
            return null;
        }
        if (method.getReturnType().equals(Void.class) || method.getReturnType().equals(String.class) || method.getReturnType().equals(Integer.class) || method.getReturnType().equals(Long.class) || method.getReturnType().equals(Double.class) || method.getReturnType().equals(Float.class) || method.getReturnType().equals(Boolean.class) || method.getReturnType().equals(java.util.Date.class) || method.getReturnType().equals(Date.class)) {
            // empty if block
        }
        String returnValue = null;
        IncommingCallResult callResult = null;
        try {
            if (!resultXML.startsWith("<?xml version='1.0' encoding='ISO-8859-1'?>")) {
                resultXML = "<?xml version='1.0' encoding='ISO-8859-1'?>" + resultXML;
            }
            callResult = new IncommingCallResult(new ByteArrayInputStream(resultXML.getBytes()));
            if (DEBUG) {
                R01FLog.to((String)"p12dt.proxyHandler").info("Respuesta recibida del RPCServlet:\r\n" + callResult.composeDebugInfo());
            }
        }
        catch (SAXException saxEx) {
            saxEx.printStackTrace(System.out);
            R01FLog.to((String)"p12dt.proxyHandler").warning("No se ha podido parsear el XML de respuesta del servlet RPC. Se devuelve null!!!");
            return null;
        }
        if (callResult.resultTypeCode == 16) {
            if (callResult.resultType != null) {
                Object ex = null;
                try {
                    ex = ReflectionUtils.getObjectInstance((String)callResult.resultType, (Class[])new Class[]{String.class}, (Object[])new Object[]{callResult.resultValue != null ? callResult.resultValue.toString() : "R01F: Unknown Exception"}, (boolean)true);
                    throw (Throwable)ex;
                }
                catch (ReflectionException refEx) {
                    refEx.printStackTrace(System.out);
                    R01FLog.to((String)"p12dt.proxyHandler").warning("No se ha podido instanciar la excepcion de tipo '" + callResult.resultType + "'. Se lanza una excepcion normal!!!");
                    throw new Exception(returnValue != null ? returnValue.toString() : "R01F: Unknown Exception");
                }
            }
            R01FLog.to((String)"p12dt.proxyHandler").warning("No se conoce el tipo concreto de excepcion. Se lanza una excepcion normal!!!");
            throw new Exception("R01F: Unknown Exception");
        }
        if (callResult.resultValue == null) return returnValue;
        if (callResult.resultTypeCode == -1) {
            R01FLog.to((String)"p12dt.proxyHandler").warning("El tipo de retorno devuelto por el servlet RPC es UNKNOWN. Si el metodo devuelve un tipo String, se devuelve el valor devuelto, en otro caso se devuelve null!!!");
            if (method.getReturnType().equals(String.class)) return null;
            return callResult.resultValue.toString();
        }
        if (callResult.resultTypeCode == 2) {
            if (!callResult.resultType.equals(method.getReturnType().getName())) {
                throw new Exception("El tipo de objeto " + method.getReturnType().getName() + " devuelto por el metodo " + method.getName() + " NO coincide con el devuelto por el m\u00e9todo correspondiente en el modulo RPC");
            }
            try {
                return XOManager.getObject((String)this.xoMapFile, (InputStream)new ByteArrayInputStream(("<?xml version='1.0' encoding='ISO-8859-1'?>" + callResult.resultValue.toString()).getBytes()));
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
                R01FLog.to((String)"p12dt.proxyHandler").warning("No se ha podido pasar a objeto el resultado de la llamada RPC: " + callResult.resultValue.toString() + "\r\n" + xoEx.getMessage() + "\r\nSe devuelve null!!!!!");
                return null;
            }
        }
        if (callResult.resultTypeCode == 3) {
            if (method.getReturnType().equals(String.class)) return callResult.resultValue.toString();
            try {
                return XOManager.getObject((String)this.xoMapFile, (InputStream)new ByteArrayInputStream(("<?xml version='1.0' encoding='ISO-8859-1'?>" + callResult.resultValue.toString()).getBytes()));
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
                R01FLog.to((String)"p12dt.proxyHandler").warning("No se ha podido pasar a objeto el resultado de la llamada RPC: " + callResult.resultValue.toString() + "\r\n" + xoEx.getMessage() + "\r\nSe devuelve null!!!!!");
                return null;
            }
        }
        if (callResult.resultTypeCode == 4) {
            if (method.getReturnType().equals(Integer.class)) return new Integer(callResult.resultValue.toString());
            throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Integer sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
        }
        if (callResult.resultTypeCode == 6) {
            if (method.getReturnType().equals(Long.class)) return new Long(callResult.resultValue.toString());
            throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Long sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
        }
        if (callResult.resultTypeCode == 8) {
            if (method.getReturnType().equals(Double.class)) return new Double(callResult.resultValue.toString());
            throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Double sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
        }
        if (callResult.resultTypeCode == 10) {
            if (method.getReturnType().equals(Float.class)) return new Double(callResult.resultValue.toString());
            throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Float sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
        }
        if (callResult.resultTypeCode == 12) {
            if (!method.getReturnType().equals(Boolean.class)) {
                throw new Exception("El metodo RPC remoto ha devuelto un java.lang.Boolean sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
            }
            String booleanVal = callResult.resultValue.toString();
            if (booleanVal.equalsIgnoreCase("true")) {
                return new Boolean(true);
            }
            if (!booleanVal.equalsIgnoreCase("false")) throw new Exception("Valor incorrecto para un tipo de retorno boolean: " + booleanVal);
            return new Boolean(false);
        }
        if (callResult.resultTypeCode != 14) return returnValue;
        if (method.getReturnType().equals(java.util.Date.class)) return DateUtils.getDateFromFormatedString((String)callResult.resultValue.toString(), (String)"dd/MM/yyyy");
        if (method.getReturnType().equals(Date.class)) return DateUtils.getDateFromFormatedString((String)callResult.resultValue.toString(), (String)"dd/MM/yyyy");
        throw new Exception("El metodo RPC remoto ha devuelto un java.util.Date sin embargo, el BZD establece que devuelve un " + method.getReturnType().getName());
    }

    private class IncommingCallResult
    extends DefaultHandler
    implements LexicalHandler {
        public int resultTypeCode = -1;
        public String resultType = null;
        public StringBuffer resultValue = null;
        private Stack tagStack = new Stack();
        private boolean loadingResult = false;

        public IncommingCallResult(InputStream newIs) throws SAXException {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", this);
                saxParser.parse(newIs, (DefaultHandler)this);
            }
            catch (ParserConfigurationException pcEx) {
                throw new SAXException("Error en la configuraci\u00f3n del parser: " + pcEx.getMessage());
            }
            catch (IOException ioEx) {
                throw new SAXException("Error de IO " + ioEx.getMessage());
            }
        }

        public String composeDebugInfo() {
            StringBuffer sb = new StringBuffer();
            sb.append("<rpcCallResult>");
            sb.append("\r\n\t<dataType code='" + this.resultTypeCode + "'>" + this.resultType + "</dataType>");
            sb.append("\r\n\t<returnValue>");
            sb.append(this.resultValue);
            sb.append("\r\n\t</returnValue>");
            sb.append("\r\n</rpcCallResult>\r\n");
            return sb.toString();
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) {
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (this.loadingResult) {
                this.resultValue.append("<" + eName);
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        this.resultValue.append(" " + attrs.getQName(i) + "='");
                        this.resultValue.append(attrs.getValue(i) + "'");
                    }
                }
                this.resultValue.append(">");
                return;
            }
            this.tagStack.push(eName);
            if (eName.equals("dataType") && attrs != null) {
                String resultTypeStr = attrs.getValue("code");
                this.resultTypeCode = Integer.parseInt(resultTypeStr);
            } else if (eName.equals("returnValue")) {
                this.loadingResult = true;
                this.resultValue = new StringBuffer();
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            String s = new String(buf, offset, len);
            String currentTag = (String)this.tagStack.peek();
            if (currentTag.equals("dataType")) {
                this.resultType = this.resultType == null ? new String(s) : this.resultType + s;
            } else if (currentTag.equals("returnValue")) {
                this.resultValue.append(s);
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) {
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equals("dataType")) {
                this.tagStack.pop();
            } else if (eName.equals("returnValue")) {
                this.loadingResult = false;
                this.tagStack.pop();
            } else if (this.loadingResult) {
                this.resultValue.append("</" + eName + ">");
            }
        }

        @Override
        public void startCDATA() {
            if (this.loadingResult) {
                this.resultValue.append("<![CDATA[");
            }
        }

        @Override
        public void endCDATA() {
            if (this.loadingResult) {
                this.resultValue.append("]]>");
            }
        }

        @Override
        public void comment(char[] values, int param, int param2) {
        }

        @Override
        public void startEntity(String str) {
        }

        @Override
        public void endEntity(String str) {
        }

        @Override
        public void endDTD() {
        }

        @Override
        public void startDTD(String str, String str1, String str2) {
        }
    }
}

