/*
 * Decompiled with CFR 0.152.
 */
package p12d.exe.generarpago.mobile.helpers;

import java.util.HashMap;
import java.util.StringTokenizer;
import p12f.exe.pasarelapagos.objects.DatosPago;
import p12f.exe.pasarelapagos.objects.Expediente;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.paymentrequest.Aplicacion;
import p12f.exe.pasarelapagos.paymentrequest.PaymentRequestData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;

public class GeneratePaymentHelper {
    public static PeticionPago generatePeticionPago507(String emisor, String sufijo, String referencia, String identificacion, String importe, String iva) {
        PeticionPago peticionPago = new PeticionPago();
        DatosPago datosPeticionPago = new DatosPago();
        datosPeticionPago.formato = "507";
        datosPeticionPago.emisor = emisor + "-" + sufijo;
        datosPeticionPago.cpr = "9050794";
        datosPeticionPago.validar = 1;
        datosPeticionPago.tipo = sufijo;
        datosPeticionPago.referencia = referencia;
        datosPeticionPago.periodosPago = new HashMap();
        PeriodoPago periodoPago = new PeriodoPago();
        periodoPago.id = "periodoNormal";
        periodoPago.identificacion = identificacion;
        if (Integer.parseInt(sufijo) >= 500) {
            periodoPago.fechaFin = identificacion;
        }
        periodoPago.activo = true;
        periodoPago.importe = Long.parseLong(importe);
        datosPeticionPago.periodosPago.put(periodoPago.id, periodoPago);
        peticionPago.datosPago = datosPeticionPago;
        peticionPago.id = datosPeticionPago.cpr + datosPeticionPago.emisor + datosPeticionPago.referencia;
        Aplicacion app = new Aplicacion();
        app.codigo = "z99";
        HashMap<String, String> descripciones = new HashMap<String, String>();
        descripciones.put("es", "Aplicacion de Prueba");
        descripciones.put("eu", "Aplicacion de Prueba");
        peticionPago.id = datosPeticionPago.cpr + datosPeticionPago.emisor + datosPeticionPago.referencia;
        peticionPago.aplicacion = app;
        peticionPago.datosPago = datosPeticionPago;
        peticionPago.descripcion = descripciones;
        return peticionPago;
    }

    public static PaymentRequestData generatePaymentRequestData(String pagos) {
        PaymentRequestData paymentRequestData = new PaymentRequestData();
        StringTokenizer pagosTokenizer = new StringTokenizer(pagos, "#");
        while (pagosTokenizer.hasMoreTokens()) {
            Expediente expediente;
            String token = pagosTokenizer.nextToken();
            StringTokenizer pagoTokenizer = new StringTokenizer(token, "$");
            String emisor = pagoTokenizer.nextToken();
            String sufijo = pagoTokenizer.nextToken();
            String referencia = pagoTokenizer.nextToken();
            String identificacion = pagoTokenizer.nextToken();
            String importeAux = pagoTokenizer.nextToken();
            String importe = importeAux.replaceFirst("^0+(?!$)", "");
            PeticionPago peticionPago = GeneratePaymentHelper.generatePeticionPago507(emisor, sufijo, referencia, identificacion, importe, null);
            peticionPago.expediente = expediente = new Expediente();
            paymentRequestData.peticionesPago.put(peticionPago.id, peticionPago);
        }
        return paymentRequestData;
    }

    public static PaymentRequestData generatePaymentRequestData(String emisor, String sufijo, String referencia, String identificacion, String importe, String iva) {
        Expediente expediente;
        PaymentRequestData paymentRequestData = new PaymentRequestData();
        PeticionPago peticionPago = GeneratePaymentHelper.generatePeticionPago507(emisor, sufijo, referencia, identificacion, importe, null);
        peticionPago.expediente = expediente = new Expediente();
        paymentRequestData.peticionesPago.put(peticionPago.id, peticionPago);
        return paymentRequestData;
    }
}

