﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:utils="xalan://p12f.exe.pasarelapagos.utils.fop.PDFUtils" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="java" xmlns:java="http://xml.apache.org/xslt/java">

	<xsl:variable name="rootSrv">$p12.rootSrv$</xsl:variable>
	<xsl:variable name="rootDatos">$p12.rootDatos$</xsl:variable>

	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page-master" page-height="297mm" page-width="210mm">
				<fo:region-body font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt" margin-left="15mm"/>
				<fo:region-before margin-top="0mm" extent="600mm" margin-left="0mm" margin-right="0mm"/>
				<fo:region-after extent="0mm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>

	<!-- FORMATO DECIMAL USADO PARA LA VISUALIZACIÓN DE IMPORTES EN EUROS -->
    <xsl:decimal-format name="euro" decimal-separator="," grouping-separator="."/>
	
	<xsl:template name="subTemplate_textosLaterales">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<fo:instream-foreign-object>
					<svg:svg xmlns:svg="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="210mm" height="300mm">
						<svg:g transform="translate(15,500)">
							<svg:g transform="rotate(-90)">
								<svg:text x="0" y="0" style="font-size:5pt;font-weight:bold;">IFZ:</svg:text>
								<svg:text x="12" y="0" style="font-size:5pt;">
									<xsl:value-of select="paymentRequestData/peticionesPago/peticionPago/emisor/cif"/>
								</svg:text>
								<svg:text x="0" y="5" style="font-size:5pt;font-weight:bold;">Baltzu-izena:</svg:text>
								<svg:text x="37" y="5" style="font-size:5pt;">
									<xsl:value-of select="paymentRequestData/peticionesPago/peticionPago/emisor/nombre/eu"/>
								</svg:text>
								<svg:text x="0" y="10" style="font-size:5pt;font-weight:bold;">Baltzu-helbidea:</svg:text>
								<svg:text x="45" y="10" style="font-size:5pt;">
									<xsl:value-of select="concat(paymentRequestData/peticionesPago/peticionPago/emisor/calle, ' - ', paymentRequestData/peticionesPago/peticionPago/emisor/codigoPostal, ' ', paymentRequestData/peticionesPago/peticionPago/emisor/municipio)"/>
								</svg:text>
							</svg:g>
						</svg:g>
						<svg:g transform="translate(15,250)">
							<svg:g transform="rotate(-90)">
								<svg:text x="0" y="0" style="font-size:5pt;font-weight:bold;">CIF:</svg:text>
								<svg:text x="12" y="0" style="font-size:5pt;">
									<xsl:value-of select="paymentRequestData/peticionesPago/peticionPago/emisor/cif"/>
								</svg:text>
								<svg:text x="0" y="5" style="font-size:5pt;font-weight:bold;">Razón social:</svg:text>
								<svg:text x="37" y="5" style="font-size:5pt;">
									<xsl:value-of select="paymentRequestData/peticionesPago/peticionPago/emisor/nombre/es"/>
								</svg:text>
								<svg:text x="0" y="10" style="font-size:5pt;font-weight:bold;">Domicilio social:</svg:text>
								<svg:text x="45" y="10" style="font-size:5pt;">
									<xsl:value-of select="concat(paymentRequestData/peticionesPago/peticionPago/emisor/calle, ' - ', paymentRequestData/peticionesPago/peticionPago/emisor/codigoPostal, ' ', paymentRequestData/peticionesPago/peticionPago/emisor/municipio)"/>
								</svg:text>
							</svg:g>
						</svg:g>
					</svg:svg>
				</fo:instream-foreign-object>
			</fo:block>
		</fo:static-content>
	</xsl:template>

	<xsl:template name="subTemplate_imagenCabecera">
		<fo:table padding="0mm" table-layout="fixed" width="180mm" space-before.optimum="0mm" space-after.optimum="0mm" padding-after="0mm" padding-before="0mm">
			<fo:table-column column-width="90mm"/>
			<fo:table-column column-width="90mm"/>
			<fo:table-body>
				<xsl:choose>
					<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/liquidacion/imagenes/imagen[@id = 'logo1' and url != '']">
						<!-- si hay imagen especificada, se pinta sin descripción-->
						<fo:table-row>
							<fo:table-cell number-columns-spanned="2" baseline-shift="baseline" padding-after="0mm" padding-before="0mm" text-align="center" padding-start="0mm" padding-end="0mm">
								<fo:block>
									<fo:external-graphic content-width="scale-to-fit" space-before.optimum="0mm" space-after.optimum="0mm" width="105mm">
										<xsl:attribute name="src"><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/imagenes/imagen[@id='logo1']/url"/></xsl:attribute>
									</fo:external-graphic>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</xsl:when>
					<xsl:otherwise>
						<!-- si NO hay imagen especificada, se pinta la estándar además de una línea con texto descriptivo -->
						<fo:table-row>
							<!-- Si la descripción en euskera es igual que en castellano, solo se pone 1 de las dos -->
							<xsl:choose>
							<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/emisor/nombre/es = /paymentRequestData/peticionesPago/peticionPago/emisor/nombre/eu">
								<fo:table-cell number-columns-spanned="2" font-family="Helvetica" font-size="7pt" font-variant="small-caps" padding-before="0pt" padding-start="5.1cm">
									<fo:block>
										<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
											<xsl:for-each select="nombre/es">
												<xsl:apply-templates/>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</xsl:when>
							
							<xsl:otherwise>
								<fo:table-cell font-family="Helvetica" font-size="7pt" font-variant="small-caps" padding-before="0pt" padding-start="4cm" padding-end="3pt" padding-after="3pt">
									<fo:block>
										<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
											<xsl:for-each select="nombre/es">
												<xsl:apply-templates/>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell font-family="Helvetica" font-size="7pt" font-variant="small-caps" padding-before="0pt" padding-end="4cm" padding-start="1.0cm" padding-after="3pt">
									<fo:block>
										<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
											<xsl:for-each select="nombre/eu">
												<xsl:apply-templates/>
											</xsl:for-each>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
							</xsl:otherwise>
							</xsl:choose>
						</fo:table-row>
						<!-- Fin if-else: hay imagen especificada?-->
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id = '4']">
						<fo:table-row>
							<fo:table-cell font-family="Helvetica" font-size="7pt" font-weight="bold" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
								<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id='4']/texto/eu"/></fo:block>
							</fo:table-cell>
							<fo:table-cell font-family="Helvetica" font-size="7pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
								<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id='4']/texto/es"/></fo:block>
							</fo:table-cell>
						</fo:table-row>
					</xsl:when>
				</xsl:choose>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="subTemplate_datosEmisor">
		<fo:table padding="0pt" width="100%" table-layout="fixed">
			<fo:table-column column-width="510pt"/>
		<fo:table-body>
			<fo:table-row>
				<fo:table-cell background-color="#C0C0C0" border-color="black" border-style="solid" border-width="1pt" font-family="Helvetica" font-size="11pt" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
					<fo:block>
						<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/descripcion">
							<xsl:for-each select="eu">
								<xsl:variable name="titDesEu" select="/paymentRequestData/peticionesPago/peticionPago/descripcion/eu" />
								<xsl:variable name="titDesEs" select="/paymentRequestData/peticionesPago/peticionPago/descripcion/es" />
									<xsl:choose>
										<xsl:when test="(string-length($titDesEu) > 76) or (string-length($titDesEs) > 76)">
											<fo:inline font-weight="bold" font-size="8pt"><xsl:apply-templates/></fo:inline>
										</xsl:when>
										<xsl:otherwise>
											<fo:inline font-weight="bold" font-size="11pt"><xsl:apply-templates/></fo:inline>
										</xsl:otherwise>
									</xsl:choose>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
					<fo:block>
						<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/descripcion">
							<xsl:for-each select="es">
								<xsl:variable name="titDesEs" select="/paymentRequestData/peticionesPago/peticionPago/descripcion/es" />
								<xsl:variable name="titDesEu" select="/paymentRequestData/peticionesPago/peticionPago/descripcion/eu" />
									<xsl:choose>
										<xsl:when test="(string-length($titDesEu) > 76) or (string-length($titDesEs) > 76)">
											<fo:inline font-size="8pt"><xsl:apply-templates/></fo:inline>
										</xsl:when>
										<xsl:otherwise>
											<fo:inline  font-size="11pt"><xsl:apply-templates/></fo:inline>
										</xsl:otherwise>
									</xsl:choose>
							</xsl:for-each>
						</xsl:for-each>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell font-family="Helvetica" padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" width="100%">
					<fo:block>
						<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="0pt">
							<fo:table-column column-width="100pt"/>
							<fo:table-column column-width="280pt"/>
							<fo:table-column column-width="30pt"/>
							<fo:table-column column-width="100pt"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Ematen duen Erakundea</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>
										<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
											<xsl:choose>
												<xsl:when test="nombre/organo.eu!=''">
													<xsl:for-each select="nombre/organo.eu">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:when>
												<xsl:otherwise>
													<xsl:for-each select="nombre/eu">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Zkia.</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/codigo"/></fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Órgano que lo expide</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>
										<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
											<xsl:choose>
												<xsl:when test="nombre/organo.es!=''">
													<xsl:for-each select="nombre/organo.es">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:when>
												<xsl:otherwise>
													<xsl:for-each select="nombre/es">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Nº</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell font-family="Helvetica" padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" width="100%">
					<fo:block>
						<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="0pt">
							<fo:table-column column-width="100pt"/>
							<fo:table-column column-width="320pt"/>
							<fo:table-column column-width="30pt"/>
							<fo:table-column column-width="60pt"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Izena eta Deiturak</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
								
									<xsl:variable name="primerApellido" select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/primerApellido" />
									<xsl:variable name="segundoApellido" select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/segundoApellido" />
									<xsl:variable name="razonSocial" select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/razonSocial" />					
									<fo:block>
										<xsl:value-of select="$primerApellido"/>&#160;
										<xsl:value-of select="$segundoApellido"/>
										<xsl:if test="$primerApellido != ''">
											<xsl:if test="$razonSocial != ''">,&#160;</xsl:if>
										</xsl:if>
										<xsl:value-of select="$razonSocial"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>NAN</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/dniNif"/></fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Apellidos y nombre</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>DNI</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell font-family="Helvetica" padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" width="100%">
					<fo:block>
						<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="0pt">
							<fo:table-column column-width="50pt"/>
							<fo:table-column column-width="170pt"/>
							<fo:table-column column-width="50pt"/>
							<fo:table-column column-width="150pt"/>
							<fo:table-column column-width="30pt"/>
							<fo:table-column column-width="60pt"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Helbidea</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/calle"/></fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Udalerria</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/municipio"/></fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>PK</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/codigoPostal"/></fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Dirección</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Municipio</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>CP</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell font-family="Helvetica" padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" width="100%">
					<fo:block>
						<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="0pt">
							<fo:table-column column-width="50pt"/>
							<fo:table-column column-width="170pt"/>
							<fo:table-column column-width="50pt"/>
							<fo:table-column column-width="240pt"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Lurraldea</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/territorio"/></fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Herrialdea</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/pais"/></fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Provincia</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>País</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
<!--omitios la fila del telefono y email 
			<fo:table-row>
				<fo:table-cell font-family="Helvetica" padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" width="100%">
					<fo:block>
						<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="0pt">
							<fo:table-column column-width="50pt"/>
							<fo:table-column column-width="170pt"/>
							<fo:table-column column-width="50pt"/>
							<fo:table-column column-width="240pt"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Tfnoa.</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/datosAdicionales/datoAdicional[@id='telefono']/valor"/></fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>E-mail</fo:block>
								</fo:table-cell>
								<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/tercero/datosAdicionales/datoAdicional[@id='email']/valor"/></fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Tfno.</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>E-mail</fo:block>
								</fo:table-cell>
								<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>-->
		</fo:table-body>
	</fo:table>

	</xsl:template>

	<xsl:template name="subTemplate_mensajes">
		<fo:table width="180mm" table-layout="fixed">
			<fo:table-column column-width="90mm"/>
			<fo:table-column column-width="90mm"/>
		<fo:table-body>
			<fo:table-row>
				<xsl:choose>
				<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id = '2']">
					<fo:table-cell font-family="Helvetica" font-size="6.5pt" font-weight="bold" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id='2']/texto/eu"/></fo:block>
					</fo:table-cell>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-cell font-family="Helvetica" font-size="6.5pt" font-weight="bold" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block>13/1998 Legeak, maiatzaren 29koa, Euskal Autonomia Erkidegoko Administrazioaren tasa eta prezio publikoei buruzkoa, kitapen honen gaia den tasa arantzen du.</fo:block>
					</fo:table-cell>
				</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
				<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id = '2']">
					<fo:table-cell font-family="Helvetica" font-size="6.5pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id='2']/texto/es"/></fo:block>
					</fo:table-cell>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-cell font-family="Helvetica" font-size="6.5pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block>La tasa objeto de esta liquidación está sujeta a la Ley 13/1998, de 29 de mayo, de tasas y precios públicos de la Administración de la Comunidad Autónoma del País Vasco.</fo:block>
					</fo:table-cell>
				</xsl:otherwise>
				</xsl:choose>
			</fo:table-row>	
			<fo:table-row>
				<xsl:choose>
				<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id = '3']">
					<fo:table-cell font-family="Helvetica" font-size="6.5pt" font-weight="bold" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id='3']/texto/eu"/></fo:block>
					</fo:table-cell>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-cell font-family="Helvetica" font-size="6.5pt" font-weight="bold" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block>Kitapenaren kontra berraztetzeko, errekurtsoa aurkestu ahal izango zaio kipapena egin duen organoari, edo, bestela, ebazpenaren kontra Administraziorekiko diru erreklamazioa jarri ahal izango da Euskadiko Ekonomia Arduralaritzako Epaitegian, jakinarazpena jaso eta 15 eguneko epean.</fo:block>
					</fo:table-cell>
				</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
				<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id = '3']">
					<fo:table-cell font-family="Helvetica" font-size="6.5pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id='3']/texto/es"/></fo:block>
					</fo:table-cell>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-cell font-family="Helvetica" font-size="6.5pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block>Contra esta liquidación podrá interponerse, en el plazo de 15 días desde su notificación, un recurso de reposición ante el órgano que dictó la resolución, o, en su defecto o contra su resolución, reclamación económico-administrativa ante el "Tribunal Económico-Administrativo de Euskadi", en el mismo plazo.</fo:block>
					</fo:table-cell>
				</xsl:otherwise>
				</xsl:choose>
			</fo:table-row>
		</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="subTemplate_conceptos">
		<fo:table width="100%" table-layout="fixed" space-after.optimum="4pt" padding-start="1cm" >
			<!-- un concepto por fila -->
			<!-- un concepto por fila -->
				<fo:table-column column-width="380pt"/>
				<fo:table-column column-width="130pt"/>
			<!-- ACTIVAR PARA PRECIO UNITARIO-->
			<!--
			<fo:table-column column-width="265pt"/>
			<fo:table-column column-width="40pt"/>
			<fo:table-column column-width="60pt"/>
			<fo:table-column column-width="40pt"/>
			<fo:table-column column-width="40pt"/>
			<fo:table-column column-width="65pt"/> -->
		<fo:table-header><!-- CABECERA -->
			<fo:table-row>
				<fo:table-cell background-color="#C0C0C0" border-after-color="black" border-after-style="solid" border-after-width="1pt" 
					border-before-color="black" border-before-style="solid" border-before-width="1pt"
					border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="normal" line-height="6pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:block>
						<fo:inline font-weight="bold">Gaia</fo:inline>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						Concepto
					</fo:block>
				</fo:table-cell>
		<!-- ACTIVAR PARA PRECIO UNITARIO-->
				<!--<fo:table-cell background-color="#C0C0C0" border-after-color="black" border-after-style="solid" border-after-width="1pt" 
					border-before-color="black" border-before-style="solid" border-before-width="1pt"
					border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="normal" line-height="6pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:block>
						<fo:inline font-weight="bold">Aleak</fo:inline>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						Unidades
					</fo:block>
				</fo:table-cell>
				<fo:table-cell background-color="#C0C0C0" border-after-color="black" border-after-style="solid" border-after-width="1pt" 
					border-before-color="black" border-before-style="solid" border-before-width="1pt"
					border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="normal" line-height="6pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:block>
						<fo:inline font-weight="bold">Aleko Prezioa</fo:inline>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						Precio Unitario
					</fo:block>
				</fo:table-cell>
				<fo:table-cell background-color="#C0C0C0" border-after-color="black" border-after-style="solid" border-after-width="1pt" 
					border-before-color="black" border-before-style="solid" border-before-width="1pt"
					border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="normal" line-height="6pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:block>
						<fo:inline font-weight="bold">BEZ %</fo:inline>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						% IVA
					</fo:block>
				</fo:table-cell>
				<fo:table-cell background-color="#C0C0C0" border-after-color="black" border-after-style="solid" border-after-width="1pt" 
					border-before-color="black" border-before-style="solid" border-before-width="1pt"
					border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="normal" line-height="6pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:block>
						<fo:inline font-weight="bold">BEZ</fo:inline>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						IVA
					</fo:block>
				</fo:table-cell>-->
				<fo:table-cell background-color="#C0C0C0" border-after-color="black" border-after-style="solid" border-after-width="1pt" 
					border-before-color="black" border-before-style="solid" border-before-width="1pt" 
					border-end-color="black" border-end-style="solid" border-end-width="1pt" 
					border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" line-height="6pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:block>
						<fo:inline font-weight="bold">Zenbatekoa (€)</fo:inline>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						Importe (€)
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-header>
		<fo:table-body>			<!-- CUERPO -->	<!-- un concepto por fila -->
			<!-- Elegir conceptos -->
			<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/conceptos/conceptoPeticion">
			<xsl:if test="IVARepercutido = 'false'">
				<fo:table-row>
					<!-- CONCEPTO -->
					<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" 
						border-after-color="black" border-after-style="solid" border-after-width="0.5pt" 
						font-family="Helvetica" font-size="8pt" 
						padding-after="2pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
						<fo:block>
							<fo:inline font-weight="bold"><xsl:value-of select="descripcion/eu"/></fo:inline>
						</fo:block>
						<fo:block>
							<xsl:value-of select="descripcion/es"/>
						</fo:block>
					</fo:table-cell>
	<!-- ACTIVAR PARA PRECIO UNITARIO-->
					<!--<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" 
						border-end-color="black" border-end-style="solid" border-end-width="1pt"
						border-after-color="black" border-after-style="solid" border-after-width="0.5pt" 
						font-family="Helvetica" font-size="8pt" 
						padding-after="2pt" padding-before="2pt" padding-end="5pt" padding-start="2pt">

						<fo:block text-align="right">
							<fo:inline><xsl:value-of select="unidades"/></fo:inline>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" 
						border-end-color="black" border-end-style="solid" border-end-width="1pt"
						border-after-color="black" border-after-style="solid" border-after-width="0.5pt" 
						font-family="Helvetica" font-size="8pt" 
						padding-after="2pt" padding-before="2pt" padding-end="5pt" padding-start="2pt">

						<fo:block text-align="right">
							<xsl:variable name="unidades" select="unidades" />
							<xsl:variable name="importe" select="importe" />
							<xsl:variable name="importeIVA" select="importeIVA" />
							<xsl:variable name="importeTotal" select="(($importe)-($importeIVA)) div $unidades" />
							<xsl:value-of  select="format-number($importeTotal div 100, '#.##0,00', 'euro')"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" 
						border-end-color="black" border-end-style="solid" border-end-width="1pt"
						border-after-color="black" border-after-style="solid" border-after-width="0.5pt" 
						font-family="Helvetica" font-size="8pt" 
						padding-after="2pt" padding-before="2pt" padding-end="5pt" padding-start="2pt">
						<fo:block text-align="right">
							<xsl:variable name="numeroLineaPadre" select="numeroLinea" />
							<xsl:if test="tipoIVA = 0">
								<xsl:choose>
									<xsl:when test="tieneIVARepercutido = 'false'">
										<xsl:variable name="tipoIVA" select="tipoIVA" />
										<xsl:value-of  select="format-number($tipoIVA div 100, '#.##0,00', 'euro')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/conceptos/conceptoPeticion">
											<xsl:variable name="tipoIVA" select="tipoIVA" />
											<xsl:if test="numeroLinea = ($numeroLineaPadre+1)">									
												<xsl:value-of  select="format-number($tipoIVA div 100, '#.##0,00', 'euro')"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
							<xsl:if test="tipoIVA != 0">
								<xsl:variable name="tipoIVA" select="tipoIVA" />
								<xsl:value-of  select="format-number($tipoIVA div 100, '#.##0,00', 'euro')"/>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" 
						border-end-color="black" border-end-style="solid" border-end-width="1pt"
						border-after-color="black" border-after-style="solid" border-after-width="0.5pt" 
						font-family="Helvetica" font-size="8pt" 
						padding-after="2pt" padding-before="2pt" padding-end="5pt" padding-start="2pt">
						<fo:block text-align="right">
						<xsl:variable name="numeroLineaPadre" select="numeroLinea" />
						<xsl:if test="importeIVA = 00">
							<xsl:choose>
								<xsl:when test="tieneIVARepercutido = 'false'">
									<xsl:variable name="importeIVA" select="importeIVA" />
									<xsl:value-of  select="format-number($importeIVA div 100, '#.##0,00', 'euro')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/conceptos/conceptoPeticion">
										<xsl:if test="numeroLinea = ($numeroLineaPadre+1)">
											<xsl:variable name="importeIVA" select="importeIVA" />
											<xsl:value-of  select="format-number($importeIVA div 100, '#.##0,00', 'euro')"/>
										</xsl:if>
									</xsl:for-each>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
						<xsl:if test="importeIVA != 00">
							<xsl:variable name="importeIVA" select="importeIVA" />
							<xsl:value-of  select="format-number($importeIVA div 100, '#.##0,00', 'euro')"/>
						</xsl:if>
						</fo:block>
					</fo:table-cell>-->
					
					<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" 
						border-end-color="black" border-end-style="solid" border-end-width="1pt"
						border-after-color="black" border-after-style="solid" border-after-width="0.5pt" 
						font-family="Helvetica" font-size="8pt" 
						padding-after="2pt" padding-before="2pt" padding-end="5pt" padding-start="2pt">
					<!-- IMPORTE TOTAL -->
						<fo:block text-align="right">
							<xsl:variable name="numeroLineaPadre" select="numeroLinea" />
							<xsl:if test="importeIVA = 00">
								<xsl:choose>
									<xsl:when test="tieneIVARepercutido = 'false'">
										<xsl:variable name="importe" select="importe" />
										<xsl:variable name="importeTotal" select="$importe" />
										<xsl:value-of  select="concat('****', format-number($importeTotal div 100, '#.##0,00', 'euro'))"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:variable name="unidades" select="1" />
										<xsl:variable name="importe" select="importe" />
										<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/conceptos/conceptoPeticion">
											<xsl:if test="numeroLinea = ($numeroLineaPadre+1)">
												<xsl:variable name="importeIVA" select="importeIVA" />
												<xsl:variable name="importeTotal" select="$importe+$importeIVA" />
												<xsl:value-of  select="concat('****', format-number($importeTotal div 100, '#.##0,00', 'euro'))"/>
											</xsl:if>
										</xsl:for-each>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
							<xsl:if test="importeIVA != 00">
								<xsl:variable name="importeIVA" select="importeIVA" />
								<xsl:variable name="importe" select="importe" />
								<xsl:variable name="importeTotal" select="$importe" />
								<xsl:value-of select="concat('****',format-number($importeTotal div 100, '#.##0,00', 'euro'))"/>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				</xsl:if>
			</xsl:for-each>
			<!-- fila de FECHA LIMITE de PAGO y EXPEDIENTE -->
			<fo:table-row>
				<fo:table-cell number-columns-spanned="2" font-family="Helvetica" padding-after="0pt" padding-before="0pt" padding-end="0pt" width="100%">
					<fo:block>
						<fo:table width="100%" table-layout="fixed" space-after.optimum="4pt" padding-start="1cm" >
							<!-- un concepto por fila -->
							<fo:table-column column-width="100pt"/>
							<fo:table-column column-width="280"/>
							<fo:table-column column-width="60pt"/>
							<fo:table-column column-width="70pt"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Ordaintzeko epea</fo:block>
								</fo:table-cell>
								<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>
										<xsl:variable name="fechaFin" select="/paymentRequestData/peticionesPago/peticionPago/datosPago/periodosPago/periodoPago/fechaFin" />
										<xsl:value-of select="concat(substring($fechaFin,1 ,2),concat('/',concat(substring($fechaFin,3,2),concat('/',substring($fechaFin,5,2)))))"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-before="2pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Guztira</fo:block>
								</fo:table-cell>
								<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-before="2pt" padding-end="0pt" padding-start="2pt">		
									<fo:block>
										<xsl:variable name="importeTotal" select="/paymentRequestData/peticionesPago/peticionPago/datosPago/periodosPago/periodoPago/importe" />
										<xsl:value-of select="concat('EUR ****',format-number($importeTotal div 100, '#.##0,00', 'euro'))"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Fecha limite de pago</fo:block>
								</fo:table-cell>
								<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
								<fo:table-cell border-start-color="black" border-start-style="solid" border-start-width="1pt" border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block>Total</fo:block>
								</fo:table-cell>
								<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
									<fo:block></fo:block>
								</fo:table-cell>
							</fo:table-row>	
						</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<!-- FIN de fila de FECHA LIMITE de PAGO  y  EXPEDIENTE-->
		</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="subTemplate_cabeceraCartaPago">
		<fo:table-row>
			<fo:table-cell number-columns-spanned="4" font-family="Helvetica" padding-after="0pt" padding-before="0pt" padding-end="0pt" padding-start="0pt" width="100%">
				<fo:block>
					<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="0pt">
						<fo:table-column column-width="145pt"/>
						<fo:table-column column-width="220pt"/>
						<fo:table-column column-width="145pt"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell background-color="#C0C0C0" border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
								<fo:block>Ordainketa - Gutuna</fo:block>
							</fo:table-cell>
							<fo:table-cell background-color="#C0C0C0" border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
								<fo:block>Bilketa-prozedura Kodea - BPK</fo:block>
							</fo:table-cell>
							<fo:table-cell number-rows-spanned="2" background-color="#FFFFFF" border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="11pt" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt" text-align="center">
								<fo:block>
									<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="0pt">
									<fo:table-column column-width="140pt"/>
									<fo:table-body>
										<fo:table-row>
										<fo:table-cell background-color="#FFFFFF" font-family="Helvetica" font-size="11pt" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt" vertical-align="middle" text-align="center">
											<fo:block>
												<xsl:value-of select="9050794"/>
											</fo:block>
										</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
									</fo:table>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell background-color="#C0C0C0" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
								<fo:block>Carta de Pago</fo:block>
							</fo:table-cell>
							<fo:table-cell background-color="#C0C0C0" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
								<fo:block>Código Procedimiento Recaudatorio - CPR</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
				<fo:block>Erakunde Igorlea</fo:block>
			</fo:table-cell>
			<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
				<fo:block>Erreferentzia</fo:block>
			</fo:table-cell>
			<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
				<fo:block>Identifikazioia - Ordaintzeko epea</fo:block>
			</fo:table-cell>
			<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
				<fo:block>Zenbatekoa</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
				<fo:block>Entidad Emisora</fo:block>
			</fo:table-cell>
			<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
				<fo:block>Referencia</fo:block>
			</fo:table-cell>
			<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
				<fo:block>Identificación - Fecha límite de pago</fo:block>
			</fo:table-cell>
			<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
				<fo:block>Importe</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
				<fo:block>
					<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/datosPago">
						<xsl:for-each select="emisor">
							<xsl:apply-templates/>
						</xsl:for-each>
					</xsl:for-each>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
				<fo:block>
					<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/datosPago">
						<xsl:for-each select="referencia">
							<xsl:apply-templates/>
						</xsl:for-each>
					</xsl:for-each>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
				<fo:block>
					<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/datosPago/periodosPago/periodoPago">
						<xsl:for-each select="identificacion">
							<xsl:apply-templates/>
						</xsl:for-each>
					</xsl:for-each>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
				<fo:block>
					<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/datosPago/periodosPago/periodoPago">
						<xsl:value-of select="concat('EUR ****',format-number(importe div 100, '#.##0,00', 'euro'))"/>
					</xsl:for-each>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>

	<xsl:template name="subTemplate_cartaPago">
		<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="4pt" space-after.optimum="4pt">
			<fo:table-column column-width="123pt"/>
			<fo:table-column column-width="124pt"/>
			<fo:table-column column-width="138pt"/>
			<fo:table-column column-width="125pt"/>
		<fo:table-body>
			<xsl:call-template name="subTemplate_cabeceraCartaPago"/>
			<fo:table-row>
				<fo:table-cell number-columns-spanned="4" border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="6pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="0pt" text-align="center">
					<fo:block>(<fo:inline font-weight="bold">Sinadura</fo:inline> / Firma)</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row height="0.8cm">
				<fo:table-cell number-columns-spanned="4" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:block/>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell number-columns-spanned="2" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="6pt" font-weight="bold" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:block>
						<xsl:variable name="mes"><xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new ('MM'), java:java.util.Date.new())"/></xsl:variable>
						<xsl:choose>
							<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/emisor/municipio != ''">
								<xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/emisor/municipio"/>
							</xsl:when>
							<xsl:otherwise>................................................</xsl:otherwise>
						</xsl:choose>(e)n, <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new ('yyyy'), java:java.util.Date.new())"/>(e)ko 
						<xsl:choose>
							<xsl:when test="$mes=01">urtarrila</xsl:when>
							<xsl:when test="$mes=02">otsaila</xsl:when>
							<xsl:when test="$mes=03">martxoa</xsl:when>
							<xsl:when test="$mes=04">apirila</xsl:when>
							<xsl:when test="$mes=05">maiatza</xsl:when>
							<xsl:when test="$mes=06">ekaina</xsl:when>
							<xsl:when test="$mes=07">uztaila</xsl:when>
							<xsl:when test="$mes=08">abuztua</xsl:when>
							<xsl:when test="$mes=09">iraila</xsl:when>
							<xsl:when test="$mes=10">urria</xsl:when>
							<xsl:when test="$mes=11">azaroa</xsl:when>
							<xsl:when test="$mes=12">abendua</xsl:when>
							<xsl:otherwise><xsl:value-of select="$mes"/></xsl:otherwise>
						</xsl:choose>ren <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new ('d'), java:java.util.Date.new())"/>(e)(a)n.
					</fo:block>
				</fo:table-cell>
				<fo:table-cell number-columns-spanned="2" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="6pt" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:block> En
						<xsl:choose>
							<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/emisor/municipio != ''">&#160;<xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/emisor/municipio"/>&#160;</xsl:when>
							<xsl:otherwise>................................................</xsl:otherwise>
						</xsl:choose>a <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new ('d'), java:java.util.Date.new())"/> de <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new ('MMMM', java:java.util.Locale.new('es', 'ES')), java:java.util.Date.new())"/> de <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new ('yyyy'), java:java.util.Date.new())"/>.
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell number-columns-spanned="4" border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
					<fo:block>Banketxearen sendespen mekanikorako tartea</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell number-columns-spanned="4" border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
					<fo:block>Espacio para validación mecánica bancaria</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="subTemplate_imagenCabecera2">
			<fo:table-cell font-family="Helvetica" font-size="4pt" width="100%" padding-end="3pt" padding-before="0pt" padding-after="0pt">
				<fo:block>
					<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="4pt" space-after.optimum="4pt">
						<fo:table-column column-width="130pt"/>
						<fo:table-column column-width="100pt"/>
						<fo:table-column column-width="150pt"/>
						<fo:table-column column-width="30pt"/>
						<fo:table-column column-width="100pt"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell number-rows-spanned="4" display-align="center" font-family="Helvetica" font-size="6pt" font-weight="bold" line-height="4pt"  padding-before="0pt" padding-end="0pt" padding-start="0pt">
								<fo:block>
									<xsl:choose>
										<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/liquidacion/imagenes/imagen[@id = 'logo2' and url != '']">
											<fo:external-graphic content-width="scale-to-fit" space-before.optimum="4pt" width="37mm">
												<xsl:attribute name="src">
													<xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/imagenes/imagen[@id='logo2']/url"/>
												</xsl:attribute>
											</fo:external-graphic>
										</xsl:when>
										<xsl:otherwise>
											<!-- Si la descripción en euskera es igual que en castellano, solo se pone 1 de las dos -->
											<xsl:choose>
											<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/emisor/nombre/es = /paymentRequestData/peticionesPago/peticionPago/emisor/nombre/eu">
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; 
												<fo:block>
													<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
														<xsl:for-each select="nombre/es">
															<xsl:apply-templates/>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</xsl:when>
											<xsl:otherwise>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; 
												<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
													<xsl:for-each select="nombre/es">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:for-each>
												<fo:block>
													<fo:leader leader-pattern="space"/>
												</fo:block>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; 
												<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
													<xsl:for-each select="nombre/eu">
														<xsl:apply-templates/>
													</xsl:for-each>
												</xsl:for-each>
											</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell number-columns-spanned="4" background-color="#C0C0C0" border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="10pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
								<fo:block>
									<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/descripcion">
									<xsl:for-each select="eu">
										<xsl:variable name="titDesEu" select="/paymentRequestData/peticionesPago/peticionPago/descripcion/eu" />
										<xsl:variable name="titDesEs" select="/paymentRequestData/peticionesPago/peticionPago/descripcion/es" />
											<xsl:choose>
												<xsl:when test="(string-length($titDesEu) > 65) or (string-length($titDesEs) > 65)">
													<fo:inline font-weight="bold" font-size="7pt"><xsl:apply-templates/></fo:inline>
												</xsl:when>
												<xsl:otherwise>
													<fo:inline font-weight="bold" font-size="11pt"><xsl:apply-templates/></fo:inline>
												</xsl:otherwise>
											</xsl:choose>
									</xsl:for-each>
									</xsl:for-each>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell number-columns-spanned="4" background-color="#C0C0C0" border-end-color="black" border-end-style="solid" border-end-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="10pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
								<fo:block>
									<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/descripcion">
									<xsl:for-each select="es">
										<xsl:variable name="titDesEs" select="/paymentRequestData/peticionesPago/peticionPago/descripcion/es" />
										<xsl:variable name="titDesEu" select="/paymentRequestData/peticionesPago/peticionPago/descripcion/eu" />
											<xsl:choose>
												<xsl:when test="(string-length($titDesEu) > 65) or (string-length($titDesEs) > 65)">
													<fo:inline font-size="7pt"><xsl:apply-templates/></fo:inline>
												</xsl:when>
												<xsl:otherwise>
													<fo:inline font-size="11pt"><xsl:apply-templates/></fo:inline>
												</xsl:otherwise>
											</xsl:choose>
									</xsl:for-each>
									</xsl:for-each>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt" >
								<fo:block>Ematen duen Erakundea </fo:block>
							</fo:table-cell>
							<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt" >
								<fo:block>
									<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
										<xsl:choose>
											<xsl:when test="nombre/organo.eu!=''">
												<xsl:for-each select="nombre/organo.eu">
													<xsl:apply-templates/>
												</xsl:for-each>
											</xsl:when>
											<xsl:otherwise>
												<xsl:for-each select="nombre/eu">
													<xsl:apply-templates/>
												</xsl:for-each>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
								<fo:block>Zkia.</fo:block>
							</fo:table-cell>
							<fo:table-cell border-before-color="black" border-before-style="solid" border-before-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt">
								<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/expediente/codigo"/></fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-start-color="black" border-start-style="solid" border-start-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt" >
								<fo:block>Órgano que lo expide</fo:block>
							</fo:table-cell>
							<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt" >
								<fo:block>
									<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/emisor">
										<xsl:choose>
											<xsl:when test="nombre/organo.es!=''">
												<xsl:for-each select="nombre/organo.es">
													<xsl:apply-templates/>
												</xsl:for-each>
											</xsl:when>
											<xsl:otherwise>
												<xsl:for-each select="nombre/es">
													<xsl:apply-templates/>
												</xsl:for-each>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
								<fo:block>Nº</fo:block>
							</fo:table-cell>
							<fo:table-cell border-after-color="black" border-after-style="solid" border-after-width="1pt" border-end-color="black" border-end-style="solid" border-end-width="1pt" font-family="Helvetica" font-size="8pt" padding-after="2pt" padding-before="0pt" padding-end="0pt" padding-start="2pt">
								<fo:block></fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
					</fo:table>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell baseline-shift="baseline" text-align="center" width="1cm" number-rows-spanned="2" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="3pt">
				<fo:block>
					<fo:external-graphic content-width="scale-to-fit" space-before.optimum="4pt" space-after.optimum="4pt" width="7mm">
						<xsl:attribute name="src"><xsl:value-of select="concat($rootDatos,'/pdf/liquidacionCuadroDerechaInf.gif')"/></xsl:attribute>
					</fo:external-graphic>
				</fo:block>
			</fo:table-cell>
	</xsl:template>

	<xsl:template name="subTemplate_cartaPago2">
		<fo:table padding="0pt" width="180mm" table-layout="fixed" space-before.optimum="4pt" space-after.optimum="4pt">
			<fo:table-column column-width="43.4mm"/>
			<fo:table-column column-width="43.75mm"/>
			<fo:table-column column-width="48.75mm"/>
			<fo:table-column column-width="44.1mm"/>
		<fo:table-body>
			<xsl:call-template name="subTemplate_cabeceraCartaPago"/>
			<fo:table-row>
				<fo:table-cell number-columns-spanned="4" border-start-color="black" border-start-style="solid"
						border-before-color="black" border-before-style="solid" border-before-width="1pt"
						border-after-color="black" border-after-style="solid" border-after-width="1pt"
						border-end-color="black" border-end-style="solid" border-end-width="1pt"
						font-family="Helvetica" font-size="8pt" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
					<fo:table padding="0pt" width="180mm" table-layout="fixed" space-before.optimum="0pt">
						<fo:table-column/>
						<fo:table-column  column-width="220pt"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell font-family="Helvetica" font-size="6pt" font-weight="bold" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="0pt" text-align="center">
								<fo:block>
									<fo:table padding="0pt" width="100%" table-layout="fixed">
										<fo:table-column/>
										<fo:table-column/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell number-columns-spanned="2" font-family="Helvetica" font-size="7pt" padding-after="0pt" padding-before="4pt" padding-end="0pt" padding-start="2pt" text-align="left">
												<fo:block><fo:inline font-weight="bold">Ordainketa egiteko Finantza-erakundeak /</fo:inline><fo:inline font-weight="normal"> Entidades Financieras colaboradoras</fo:inline></fo:block>
											</fo:table-cell>
										</fo:table-row>
										<!--ENTINDADES FINANCIERAS -->
										<xsl:for-each select="/paymentRequestData/peticionesPago/peticionPago/finantialOrgs/finantialOrg">
												<xsl:variable name="posAux" select="position()" />
												<xsl:if test="$posAux mod 2 = 1">
													<fo:table-row>
														<fo:table-cell font-family="Helvetica" font-size="6pt" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt" text-align="left" >
															<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/finantialOrgs/finantialOrg[position()=$posAux]/text"/></fo:block>
														</fo:table-cell>
														<fo:table-cell font-family="Helvetica" font-size="6pt" padding-after="0pt" padding-before="2pt" padding-end="0pt" padding-start="2pt" text-align="left" >
															<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/finantialOrgs/finantialOrg[position()=$posAux+1]/text"/></fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:if>
										</xsl:for-each>
										<fo:table-row>
											<fo:table-cell number-columns-spanned="2" font-family="Helvetica" font-size="7pt" padding-after="0pt" padding-before="4pt" padding-end="0pt" padding-start="2pt" text-align="left">
												<fo:block><fo:inline font-weight="bold">Ordainketa Internet-en bidez /</fo:inline><fo:inline font-weight="normal"> Pago en Internet:</fo:inline></fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-family="Helvetica" font-size="7pt" padding-start="2pt" text-align="left">
												<fo:block text-decoration="underline">http://euskadi.eus/nireordainketa</fo:block>
											</fo:table-cell>
											<fo:table-cell font-family="Helvetica" font-size="7pt" font-weight="normal" padding-start="2pt" text-align="left">
												<fo:block text-decoration="underline">http://euskadi.eus/mipago</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
									</fo:table>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell vertical-align="middle" text-align="center">
								<fo:block>
									<xsl:variable name="csb" select="concat('90','507',substring(/paymentRequestData/peticionesPago/peticionPago/datosPago/emisor,1,8),substring(/paymentRequestData/peticionesPago/peticionPago/datosPago/emisor,10,3), /paymentRequestData/peticionesPago/peticionPago/datosPago/referencia, /paymentRequestData/peticionesPago/peticionPago/datosPago/periodosPago/periodoPago/identificacion, substring('0000000000',1,10 - string-length(/paymentRequestData/peticionesPago/peticionPago/datosPago/periodosPago/periodoPago/importe)), /paymentRequestData/peticionesPago/peticionPago/datosPago/periodosPago/periodoPago/importe, '0')"/>
									<xsl:variable name="csbBarCode" select="utils:getBarCodeImg($csb, '315', '110', '10')"/>
									<fo:external-graphic content-height="scale-to-fit" height="25mm"  content-width="70mm" scaling="uniform" src="{$csbBarCode}" />
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
					</fo:table>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-body>
		</fo:table>
		<!-- 7.2 - pie de la carta de pago -->
		<fo:table padding="0pt" width="100%" table-layout="fixed" space-before.optimum="4pt" space-after.optimum="4pt">
			<fo:table-column column-width="250pt"/>
			<fo:table-column column-width="250pt"/>
		<fo:table-body>
			<fo:table-row>
				<xsl:choose>
				<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id = '1']">
					<fo:table-cell font-family="Helvetica" font-size="7pt" font-weight="bold" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id='1']/texto/eu"/></fo:block>
					</fo:table-cell>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-cell font-family="Helvetica" font-size="7pt" font-weight="bold" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block>Kitapen honen ordainketa balioztatze mekanikoaren bitartez egiaztatzen da, edota Finantza-erakunde laguntzaileak egindako diru sarreraren ziurtagiriaren bidez.</fo:block>
					</fo:table-cell>
				</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
				<xsl:when test="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id = '1']">
					<fo:table-cell font-family="Helvetica" font-size="7pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block><xsl:value-of select="/paymentRequestData/peticionesPago/peticionPago/liquidacion/mensajes/mensaje[@id='1']/texto/es"/></fo:block>
					</fo:table-cell>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-cell font-family="Helvetica" font-size="7pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" text-align="justify">
						<fo:block>El pago de esta liquidación se acredita mediante validación mecánica o justificante del ingreso de la Entidad Financiera colaboradora.</fo:block>
					</fo:table-cell>
				</xsl:otherwise>
				</xsl:choose>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell number-columns-spanned="2" font-family="Helvetica" font-size="7pt" text-align="center" padding-start="3pt" padding-end="3pt" padding-before="15pt" padding-after="3pt">
					<fo:block></fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-body>
		</fo:table>
	</xsl:template>



	<!-- ********************************************************** -->
	<!-- **************** TEMPLATE PRINCIPAL ********************** -->
	<!-- ********************************************************** -->
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page-master">

				<!-- TEXTOS LATERALES DE LA IZQUIERDA DEL PDF -->
					<xsl:call-template name="subTemplate_textosLaterales"/>

				<fo:flow flow-name="xsl-region-body">
				<fo:block>
					<xsl:for-each select="paymentRequestData/peticionesPago/peticionPago">
						<fo:table border-collapse="collapse" padding="0" width="195mm" table-layout="fixed" space-before.optimum="0mm" space-after.optimum="0mm">
							<fo:table-column column-width="180mm"/>
							<fo:table-column column-width="15mm"/>
						<fo:table-body>
						
							<!-- COMIENZO LIQUIDACION-PREVIEW -->
							<!-- 1 - IMAGEN CABECERA -->
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2" padding-before="3mm" padding-start="0mm" top="0mm" width="15mm" padding-end="0mm" padding-after="3mm">
									<fo:block>
										<xsl:call-template name="subTemplate_imagenCabecera"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
									
							<!-- INICIO RECIBO -->
							<fo:table-row height="162mm">
								<fo:table-cell font-family="Helvetica" padding-after="0cm" padding-before="0cm" padding-end="0cm">
									<fo:block>
										<fo:table padding="0" width="100%" table-layout="fixed">
											<fo:table-column/>
											<fo:table-body>
											<!-- 2 - DATOS EMISOR --> <!-- la altura de los datos de emisor es cte: 4cm -->
												<fo:table-row>
													<fo:table-cell font-family="Helvetica" padding-after="0pt" padding-before="0pt" padding-end="0pt" width="180mm">
														<fo:block>
															<xsl:call-template name="subTemplate_datosEmisor"/>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											<!-- 3 - MENSAJES -->
												<fo:table-row>
													<fo:table-cell font-family="Helvetica" padding-after="0.3cm" padding-before="0.3cm"  padding-end="0pt" width="180mm">
														<fo:block>
															<xsl:call-template name="subTemplate_mensajes"/>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											<!-- 4 - CONCEPTOS -->
												<fo:table-row>
													<fo:table-cell font-family="Helvetica" padding-after="0pt" padding-before="0pt" padding-end="0pt" width="100%">
														<fo:block>											
															<xsl:call-template name="subTemplate_conceptos"/>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											<!-- 5 - INICIO CARTA DE PAGO --><!-- la altura de la carta de pago es constante -->
												<fo:table-row height="4.6cm">
													<fo:table-cell font-family="Helvetica" width="100%" padding-end="3pt" padding-before="3pt" padding-after="3pt">
														<fo:block>									
															<xsl:call-template name="subTemplate_cartaPago"/>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
										</fo:table-body>
										</fo:table>
									</fo:block>
								</fo:table-cell>
								<!-- IMAGEN LATERAL DERECHA -->
								<fo:table-cell baseline-shift="baseline" text-align="center" padding-start="0mm" padding-end="1.058mm" padding-before="0mm">
									<fo:block>
										<fo:external-graphic content-width="scale-to-fit" width="7.5mm">
											<xsl:attribute name="src"><xsl:value-of select="concat($rootDatos,'/pdf/liquidacionCuadroDerechaSup.gif')"/></xsl:attribute>
										</fo:external-graphic>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						
							<!-- ************** LINEA CENTRAL (recorte) ************** -->
							<fo:table-row>
								<fo:table-cell number-columns-spanned="2" width="195mm" padding-start="0mm" padding-end="0mm">
									<fo:block>
										<fo:external-graphic content-width="scale-to-fit" width="210mm" padding-start="-15mm" space-before.optimum="0mm" space-after.optimum="0mm">
											<xsl:attribute name="src"><xsl:value-of select="concat($rootDatos,'/pdf/liquidacionLineaCentral.gif')"/></xsl:attribute>
										</fo:external-graphic>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<!-- 6 - CABECERA 2 -->
							<fo:table-row>
								<xsl:call-template name="subTemplate_imagenCabecera2"/>
							</fo:table-row>

							<!-- 7 - CARTA DE PAGO 2 -->
							<fo:table-row>
								<fo:table-cell width="180mm" padding-end="3pt" padding-before="3pt" padding-after="3pt">
									<fo:block>
										<xsl:call-template name="subTemplate_cartaPago2"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
						</fo:table-body>
						</fo:table>
					</xsl:for-each>
				</fo:block>
			</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>

