package p12q.exe.pasarelapagos.utils.fop;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;

public class XMLTransformer {
	
	private static FopFactory fopFactory = FopFactory.newInstance();
	private static TransformerFactory tFactory = TransformerFactory.newInstance();

	/**
	 * Devuelve el PDF generado a partir de un XML y una plantilla.
	 * @param xmlReader XML
	 * @param xsltFile Plantilla
	 * @return
	 */
	public static byte[] getPDF(Reader xmlReader, File xsltFile) {    	
		try {
			R01FLog.to("p12q.transformer").info("[P12Q][FOP] Generando PDF... XMLTransformer.getPDF(...)");
    		R01FLog.to("p12q.transformer").info("[P12Q][FOP] Plantilla: " + xsltFile.getPath());

        	//Setup a buffer to obtain the content length
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer transformer;
            
            R01FLog.to("p12q.transformer").info("[P12Q][FOP] tFactory: "+tFactory.getClass().toString());
            fopFactory.setStrictValidation(false);
            //tFactory.setAttribute("disable-inlining", new Boolean(true));
            
            String xsltCharset = "ISO-8859-1"; XMLProperties.get("p12ft","xslTemplateConfig/xsltCharset"); // UTF-8
            R01FLog.to("p12q.transformer").info("[P12Q][FOP] xsltCharset: "+xsltCharset);

        	if (xsltCharset!=null && !"".equals(xsltCharset)) {
        		Map<String, String> mapVars = new HashMap<String, String>(); // valores de las variables $nombreVariable$ a sustituir en la plantilla
        			
 	   			R01FLog.to("p12q.transformer").info("[P12Q][FOP] Mapeo de $variables$ a sustituir en plantilla");
 	            NodeIterator nodeIt = XMLProperties.getPropertyNodeIterator("p12ft","xslTemplateConfig/varList/var");
 	        	for (Node n=nodeIt.nextNode(); n!=null; n=nodeIt.nextNode()) {
 	       			String strValue = n.getFirstChild().getNodeValue(); 
 	       			String strName  = n.getAttributes().getNamedItem("name").getNodeValue(); 
 	
 	       			mapVars.put(strName, strValue);
 	
 	       			R01FLog.to("p12q.transformer").info("[P12Q][FOP] - $" + strName + "$ <== " + strValue);
 	        	}
 	
 	            // Obtenemos el contenido de la plantilla XSLT...
 	            FileInputStream inStr = new FileInputStream(xsltFile);
 	            byte fileContent[] = new byte[(int)xsltFile.length()];
 	            inStr.read(fileContent);
 	            String strPlantillaXSLContent = new String(fileContent, xsltCharset); // contenido plantilla xslt
 	
 	            // Sustituimos las variables rootSrv/rootDatos/... por los valores definidos en properties...
 	            strPlantillaXSLContent = StringUtils.replaceVariableValues(strPlantillaXSLContent, "$", mapVars).trim();
 	
 	            // Al coger la plantilla del fichero a veces mete carcteres raros al principio, con esto nos aseguramos de quitarlos
 	            int indiceComienzoXML = strPlantillaXSLContent.indexOf("<?xml");
 	            strPlantillaXSLContent = strPlantillaXSLContent.substring(indiceComienzoXML);
 	            
 	            // Ahora hay que usar ese String modificado, que contiene el nuevo
 	            // contenido de la plantilla, en vez de utilizar el fichero...
 	            StringReader strReader = new StringReader(strPlantillaXSLContent); //new StringReader("...<xsl:stylesheet ...</xsl:stylesheet>");
 	            StreamSource xslStreamSource = new StreamSource(strReader);
 	
 	            //Setup Transformer
	            transformer = tFactory.newTransformer(xslStreamSource);
	            
        	} else {
        		
        		Source xsltSrc = new StreamSource(xsltFile);
        		transformer = tFactory.newTransformer(xsltSrc);
        		
        	}
        	
            //Setup FOP
            Fop fop;
			fop = fopFactory.newFop("application/pdf", out);
			
            //Make sure the XSL transformation's result is piped through to FOP
            Result res = new SAXResult(fop.getDefaultHandler());

            //Setup input
            Source src = new StreamSource(xmlReader);

            //Start the transformation and rendering process
            transformer.transform(src, res);
            
            return out.toByteArray();

        } catch (FOPException e) {
			e.printStackTrace();
        } catch (TransformerConfigurationException e) {
			e.printStackTrace();
		} catch (TransformerException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		} catch (Throwable t) {
			t.printStackTrace();
		}
        return null;
    }

}