/*
 * Created on 23-jun-2005
 * @author co01347e
 */
package p12e.exe.pasarelapagos.test;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.redirection.RequestAttrs;
import p12e.exe.pasarelapagos.redirection.SessionAttrs;
import p12f.exe.pasarelapagos.objects.Estado;
import p12f.exe.pasarelapagos.objects.Pago;
import p12f.exe.pasarelapagos.objects.PaymentData;
import p12f.exe.pasarelapagos.objects.PaymentResult;
import p12f.exe.pasarelapagos.objects.PaymentStateData;

/**
 * Servlet encargado de la realizacin de un pago en la Entidad Financiera.
 */
public class RealizarPagoServlet extends HttpServlet {

    /**
     * Constructor of the object.
     */
    public RealizarPagoServlet() {
        super();
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        doExec(request, response);
    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to post.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        doExec(request, response);
    }
    
    /**
     * The doExec method of the servlet. <br>
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doExec(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        /*
         * Recogemos los datos del pago en funcion del modo en que hayamos redirigido al
         * cliente a la aplicacin de banca electrnica.
         */		
		
		/*	Mtodo 1: Redireccin de servidor utilizando session.
		 *	  	En la llamada a setPaymentData se puso en session el objeto EFClass
		 */
        HttpSession session = request.getSession();
		EFClass ef = (EFClass)session.getAttribute(SessionAttrs.EFCLASS);
		
		/*	Mtodo 2: Redireccin de servidor sin utilizar session.
		 *		En la llamada a setPaymentData se puso en la request el objeto EFClass 
		 */ 
		//EFClass ef = (EFClass)request.getAttribute(RequestAttrs.EFCLASS);
		
		/* 	Mtodo 3: Redireccin de servidor a travs del cliente.
		 *	  	Se utiliz una redireccin de cliente para llegar a esta pgina.
		 *  	En la redireccin se pasaron como parmetro los XML y ahora hay
		 *  	que obtener de nuevo los objetos.
		 */
		//String paymentDataXML = request.getParameter(RequestParams.PAYMENT_DATA);
		//String presentationDataXML = request.getParameter(RequestParams.PRESENTATION_DATA);
		//String protocolDataXML = request.getParameter(RequestParams.PROTOCOL_DATA);
		//EFClass ef = new EFClass(paymentDataXML, presentationDataXML, protocolDataXML);
        
        // Realizar los pagos
        try{
            PaymentData paymentData = ef.getPaymentData();
            /*
             * Realizar cada uno de los pagos en una transaccin INDEPENDIENTE contra el HOST.
             * En la peticin puede llegar un slo pago o un pago mltiple, hay que realizar 
             * una transaccin de pago para cada uno de los pagos del lote.
             * El objeto PaymentData tiene un mapa con todos los pagos del lote. 
             * Si se trata de un pago sencillo unicamente hay un elemento.
             * Basta con recorrer el objeto y realizar una transaccin para cada uno.
             */
            Pago currPago = null;
            int hostResponse = -1;
            /*
             * Transaccin por cada pago del lote.
             */
            for(Iterator it = paymentData.pagos.keySet().iterator(); it.hasNext();){
                currPago = (Pago)paymentData.pagos.get(it.next());
                /*
                 * Aqu se tienen todos los datos del pago que son accesibles
                 * como un objeto Java normal, se puede acceder a los datos de
                 * cualquier miembro de los sealados en la documentacin.
                 */
                String cpr = currPago.datosPago.cpr; // CPR: Cdigo de Procedimiento Recaudatorio
                String rafaga = currPago.datosPago.codigo; // Cdigo de barras
                // ... acceder a cualquier dato del pago .. //
                try{
                    /*
                     * Aqu la entidad financiera realizaria una transaccin contra su host
                     * con los datos que considere necesarios de los que estn disponibles
                     * en el objeto de pago.
                     * Haciendo una suposicin de la llamada, suponiendo que el host devuelve
                     * nicamente un nmero indicativo del resultado (seguramente no sea
                     * un caso real... es un ejemplo)
                     */
                    hostResponse = HostEntidadFinanciera.transaccionPago(cpr, rafaga);
                }catch(Exception ex){
                    hostResponse = -30;	// Para poder marcar el error en el justificante
                    ex.printStackTrace();
                    System.out.println(">>>Error transaccion HOST " + ex.toString());
                    throw new Exception();
                }
                // Componer un objeto PaymentStateData con el resultado del pago actual.
                Estado estado = new Estado();
                if(hostResponse==0){
                    estado.codigo = PaymentStateData.PAGADO;
                    estado.numeroOperacion = "3475694534657";   
                    Date fecha = new Date();
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("ddMMyy");
                    SimpleDateFormat hourFormatter = new SimpleDateFormat("hhmmss");
                    estado.fechaPago = dateFormatter.format(fecha);
                    estado.horaPago = hourFormatter.format(fecha);
                    estado.nrc = currPago.datosPago.nrc.idLiquidacion + "12345678";
                    estado.importe = currPago.obtenerImporte();
                    estado.entidad = "0001";
                }else{
                    estado.codigo = PaymentStateData.NO_PAGADO;
                    /*
                     *	Indicar la razn del error en el pago, ya que este dato se
                     *	utiliza para componer el justificante de pago e indicar que
                     *	pagos han fallado y por qu motivo. 
                     */ 
                    if(hostResponse == -20){
                        // El emisor/sufijo no esta dado de alta en el HOST...
                        estado.razonError = PaymentStateData.NO_POSIBLE;
                    }else if(hostResponse == -30){
                        // Error tcnico general...
                        estado.razonError = PaymentStateData.GENERAL_ERROR;
                    }
                }
                /*
                 * El resultado de cada pago individual se va almacenando en un objeto que "acumula"
                 * los resultados de cada transaccin para devolver el resultado a la Pasarela de
                 * la Administracin.
                 */
                ef.setSinglePaymentResult(currPago.id, currPago.datosPago ,estado);
            } // Cada uno de los pagos
            /*
             * Una vez realizadas las transacciones individuales de pago, devolver el resultado
             * de pago a la pasarela de la Administracin.
             */            
            PaymentResult paymentResult = ef.returnPaymentResult();
            // Si no hay error, redirigimos al cliente a la pgina de emisin del justificante. 
            RequestDispatcher rd = request.getRequestDispatcher("/confirmacion.jsp");       
            rd.forward(request, response);
        }catch(Exception ex){
            ex.printStackTrace();
            System.out.println(">>> Ha ocurrido un error en la tramitacin contra el HOST " + ex.toString());
            // Si hay error, redirigimos al cliente a la pgina de error.
            RequestDispatcher rd = request.getRequestDispatcher("/error.jsp");       
            rd.forward(request, response);
        }
    }
}
