/*
 * Created on 21-jul-2005
 * @author co01347e
 */
package p12e.exe.pasarelapagos.test;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.base.FinantialOrgFunctions;
import p12e.exe.pasarelapagos.redirection.ClientRedirector;
import p12f.exe.pasarelapagos.exceptions.FinantialOrgException;
import p12f.exe.pasarelapagos.helpers.NRCHelper;
import p12f.exe.pasarelapagos.objects.Estado;
import p12f.exe.pasarelapagos.objects.PaymentData;
import p12f.exe.pasarelapagos.objects.PaymentStateData;

/**
 * Clase de implementacin de ejemplo de los mtodos de la Entidad Financiera.
 */
public class FinantialOrgFunctionsImpl implements FinantialOrgFunctions {
    
    /**
     * Mtodo que realiza las validaciones internas de la Entidad financiera. 
     * @param paymentData Datos de los pagos a realizar.
     * @return
     * @throws FinantialOrgException
     */
    public boolean doInternalValidations(PaymentData paymentData)
            throws FinantialOrgException {
        return true;
    }

    /**
     * Mtodo que devuelve una estructura PaymentStateData con los datos del pago solicitado.
     * El pago puede venir definido por:
     * 		- cpr + paymentCode: Cdigo de barras.
     * 		- nrc: El nmero de referencia nico compuesto entre la pasarela y la Entidad.
     * 				El NRC est compuesto por:
     * 					fecha | hora | numero pasarela | numero entidad financiera 
     * 				Para obtener el estado del pago, la entidad financiera nicamente
     * 				necesitar el campo [numero entidad financiera] aunque se pasan todos
     * 				los datos.
     * @param paymentId
     * @param cpr
     * @param paymentCode
     * @param nrc
     * @return
     * @throws FinantialOrgException
     */
    public Estado doGetPaymentStateData(String paymentId, 
            String cpr,
            String paymentCode, 
            String nrc) throws FinantialOrgException {
        /* 
         * Estructura que recibe los datos del Host
         */
        HostData hostData = null;	
        /*
         * Aqui la Entidad Financiera realizaria una llamada a su HOST
         */
        if(paymentCode!=null){
            /*
             * ********* CONSULTA EN BASE AL CODIGO DE BARRAS ****************
             * Se puede utilizar el objeto CSBHelper para obtener campos del CSB
             * Suponiendo que en este caso el HOST recibe toda la rafaga.
             */
            hostData = HostEntidadFinanciera.consultarPorRafaga(paymentCode);
        }else if(nrc!=null){
            /*
             * ********* CONSULTA EN BASE AL NRC ******************************
             * Se puede utilizar el objeto NRCHelper para obtener campos del NRC
             */
            String numeroOperacion = NRCHelper.getNumeroOperacionEntidadFinanciera(nrc);
            hostData = HostEntidadFinanciera.consultarPorCodigo(numeroOperacion);
        }
        /*
         * Componer un objeto Estado con el resultado del pago actual.     
         */  
        Estado estado = new Estado();
        if(hostData.estadoPago.equals("1")){
            estado.codigo = PaymentStateData.PAGADO;
            estado.numeroOperacion = hostData.numeroOperacion;
            estado.fechaPago = hostData.fechaPago;
            estado.horaPago = hostData.horaPago;
        }else if(hostData.estadoPago.equals("0")){
            estado.codigo = PaymentStateData.NO_PAGADO;
        }            
        return estado;
    }
    
    /**
     * Mtodo encargado de redirigir al cliente a la pantalla de login de la Entidad Financiera.
     * @param request
     * @param response
     * @param paymentData
     * @param presentationData
     */
    public void doRedirectClient(HttpServletRequest request,
            HttpServletResponse response, 
            String targetUrl,
            EFClass ef) {        
        ClientRedirector.doServerSessionRedirection(request, response, targetUrl, ef);
    }

}
