/*
 * Created on 17-nov-2005
 *
 * @author co01347e
 */
package p12e.exe.pasarelapagos.test;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import p12e.exe.pasarelapagos.base.EFClass;
import p12e.exe.pasarelapagos.base.FinantialOrgFunctions;

/**
 * 
 */
public class EFServlet extends HttpServlet {

    /**
     * Constructor of the object.
     */
    public EFServlet() {
        super();
    }

    /**
     * The doGet method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to get.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doExec(request, response);
    }

    /**
     * The doPost method of the servlet. <br>
     *
     * This method is called when a form has its tag value method equals to post.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doExec(request, response);
    }
    
    /**
     * The doExec method of the servlet. <br>
     *
     * This method is called from doGet and doPost methods.
     * 
     * @param request the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException if an error occurred
     */
    public void doExec(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        
        // Se recogen los parmetros de la peticin
        String module = request.getParameter("module");
        String function = request.getParameter("function");
        String paymentDataDataXML = request.getParameter("paymentData");
        String presentationDataXML = request.getParameter("presentationData");
        String protocolDataXML = request.getParameter("protocolData");
        
        // Se comprueba que mtodo remoto se ha invocado
        if(function.equals("setPaymentData")){        
            // Se instancia la clase que implementa la lgica propia de la Entidad Financiera.
            FinantialOrgFunctions fof = new FinantialOrgFunctionsImpl();
            // Se instancia un objeto de la clase EFClass
            EFClass ef = new EFClass(fof);
            try{
                // Se llama al mtodo setPaymentData()
	            ef.setPaymentData(paymentDataDataXML,
	                    presentationDataXML,
	                    protocolDataXML,
	                    request,
	                    response);
	            // Se redirige al cliente a la pgina de login de la Entidad Financiera
	            fof.doRedirectClient(request,response,"login.jsp",ef);
            }catch(Exception ex){
                ex.printStackTrace();
            }
        }
    }

}
