/*************************************************
   Copyright 2009 ELEKA Ingeniaritza Linguistikoa

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
***************************************************/

#ifndef _OCROPUSGUI_H_
#define _OCROPUSGUI_H_

#include "hunspell/hunspell.hxx"

#include "wx/app.h"
#include <wx/sizer.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/progdlg.h>
#include <wx/process.h>
#include <wx/timer.h>

#include <map>
#include <string>

#include <libxml/xpath.h>
//#include "ocropuswrapper.h"

typedef std::multimap<std::string,std::string> Reps;
typedef std::map<std::string,int> Muts;

class OCRopusGUI: public wxApp
{
public:
    virtual bool OnInit();
};

class MainDialog: public wxDialog
{
public:
    MainDialog();
    virtual ~MainDialog();

private:
    static const long ID_TEXTCTRL_IMAGE_PATH;
    static const long ID_BUTTON_BROWSE_IMAGE;
    static const long ID_TEXTCTRL_OUTFILE_PATH;
    static const long ID_BUTTON_BROWSE_OUTFILE;
    static const long ID_CHECKBOX_APPLY_SPELL_CHECKER;
    static const long ID_TIMER;
    static const long ID_PROCESS;

    wxButton* btnClose;
    wxButton* btnOcrIt;
    wxButton* btnHelp;
    wxButton* btnBrowseHtmlFile;
    wxButton* btnBrowseImage;
    wxTextCtrl* txtImagePath;
    wxTextCtrl* txtHtmlFilePath;
    wxCheckBox* chkApplySpellChecker;
    wxProgressDialog *dlgProgress;
    wxTimer timer;
    
    static wxMutex *mutex;
    
    //OCRopusWrapper *ocropus;
    int progress;
    wxProcess *ocropusprocess;
    Hunspell *lexicon;
    Reps reps;
    
    void InitSpellChecker();
    void LoadMutationFile(const char *filename);
    void ProcessOutput(wxProcess&, bool isError);
    bool SaveToOutputFile(wxArrayString &);
    bool SaveToOutputFile(const wxString&);
    //bool ApplySpellChecker(wxArrayString &);
    void Bbox2Style(xmlNodeSetPtr nodes);
    bool CorrectToken(const char *hitza, size_t pos, char **correctedWord);
    bool ReadAllLines(wxInputStream &is, wxArrayString& output);

    //void OnProcessEnd(wxProcessEvent &event);
    void OnQuit(wxCommandEvent& event);
    void OnOcrIt(wxCommandEvent& event);
    void OnBrowseImage(wxCommandEvent& event);
    void OnBrowseOutputFile(wxCommandEvent& event);
    void OnAbout(wxCommandEvent& event);
    void OnTimer(wxTimerEvent &event);

    DECLARE_EVENT_TABLE()
};

#endif
