#ifndef MIATU_HPP
#define MIATU_HPP

#ifdef WIN32
#    ifdef BUILD_DLL    // en la construccin de la librera
#        define EXPORT __declspec(dllexport)
#    else               // en la construccin del ejecutable
#        define EXPORT __declspec(dllimport)
#    endif
#else
#    define EXPORT
#endif
namespace eleka { namespace miatu {
    class EXPORT ResultIterator{
    public:
        virtual const char*
        next() = 0;
        virtual void
        close() = 0;
        virtual ~ResultIterator(){};
    };
    enum MiatuTypeIdentificator {MIATU_TYPE_BASIC, MIATU_TYPE_LAST};
    enum MiatuErrorCode {MEC_SUCCESS, MEC_LEMMATIZER_NOT_FOUND, MEC_GENERIC, MEC_LAST};
    class EXPORT Miatu{
    public:
        static Miatu*
        createInstance(int type, const char *dbdir);
        static Miatu*
        createInstance(const char *dbdir);
        virtual ~Miatu(){};
        virtual MiatuErrorCode
        error() = 0;
        virtual MiatuErrorCode
        index(const char *url, const char *filecontent, const char *mimetype) = 0;
        virtual ResultIterator *
        lookup(const char *query) = 0;
        virtual void
        close() = 0;
    };

} }
#endif
